/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Property_Function;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class Getter
extends Property_Function {
    private static final String GETTERNORETURN = "Property getter's statement block does not have a return statement";
    private static final String GETTERNORETURNMAYBE = "Control might leave the Property getter's statement block without reaching a return statement";
    private final boolean shortForm;
    private boolean isTemplate;
    private ITTCN3Template template;
    private IValue value;
    private StatementBlock statementBlock;

    public Getter(boolean isFinal, boolean isDeterministic, ITTCN3Template template) {
        super(false, isFinal, isDeterministic);
        this.shortForm = true;
        this.isTemplate = true;
        this.template = template;
        if (template == null) {
            // empty if block
        }
    }

    public Getter(boolean isFinal, boolean isDeterministic, StatementBlock statementBlock) {
        super(false, isFinal, isDeterministic);
        this.shortForm = false;
        this.isTemplate = false;
        this.statementBlock = statementBlock;
    }

    public Getter(boolean isDeterministic) {
        super(true, false, isDeterministic);
        this.shortForm = false;
        this.isTemplate = false;
        this.statementBlock = null;
    }

    @Override
    public boolean accept(ASTVisitor v) {
        return this.statementBlock == null || this.statementBlock.accept(v);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, Definition definition) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        super.check(timestamp, definition);
        if (!this.isAbstract) {
            if (this.shortForm) {
                IType type = definition.getType(timestamp);
                this.template.setMyGovernor(type);
                this.template.setMyScope(this);
                boolean bl = this.isTemplate = definition.getAssignmentType() == Assignment.Assignment_type.A_VAR_TEMPLATE;
                if (this.isTemplate) {
                    type.checkThisTemplateRef(timestamp, this.template);
                } else if (this.template.isValue(timestamp)) {
                    IValue value = this.template.getValue();
                    value.setMyGovernor(type);
                    type.checkThisValueRef(timestamp, value);
                    this.value = value;
                }
            } else {
                this.statementBlock.setParentScope(this);
                this.statementBlock.check(timestamp);
                switch (this.statementBlock.hasReturn(timestamp)) {
                    case RS_NO: {
                        this.statementBlock.getLocation().reportSemanticError(GETTERNORETURN);
                        break;
                    }
                    case RS_MAYBE: {
                        this.statementBlock.getLocation().reportSemanticError(GETTERNORETURNMAYBE);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public boolean isInGetterScope() {
        return true;
    }

    @Override
    public Getter getScopeGetter() {
        return this;
    }
}

