/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.ArrayList;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.statements.Return_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class DynamicMatch_template
extends TTCN3Template {
    private static final String MISSINGRETURN = "The dynamic template's statement block does not have a return statement";
    private static final String LEAVEWITHOUTRETURN = "Control might leave the dynamic template's statement block without reaching a return statement";
    private Reference reference;
    private StatementBlock statementBlock;
    private FormalParameterList formalParameterList;

    public DynamicMatch_template(Reference reference) {
        this.reference = reference;
        this.statementBlock = new StatementBlock();
        this.statementBlock.setDynamicTemplate(this);
        this.statementBlock.addStatement(new Return_Statement(new SpecificValue_Template(new Referenced_Value(reference))));
        if (reference != null) {
            reference.setFullNameParent(this);
        }
    }

    public DynamicMatch_template(StatementBlock block) {
        this.statementBlock = block;
        this.statementBlock.setDynamicTemplate(this);
        this.setMyScope(block);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("@dynamic ");
        if (this.reference != null) {
            builder.append(this.reference.getDisplayName());
        } else {
            builder.append("template through statement block");
        }
        return builder.toString();
    }

    @Override
    public boolean checkExpressionSelfReferenceTemplate(CompilationTimeStamp timestamp, Assignment lhs) {
        if (this.reference == null) {
            return false;
        }
        return this.reference.getRefdAssignment(timestamp, false) == lhs;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        TTCN3Template temp = this.getTemplateReferencedLast(timestamp);
        if (temp != this && !temp.getIsErroneous(timestamp)) {
            temp.checkSpecificValue(timestamp, allowOmit);
        }
    }

    @Override
    public boolean checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit, Assignment lhs) {
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        Type myType = (Type)this.statementBlock.getMyDefinition().getType(timestamp);
        FormalParameter valueParam = new FormalParameter(null, Assignment.Assignment_type.A_PAR_VAL_IN, myType, new Identifier(Identifier.Identifier_type.ID_TTCN, "value"), null, null);
        ArrayList<FormalParameter> paramList = new ArrayList<FormalParameter>();
        paramList.add(valueParam);
        FormalParameterList fpList = new FormalParameterList(paramList);
        fpList.setFullNameParent(this);
        fpList.setMyScope(this.getMyScope());
        this.setDynamicFormalParameterList(fpList);
        this.statementBlock.setValueParamList(fpList);
        this.statementBlock.getValueParamList().check(timestamp, null);
        this.statementBlock.check(timestamp);
        switch (this.statementBlock.hasReturn(timestamp)) {
            case RS_NO: {
                this.location.reportSemanticError(MISSINGRETURN);
                break;
            }
            case RS_MAYBE: {
                this.location.reportSemanticError(LEAVEWITHOUTRETURN);
                break;
            }
        }
        this.checkLengthRestriction(timestamp, type);
        if (!allowOmit && this.isIfpresent && this.location != null && !(this.location instanceof NULL_Location)) {
            this.location.reportSemanticError("`ifpresent' is not allowed here");
        }
        if (this.reference == null) {
            return false;
        }
        Assignment assignment = this.reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return false;
        }
        boolean selfReference = lhs == assignment;
        assignment.check(timestamp);
        IType governor = assignment.getType(timestamp);
        if (governor != null) {
            governor = governor.getFieldType(timestamp, this.reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
        }
        if (governor == null) {
            this.setIsErroneous(true);
        }
        return selfReference;
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        if (this.lastTimeBuilt != null && !this.lastTimeBuilt.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeBuilt = aData.getBuildTimstamp();
        String classId = aData.getTemporaryVariableName();
        String typeValue = this.myGovernor.getGenNameValue(aData, source);
    }

    public FormalParameter getDynamicFormalParameter() {
        return this.formalParameterList.getParameterByIndex(0);
    }

    public FormalParameterList getDynamicFormalParameterList() {
        return this.formalParameterList;
    }

    public StatementBlock getDynamicStatementBlock() {
        return this.statementBlock;
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.DYNAMIC_MATCH;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous dynamic match";
        }
        return "dynamic match";
    }

    public Reference getReference() {
        return this.reference;
    }

    public boolean hasReference() {
        return this.reference != null;
    }

    @Override
    public boolean hasSingleExpression() {
        return false;
    }

    @Override
    public boolean needsTemporaryReference() {
        return true;
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        this.statementBlock.setCodeSection(codeSection);
    }

    public void setDynamicFormalParameterList(FormalParameterList dynamicFormalParameterList) {
        if (dynamicFormalParameterList == null) {
            ErrorReporter.INTERNAL_ERROR((String)"DynamicMatch_template.setDynamicFormalParameterList(FormalParameterList dynamicFormalParameterList)");
        }
        this.formalParameterList = dynamicFormalParameterList;
    }

    @Override
    public void setMyDefinition(Definition definition) {
        this.statementBlock.setMyDefinition(definition);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.statementBlock.setMyScope(scope);
    }

    @Override
    public boolean accept(ASTVisitor v) {
        if (this.lengthRestriction != null && !this.lengthRestriction.accept(v)) {
            return false;
        }
        if (this.formalParameterList != null && !this.formalParameterList.accept(v)) {
            return false;
        }
        return this.statementBlock == null || this.statementBlock.accept(v);
    }
}

