/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class NumberDetectionPatternRule
implements IRule {
    private final IToken integerToken;
    private final IToken floatToken;
    private int nrRead;

    public NumberDetectionPatternRule(IToken integerToken, IToken floatToken) {
        this.integerToken = integerToken;
        this.floatToken = floatToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        StringBuffer sb = new StringBuffer();
        this.nrRead = 0;
        boolean isDot = false;
        boolean isE = false;
        int lastChar = 0;
        int c = scanner.read();
        if (this.isNumber((char)c) || (char)c == '-') {
            sb.append((char)c);
            do {
                ++this.nrRead;
                c = scanner.read();
                if ((char)c == '.') {
                    if (lastChar == 46) {
                        scanner.unread();
                        scanner.unread();
                        sb.deleteCharAt(sb.length() - 1);
                        String num = sb.toString();
                        return num.contains(".") || num.contains("E") ? this.floatToken : this.integerToken;
                    }
                } else if ((char)c == 'E') {
                    if (isE) {
                        return this.unreadScanner(scanner);
                    }
                    isE = true;
                }
                lastChar = (char)c;
                sb.append((char)c);
            } while (this.isNumber((char)c) || (char)c == '.' || (char)c == 'E' || (char)c == '-');
            scanner.unread();
            String num = sb.toString();
            return num.contains(".") || num.contains("E") ? this.floatToken : this.integerToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private IToken unreadScanner(ICharacterScanner scanner) {
        for (int i = 0; i < this.nrRead; ++i) {
            scanner.unread();
        }
        return Token.UNDEFINED;
    }
}

