/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.modulepar;

import java.util.Arrays;
import java.util.Iterator;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.CfgParseTreePrinter;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.ModuleParameterSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.modulepar.ModuleParameterDataContentProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.modulepar.ModuleParameterDataLabelProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.modulepar.ModuleParameterSectionDragSourceListener;
import org.eclipse.titan.designer.editors.configeditor.pages.modulepar.ModuleParameterSectionDropTargetListener;
import org.eclipse.titan.designer.editors.configeditor.pages.modulepar.ModuleParameterTransfer;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public final class ModuleParameterSectionPage
extends FormPage {
    private Label totalModuleParametersLabel;
    private Table moduleParametersTable;
    private TableViewer moduleParametersTableViewer;
    private Button add;
    private Button remove;
    private static final String[] COLUMN_NAMES = new String[]{"moduleName", "parameterName"};
    private ScrolledForm form;
    private final ConfigEditor editor;
    private Text parameterValueText;
    private boolean valueChanged = false;
    private ModuleParameterSectionHandler moduleParametersHandler = null;

    public ModuleParameterSectionPage(ConfigEditor editor) {
        super((FormEditor)editor, "Moduleparameters_section_page", "Module parameters");
        this.editor = editor;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        this.form.setText("Module parameters section");
        this.form.setBackgroundImage(ImageCache.getImage("form_banner.gif"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.form.getBody().setLayout((Layout)layout);
        this.createModuleParameterTable(this.form.getBody(), this.form, toolkit);
        this.createDetailsPart(this.form.getBody(), this.form, toolkit);
        this.internalRefresh();
        this.setErrorMessage();
    }

    private void createModuleParameterTable(Composite parent, final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        toolkit.paintBordersFor(client);
        this.moduleParametersTable = toolkit.createTable(client, 66306);
        this.moduleParametersTable.setEnabled(this.moduleParametersHandler != null);
        TableColumn column = new TableColumn(this.moduleParametersTable, 16384, 0);
        column.setText("Module name");
        column.setWidth(150);
        column.setMoveable(false);
        column = new TableColumn(this.moduleParametersTable, 16384, 1);
        column.setText("Module parameter name");
        column.setMoveable(false);
        column.setWidth(200);
        this.moduleParametersTable.setHeaderVisible(true);
        this.moduleParametersTable.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        gd.heightHint = 200;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.moduleParametersTable.setLayoutData((Object)gd);
        Composite buttons = toolkit.createComposite(client);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(1026));
        this.add = toolkit.createButton(buttons, "Add...", 8);
        gd = new GridData(258);
        this.add.setLayoutData((Object)gd);
        this.add.setEnabled(this.moduleParametersHandler != null);
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ModuleParameterSectionHandler.ModuleParameter newModuleParameter;
                if (ModuleParameterSectionPage.this.moduleParametersHandler == null) {
                    return;
                }
                if (ModuleParameterSectionPage.this.moduleParametersHandler.getLastSectionRoot() == null) {
                    ModuleParameterSectionPage.this.createNewModuleParameterSection();
                }
                if ((newModuleParameter = ModuleParameterSectionPage.this.createNewParameter()) == null) {
                    return;
                }
                ConfigTreeNodeUtilities.addChild((ParseTree)ModuleParameterSectionPage.this.moduleParametersHandler.getLastSectionRoot(), (ParseTree)newModuleParameter.getRoot());
                ModuleParameterSectionPage.this.moduleParametersHandler.getModuleParameters().add(newModuleParameter);
                ModuleParameterSectionPage.this.internalRefresh();
                ModuleParameterSectionPage.this.moduleParametersTableViewer.setSelection((ISelection)new StructuredSelection((Object)newModuleParameter));
                ModuleParameterSectionPage.this.parameterValueText.setText(newModuleParameter.getValue().getText());
                ModuleParameterSectionPage.this.editor.setDirty();
            }
        });
        this.remove = toolkit.createButton(buttons, "Remove", 8);
        gd = new GridData(258);
        this.remove.setLayoutData((Object)gd);
        this.remove.setEnabled(this.moduleParametersHandler != null);
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ModuleParameterSectionPage.this.moduleParametersTableViewer == null || ModuleParameterSectionPage.this.moduleParametersHandler == null) {
                    return;
                }
                ModuleParameterSectionPage.this.removeSelectedParameters();
                if (ModuleParameterSectionPage.this.moduleParametersHandler.getModuleParameters().isEmpty()) {
                    ModuleParameterSectionPage.this.removeModuleParameterSection();
                }
                ModuleParameterSectionPage.this.internalRefresh();
                ModuleParameterSectionPage.this.editor.setDirty();
            }
        });
        this.totalModuleParametersLabel = toolkit.createLabel(buttons, "Total: 0");
        gd = new GridData(258);
        this.totalModuleParametersLabel.setLayoutData((Object)gd);
        section.setText("Module parameters");
        section.setDescription("Specify the list of module parameters for this configuration.");
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        this.moduleParametersTableViewer = new TableViewer(this.moduleParametersTable);
        this.moduleParametersTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.size() != 1) {
                    ModuleParameterSectionPage.this.parameterValueText.setEnabled(false);
                    return;
                }
                ModuleParameterSectionHandler.ModuleParameter moduleParameter = (ModuleParameterSectionHandler.ModuleParameter)selection.getFirstElement();
                if (moduleParameter != null) {
                    if (moduleParameter.getValue() != null) {
                        String moduleParamValueText = CfgParseTreePrinter.toStringWithHidden((ParseTree)moduleParameter.getValue(), ModuleParameterSectionPage.this.editor.getTokens(), (boolean)false);
                        ModuleParameterSectionPage.this.parameterValueText.setText(moduleParamValueText);
                    }
                    ModuleParameterSectionPage.this.valueChanged = true;
                }
                ModuleParameterSectionPage.this.parameterValueText.setEnabled(ModuleParameterSectionPage.this.moduleParametersHandler != null && moduleParameter != null);
            }
        });
        this.moduleParametersTableViewer.setContentProvider((IContentProvider)new ModuleParameterDataContentProvider());
        this.moduleParametersTableViewer.setLabelProvider((IBaseLabelProvider)new ModuleParameterDataLabelProvider());
        this.moduleParametersTableViewer.setInput((Object)this.moduleParametersHandler);
        this.moduleParametersTableViewer.setColumnProperties(COLUMN_NAMES);
        this.moduleParametersTableViewer.setCellEditors((CellEditor[])new TextCellEditor[]{new TextCellEditor((Composite)this.moduleParametersTable), new TextCellEditor((Composite)this.moduleParametersTable)});
        this.moduleParametersTableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public String getValue(Object element, String property) {
                int columnIndex = Arrays.asList(COLUMN_NAMES).indexOf(property);
                ModuleParameterDataLabelProvider labelProvider = (ModuleParameterDataLabelProvider)ModuleParameterSectionPage.this.moduleParametersTableViewer.getLabelProvider();
                return labelProvider.getColumnText(element, columnIndex);
            }

            public void modify(Object element, String property, Object value) {
                int columnIndex = Arrays.asList(COLUMN_NAMES).indexOf(property);
                if (element != null && element instanceof TableItem && value instanceof String) {
                    ModuleParameterSectionHandler.ModuleParameter moduleParameter = (ModuleParameterSectionHandler.ModuleParameter)((TableItem)element).getData();
                    switch (columnIndex) {
                        case 0: {
                            String newValue;
                            if (moduleParameter.getModuleName() == null || (newValue = ((String)value).trim()) == null) break;
                            ConfigTreeNodeUtilities.setText((ParseTree)moduleParameter.getModuleName(), (String)newValue);
                            ConfigTreeNodeUtilities.setText((ParseTree)moduleParameter.getSeparator(), (String)("".equals(newValue) ? "" : "."));
                            break;
                        }
                        case 1: {
                            ConfigTreeNodeUtilities.setText((ParseTree)moduleParameter.getParameterName(), (String)((String)value).trim());
                            break;
                        }
                    }
                    ModuleParameterSectionPage.this.moduleParametersTableViewer.refresh((Object)moduleParameter);
                    ModuleParameterSectionPage.this.editor.setDirty();
                }
            }
        });
        this.moduleParametersTableViewer.addDragSupport(3, new Transfer[]{ModuleParameterTransfer.getInstance()}, (DragSourceListener)new ModuleParameterSectionDragSourceListener(this, this.moduleParametersTableViewer));
        this.moduleParametersTableViewer.addDropSupport(3, new Transfer[]{ModuleParameterTransfer.getInstance()}, (DropTargetListener)new ModuleParameterSectionDropTargetListener(this.moduleParametersTableViewer, this.editor));
    }

    private void createDetailsPart(Composite parent, final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        client.setLayout((Layout)layout);
        this.parameterValueText = toolkit.createText(client, "", 2818);
        this.parameterValueText.setLayoutData((Object)new GridData(1808));
        this.parameterValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StructuredSelection selection = (StructuredSelection)ModuleParameterSectionPage.this.moduleParametersTableViewer.getSelection();
                Iterator iterator = selection.iterator();
                if (!iterator.hasNext()) {
                    return;
                }
                ModuleParameterSectionHandler.ModuleParameter moduleParameter = (ModuleParameterSectionHandler.ModuleParameter)iterator.next();
                ConfigTreeNodeUtilities.setText((ParseTree)moduleParameter.getValue(), (String)ModuleParameterSectionPage.this.parameterValueText.getText());
                if (ModuleParameterSectionPage.this.valueChanged) {
                    ModuleParameterSectionPage.this.valueChanged = false;
                    return;
                }
                ModuleParameterSectionPage.this.editor.setDirty();
            }
        });
        this.parameterValueText.setEnabled(this.moduleParametersHandler != null);
        section.setText("Module parameter value");
        section.setDescription("Specify the concrete value for the actually selected module parameter.");
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
    }

    private void internalRefresh() {
        StructuredSelection selection = (StructuredSelection)this.moduleParametersTableViewer.getSelection();
        Iterator iterator = selection.iterator();
        if (iterator.hasNext()) {
            this.valueChanged = true;
        } else {
            this.parameterValueText.setText("");
        }
        this.add.setEnabled(this.moduleParametersHandler != null);
        this.remove.setEnabled(this.moduleParametersHandler != null);
        this.parameterValueText.setEnabled(this.moduleParametersHandler != null && selection.size() == 1);
        this.moduleParametersTableViewer.setInput((Object)this.moduleParametersHandler);
        this.moduleParametersTable.setEnabled(this.moduleParametersHandler != null);
        if (this.moduleParametersHandler != null) {
            this.totalModuleParametersLabel.setText("Total: " + this.moduleParametersHandler.getModuleParameters().size());
        }
    }

    public void refreshData(ModuleParameterSectionHandler moduleParametersHandler) {
        this.moduleParametersHandler = moduleParametersHandler;
        if (this.moduleParametersTableViewer != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ModuleParameterSectionPage.this.internalRefresh();
                }
            });
        }
    }

    private void createNewModuleParameterSection() {
        if (this.moduleParametersHandler == null) {
            return;
        }
        ParserRuleContext sectionRoot = new ParserRuleContext();
        this.moduleParametersHandler.setLastSectionRoot((ParseTree)sectionRoot);
        AddedParseTree header = new AddedParseTree("\n[MODULE_PARAMETERS]");
        ConfigTreeNodeUtilities.addChild((ParseTree)sectionRoot, (ParseTree)header);
        ParserRuleContext root = this.editor.getParseTreeRoot();
        if (root != null) {
            root.addChild((RuleContext)sectionRoot);
        }
    }

    public static ModuleParameterSectionHandler.ModuleParameter createNewParameter(String aModuleName, String aParameterName, String aValue) {
        ModuleParameterSectionHandler.ModuleParameter newModuleParameter = new ModuleParameterSectionHandler.ModuleParameter();
        ParserRuleContext root = new ParserRuleContext();
        newModuleParameter.setRoot((ParseTree)root);
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree("\n"));
        newModuleParameter.setModuleName((ParseTree)new AddedParseTree(aModuleName));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)newModuleParameter.getModuleName());
        boolean isModuleNameEmpty = aModuleName == null || aModuleName.isEmpty();
        newModuleParameter.setSeparator((ParseTree)new AddedParseTree(isModuleNameEmpty ? "" : "."));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)newModuleParameter.getSeparator());
        newModuleParameter.setParameterName((ParseTree)new AddedParseTree(aParameterName));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)newModuleParameter.getParameterName());
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree(" := "));
        newModuleParameter.setValue((ParseTree)new AddedParseTree(aValue));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)newModuleParameter.getValue());
        return newModuleParameter;
    }

    private ModuleParameterSectionHandler.ModuleParameter createNewParameter() {
        return ModuleParameterSectionPage.createNewParameter("module_name", "parameter_name", "value");
    }

    private void removeModuleParameterSection() {
        if (this.moduleParametersHandler == null || this.moduleParametersHandler.getLastSectionRoot() == null) {
            return;
        }
        ConfigTreeNodeUtilities.removeChild((ParseTree)this.editor.getParseTreeRoot(), (ParseTree)this.moduleParametersHandler.getLastSectionRoot());
        this.moduleParametersHandler.setLastSectionRoot(null);
    }

    public void removeSelectedParameters() {
        if (this.moduleParametersTableViewer == null || this.moduleParametersHandler == null) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)this.moduleParametersTableViewer.getSelection();
        for (ModuleParameterSectionHandler.ModuleParameter moduleParameter : selection) {
            if (moduleParameter == null) continue;
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.moduleParametersHandler.getLastSectionRoot(), (ParseTree)moduleParameter.getRoot());
            this.moduleParametersHandler.getModuleParameters().remove(moduleParameter);
        }
        this.moduleParametersTableViewer.setSelection(null);
    }

    public void setActive(boolean active) {
        this.setErrorMessage();
        if (this.moduleParametersTableViewer != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ModuleParameterSectionPage.this.internalRefresh();
                }
            });
        }
        super.setActive(active);
    }

    public void setErrorMessage() {
        if (this.form != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ModuleParameterSectionPage.this.editor.getErrorMessage() == null) {
                        ModuleParameterSectionPage.this.form.getForm().setMessage(null, 0);
                    } else {
                        ModuleParameterSectionPage.this.form.getForm().setMessage(ModuleParameterSectionPage.this.editor.getErrorMessage(), 3);
                    }
                    ModuleParameterSectionPage.this.form.getForm().getHead().layout();
                    ModuleParameterSectionPage.this.form.getForm().getHead().redraw();
                }
            });
        }
    }
}

