/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcnppeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.editors.EditorTracker;
import org.eclipse.titan.designer.editors.FoldingSupport;
import org.eclipse.titan.designer.editors.IEditorWithCarretOffset;
import org.eclipse.titan.designer.editors.ISemanticTITANEditor;
import org.eclipse.titan.designer.editors.RemoveTrailingWsOnSave;
import org.eclipse.titan.designer.editors.actions.ToggleComment;
import org.eclipse.titan.designer.editors.ttcn3editor.OutlinePage;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3FoldingSupport;
import org.eclipse.titan.designer.editors.ttcnppeditor.Configuration;
import org.eclipse.titan.designer.editors.ttcnppeditor.DocumentSetupParticipant;
import org.eclipse.titan.designer.editors.ttcnppeditor.PairMatcher;
import org.eclipse.titan.designer.editors.ttcnppeditor.ReconcilingStrategy;
import org.eclipse.titan.designer.editors.ttcnppeditor.TTCN3PPOccurrenceMarker;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.FileSaveTracker;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.GlobalProjectStructureTracker;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public final class TTCNPPEditor
extends AbstractDecoratedTextEditor
implements ISemanticTITANEditor,
IEditorWithCarretOffset {
    private static final String CONTENTASSISTPROPOSAL = "ContentAssistProposal.";
    private static final String TOGGLE_COMMENT_ACTION_ID = "org.eclipse.titan.designer.editors.ttcnppeditor.ToggleComment";
    public static final String TTCNPP_EDITOR = "org.eclipse.titan.designer.editors.ttcn3ppeditor.TTCN3PPEditor";
    public static final String EDITOR_CONTEXT = "org.eclipse.titan.designer.editors.ttcn3ppeditor.context";
    public static final String EDITOR_SCOPE = "org.eclipse.titan.designer.editors.TTCN3PPEditorScope";
    public static final String TTCNINC_EDITOR = "org.eclipse.titan.designer.editors.ttcn3ineditor.TTCN3INEditor";
    private ProjectionSupport projectionSupport;
    private List<Annotation> oldAnnotations = new ArrayList<Annotation>();
    private ProjectionAnnotationModel annotationModel;
    private ColorManager colorManager;
    private Configuration configuration;
    private ProjectionViewer projectionViewer;
    private OutlinePage outlinePage;
    private MonoReconciler reconciler;
    private Annotation[] inactiveCodeAnnotations = null;
    private static final String INACTIVE_CODE_ANNOTATION_TYPE = "org.eclipse.titan.inactive_code";
    private final TTCN3PPOccurrenceMarker occurrencesMarker;
    private final IPropertyChangeListener foldingListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("org.eclipse.titan.designer.foldingEnabledPreference".equals(property) || "org.eclipse.titan.designer.foldComments".equals(property) || "org.eclipse.titan.designer.foldStatementBlocks".equals(property) || "org.eclipse.titan.designer.foldParenthesis".equals(property) || "org.eclipse.titan.designer.distance".equals(property)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TTCNPPEditor.this.updateFoldingStructure(new TTCN3FoldingSupport().calculatePositions(TTCNPPEditor.this.getDocument()));
                    }
                });
            }
        }
    };
    private SemanticHighlightingListener semanticHighlightingListener = null;

    public TTCNPPEditor() {
        this.occurrencesMarker = new TTCN3PPOccurrenceMarker(this);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore[] stores = new IPreferenceStore[]{this.getPreferenceStore(), Activator.getDefault().getPreferenceStore()};
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(stores));
        this.colorManager = new ColorManager();
        this.configuration = new Configuration(this.colorManager, this);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.configuration);
        DocumentSetupParticipant participant = new DocumentSetupParticipant(this);
        ForwardingDocumentProvider forwardingProvider = new ForwardingDocumentProvider("__ttcnpp_partitioning", (IDocumentSetupParticipant)participant, (IDocumentProvider)new TextFileDocumentProvider());
        this.setDocumentProvider((IDocumentProvider)forwardingProvider);
        this.setEditorContextMenuId(EDITOR_CONTEXT);
        this.semanticHighlightingListener = new SemanticHighlightingListener(this);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.semanticHighlightingListener);
    }

    public boolean isSemanticCheckingDelayed() {
        IPreferencesService prefs = Platform.getPreferencesService();
        return prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.delaySemantiCheckingTillSave", false, null);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            FileSaveTracker.fileBeingSaved(file);
        }
        RemoveTrailingWsOnSave.doRemove(this.getDocument());
        super.doSave(progressMonitor);
        this.analyzeOpenedFile("Reconciliation on save", file);
    }

    private void analyzeOpenedFile(String jobname, IFile file) {
        this.analyzeOpenedFile(jobname, file, false);
    }

    private void analyzeOpenedFile(String jobname, final IFile file, final boolean waitToFinish) {
        IReconcilingStrategy strategy;
        if (file != null && this.isSemanticCheckingDelayed() && (strategy = this.reconciler.getReconcilingStrategy("__dftl_partition_content_type")) instanceof ReconcilingStrategy) {
            WorkspaceJob op = new WorkspaceJob(jobname){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
                    projectSourceParser.reportOutdating(file);
                    TITANDebugConsole.println("  ** Full reconciliation and full semantic check on save for delayed semantic checking.(ttcnpp)");
                    ((ReconcilingStrategy)strategy).analyze(true, waitToFinish);
                    return Status.OK_STATUS;
                }
            };
            op.setPriority(30);
            op.setSystem(true);
            op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
            op.schedule();
            if (waitToFinish) {
                try {
                    op.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("org.eclipse.titan.designer")) {
            this.colorManager.update(event.getProperty());
            this.invalidateTextPresentation();
            this.updateTITANIndentPrefixes();
            return true;
        }
        return super.affectsTextPresentation(event);
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        PairMatcher pairMatcher = new PairMatcher();
        support.setCharacterPairMatcher((ICharacterPairMatcher)pairMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("org.eclipse.titan.designer.matchingBracketEnabled", "org.eclipse.titan.designer.color.matchingBracket", "org.eclipse.titan.designer.matchingBracketEnabled", "org.eclipse.titan.designer.color.matchingBracket");
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction caAction = new TextOperationAction(Activator.getDefault().getResourceBundle(), CONTENTASSISTPROPOSAL, (ITextEditor)this, 13);
        String id = "org.eclipse.ui.edit.text.contentAssist.proposals";
        caAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction(CONTENTASSISTPROPOSAL, (IAction)caAction);
        this.markAsStateDependentAction(CONTENTASSISTPROPOSAL, true);
        ToggleComment tcAction = new ToggleComment(Activator.getDefault().getResourceBundle(), "ToggleComment.", this);
        tcAction.setActionDefinitionId(TOGGLE_COMMENT_ACTION_ID);
        this.setAction(TOGGLE_COMMENT_ACTION_ID, (IAction)tcAction);
        this.markAsStateDependentAction(TOGGLE_COMMENT_ACTION_ID, true);
        tcAction.configure(this.getSourceViewer(), this.getSourceViewerConfiguration());
        tcAction.setText("Toggle Comment");
        tcAction.setImageDescriptor(ImageCache.getImageDescriptor("comment.png"));
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this.outlinePage == null) {
                this.outlinePage = new OutlinePage((AbstractTextEditor)this);
            }
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        IFile file;
        this.oldAnnotations = null;
        if (this.projectionSupport != null) {
            this.projectionSupport.dispose();
        }
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
            this.outlinePage = null;
        }
        this.annotationModel = null;
        this.configuration = null;
        this.projectionViewer = null;
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.foldingListener);
        if (this.semanticHighlightingListener != null) {
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.semanticHighlightingListener);
        }
        if ((file = (IFile)this.getEditorInput().getAdapter(IFile.class)) != null) {
            EditorTracker.remove(file, this);
        }
        super.dispose();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void editorSaved() {
        super.editorSaved();
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            GlobalProjectStructureTracker.saveFile(file);
        }
    }

    @Override
    public IDocument getDocument() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        return sourceViewer.getDocument();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(this.projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        this.projectionViewer.doOperation(19);
        this.annotationModel = this.projectionViewer.getProjectionAnnotationModel();
        this.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TTCNPPEditor.this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
            }
        });
        this.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty() || !(selection instanceof TextSelection) || "".equals(((TextSelection)selection).getText())) {
                    return;
                }
                TextSelection textSelection = (TextSelection)selection;
                int offset = textSelection.getOffset() + textSelection.getLength();
                TTCNPPEditor.this.occurrencesMarker.markOccurences(TTCNPPEditor.this.getDocument(), offset);
            }
        });
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            EditorTracker.put(file, this);
        }
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        this.occurrencesMarker.markOccurences(this.getDocument(), this.getCarretOffset());
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.foldingListener);
        IContextService contextService = (IContextService)this.getEditorSite().getService(IContextService.class);
        contextService.activateContext(EDITOR_SCOPE);
        return viewer;
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "additions", TOGGLE_COMMENT_ACTION_ID);
    }

    @Override
    public void updateOutlinePage() {
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
    }

    public void refreshOutlinePage() {
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
        }
    }

    @Override
    public void updateFoldingStructure(List<Position> positions) {
        FoldingSupport.updateFoldingStructure(this.annotationModel, this.oldAnnotations, positions);
    }

    @Override
    public void invalidateTextPresentation() {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer != null) {
            viewer.invalidateTextPresentation();
        }
    }

    @Override
    public int getCarretOffset() {
        int widgetOffset = this.getSourceViewer().getTextWidget().getCaretOffset();
        return this.projectionViewer.widgetOffset2ModelOffset(widgetOffset);
    }

    public void setCarretOffset(int i) {
        int temp = this.projectionViewer.modelOffset2WidgetOffset(i);
        this.getSourceViewer().getTextWidget().setCaretOffset(temp);
    }

    protected void updateTITANIndentPrefixes() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        ISourceViewer sourceViewer = this.getSourceViewer();
        String[] types = configuration.getConfiguredContentTypes(sourceViewer);
        for (int i = 0; i < types.length; ++i) {
            String[] prefixes = configuration.getIndentPrefixes(sourceViewer, types[i]);
            if (prefixes == null || prefixes.length <= 0) continue;
            sourceViewer.setIndentPrefixes(prefixes, types[i]);
        }
    }

    public void setReconciler(MonoReconciler reconciler) {
        this.reconciler = reconciler;
    }

    public MonoReconciler getReconciler() {
        return this.reconciler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInactiveCodeAnnotations(List<Location> inactiveCodeLocations) {
        IAnnotationModel lockObject;
        if (!(inactiveCodeLocations != null && !inactiveCodeLocations.isEmpty() || this.inactiveCodeAnnotations != null && this.inactiveCodeAnnotations.length != 0)) {
            return;
        }
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput == null) {
            return;
        }
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)editorInput);
        if (annotationModel == null) {
            return;
        }
        IAnnotationModel iAnnotationModel = lockObject = annotationModel instanceof ISynchronizable ? ((ISynchronizable)annotationModel).getLockObject() : annotationModel;
        synchronized (iAnnotationModel) {
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>();
            if (inactiveCodeLocations != null) {
                for (Location location : inactiveCodeLocations) {
                    Annotation annotationToAdd = new Annotation(INACTIVE_CODE_ANNOTATION_TYPE, false, "Inactive code");
                    Position position = new Position(location.getOffset(), location.getEndOffset() - location.getOffset());
                    annotationMap.put(annotationToAdd, position);
                }
            }
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.inactiveCodeAnnotations, annotationMap);
            } else {
                if (this.inactiveCodeAnnotations != null) {
                    for (Annotation annotationToRemove : this.inactiveCodeAnnotations) {
                        annotationModel.removeAnnotation(annotationToRemove);
                    }
                }
                for (Map.Entry entry : annotationMap.entrySet()) {
                    annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
                }
            }
            this.inactiveCodeAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
        }
    }

    public static IEditorDescriptor findTTCNPPEditor(IWorkbench workbench) {
        return workbench.getEditorRegistry().findEditor(TTCNPP_EDITOR);
    }

    @Override
    public void analyzeCurrentFile(IFile file) {
        this.analyzeOpenedFile("Reconciliation on request", file, true);
    }

    public ISourceViewer getEditorSourceViewer() {
        return this.getSourceViewer();
    }

    private final class SemanticHighlightingListener
    implements IPropertyChangeListener {
        private TTCNPPEditor editor;

        SemanticHighlightingListener(TTCNPPEditor editor) {
            this.editor = editor;
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("org.eclipse.titan.designer.enableSemanticHighlighting".equals(property) || "org.eclipse.titan.designer.bracketColoringEnabled".equals(property)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISourceViewer viewer = SemanticHighlightingListener.this.editor.getEditorSourceViewer();
                        if (viewer != null) {
                            viewer.invalidateTextPresentation();
                        }
                    }
                });
            }
        }
    }
}

