/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class ExportOptionsPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Preferences of exporting project information into tpd file";
    private Composite pageComposite;
    private Group defaultExportOptionsGroup;
    private Composite exportationComposite;
    private BooleanFieldEditor excludeWorkingDirectoryContents;
    private BooleanFieldEditor excludeDotResources;
    private BooleanFieldEditor excludeLinkedContents;
    private BooleanFieldEditor saveDefaultValues;
    private BooleanFieldEditor packAllProjectsIntoOne;
    private Composite automaticExportComposite;
    private Group automaticExportGroup;
    private BooleanFieldEditor automaticExport;
    private BooleanFieldEditor requestLocation;

    public ExportOptionsPage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
    }

    protected void createFieldEditors() {
        this.pageComposite = new Composite(this.getFieldEditorParent(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.pageComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.pageComposite.setLayoutData((Object)gridData);
        this.defaultExportOptionsGroup = new Group(this.pageComposite, 64);
        this.defaultExportOptionsGroup.setText("Fine tune the amount of data saved about the project");
        this.defaultExportOptionsGroup.setLayout((Layout)new GridLayout(2, false));
        this.defaultExportOptionsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.exportationComposite = new Composite((Composite)this.defaultExportOptionsGroup, 0);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalIndent = 3;
        this.exportationComposite.setLayoutData((Object)gridData);
        this.excludeWorkingDirectoryContents = new BooleanFieldEditor("org.eclipse.titan.designer.excludeWorkingDirectoryContents", "Do not generate information on the contents of the working directory", this.exportationComposite);
        this.addField((FieldEditor)this.excludeWorkingDirectoryContents);
        this.excludeDotResources = new BooleanFieldEditor("org.eclipse.titan.designer.excludeDotResources", "Do not generate information on resources whose name starts with a `.'", this.exportationComposite);
        this.addField((FieldEditor)this.excludeDotResources);
        this.excludeLinkedContents = new BooleanFieldEditor("org.eclipse.titan.designer.excludeLinkedContents", "Do not generate information on resources which are contained in a linked resource.", this.exportationComposite);
        this.addField((FieldEditor)this.excludeLinkedContents);
        this.saveDefaultValues = new BooleanFieldEditor("org.eclipse.titan.designer.saveDefaultValues", "Save default values", this.exportationComposite);
        this.addField((FieldEditor)this.saveDefaultValues);
        this.packAllProjectsIntoOne = new BooleanFieldEditor("org.eclipse.titan.designer.packAllProjectsIntoOne", "Pack all data of related projects in this descriptor", this.exportationComposite);
        this.addField((FieldEditor)this.packAllProjectsIntoOne);
        this.automaticExportGroup = new Group(this.pageComposite, 64);
        this.automaticExportGroup.setText("Automatic export");
        this.automaticExportGroup.setLayout((Layout)new GridLayout(2, false));
        this.automaticExportGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.automaticExportComposite = new Composite((Composite)this.automaticExportGroup, 0);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalIndent = 3;
        this.automaticExportComposite.setLayoutData((Object)gridData);
        this.automaticExport = new BooleanFieldEditor("org.eclipse.titan.designer.automaticExport", "Refresh tpd file automatically on adding/deleting/renaming file/folder and on modifying project properties", this.automaticExportComposite);
        this.addField((FieldEditor)this.automaticExport);
        this.requestLocation = new BooleanFieldEditor("org.eclipse.titan.designer.requestLocation", "Request new location for the tpds at the first automatic save.", this.automaticExportComposite);
        this.addField((FieldEditor)this.requestLocation);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void dispose() {
        this.pageComposite.dispose();
        this.automaticExport.dispose();
        this.defaultExportOptionsGroup.dispose();
        this.exportationComposite.dispose();
        this.excludeWorkingDirectoryContents.dispose();
        this.excludeDotResources.dispose();
        this.automaticExportComposite.dispose();
        this.automaticExportGroup.dispose();
        this.automaticExport.dispose();
        this.requestLocation.dispose();
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.titan.designer");
        if (node != null) {
            try {
                node.flush();
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        return result;
    }
}

