/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.designer.wizards.GUIProjectImporter;
import org.eclipse.titan.designer.wizards.TITANProjectImportPage;

public class TITANProjectImportMainPage
extends WizardPage {
    private TITANProjectImportPage newProjectPage;
    private Composite pageComposite;
    private Text projectFileText;
    private Button projectFileSelectionButton;
    private String projectFile;
    private GUIProjectImporter.ProjectInformation projectInformation = null;
    private final BasicProjectSelectorListener generalListener = new BasicProjectSelectorListener();

    public TITANProjectImportMainPage(String name) {
        super(name);
    }

    public GUIProjectImporter.ProjectInformation getInformation() {
        return this.projectInformation;
    }

    public void setNewProjectPage(TITANProjectImportPage newProjectPage) {
        this.newProjectPage = newProjectPage;
    }

    public void createControl(Composite parent) {
        this.pageComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.pageComposite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        this.pageComposite.setLayoutData((Object)data);
        this.createProjectFileEditor(this.pageComposite);
        this.setControl((Control)this.pageComposite);
    }

    protected void createProjectFileEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("Original project file:");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.projectFileText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.projectFileText.setLayoutData((Object)gd);
        this.projectFileText.setFont(font);
        this.projectFileText.addModifyListener((ModifyListener)this.generalListener);
        this.projectFileSelectionButton = new Button((Composite)group, 8);
        this.projectFileSelectionButton.setText("Browse..");
        this.projectFileSelectionButton.setLayoutData((Object)new GridData());
        this.projectFileSelectionButton.addSelectionListener((SelectionListener)this.generalListener);
    }

    protected void handleProjectFileButtonSelected() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFilterPath(this.projectFileText.getText());
        dialog.setFilterExtensions(new String[]{"*.prj"});
        String file = dialog.open();
        if (file != null && !file.equals(this.projectFileText.getText())) {
            this.projectFileText.setText(file);
        }
    }

    protected void handleProjectFileModified() {
        this.projectFile = this.projectFileText.getText();
        try {
            new ProgressMonitorDialog(null).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                    progress.setTaskName("Importing the data of the project");
                    TITANProjectImportMainPage.this.checkProjectFile(progress.newChild(1));
                }
            });
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
    }

    private void checkProjectFile(SubMonitor monitor) {
        GUIProjectImporter importer = new GUIProjectImporter();
        this.projectInformation = importer.loadProjectFile(this.projectFile, monitor, false);
        if (this.newProjectPage != null && this.projectInformation != null) {
            this.newProjectPage.setInitialProjectName(this.projectInformation.getName());
            String absolutePath = PathConverter.getAbsolutePath((String)this.projectInformation.getSourceFile(), (String)this.projectInformation.getWorkingDir());
            this.newProjectPage.setWorkingDirectory(absolutePath);
        }
    }

    protected class BasicProjectSelectorListener
    implements ModifyListener,
    SelectionListener {
        protected BasicProjectSelectorListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            if (source == TITANProjectImportMainPage.this.projectFileText) {
                TITANProjectImportMainPage.this.handleProjectFileModified();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == TITANProjectImportMainPage.this.projectFileSelectionButton) {
                TITANProjectImportMainPage.this.handleProjectFileButtonSelected();
            }
        }
    }
}

