/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.readers;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.models.FilterPattern;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.readers.ILogReader;

public class FilteredLogReader
implements ILogReader {
    private final ILogReader logReader;
    private List<Integer> filteredRecords = null;
    private FilterPattern filterPattern;
    private boolean filtered = false;

    public FilteredLogReader(ILogReader logReader) throws IOException {
        this.logReader = logReader;
        this.filtered = false;
    }

    public void runFilter(FilterPattern filterPattern, IProgressMonitor monitor) throws ParseException, IOException {
        monitor.beginTask("Filtering", this.logReader.size());
        if (filterPattern == null || filterPattern.equals(this.filterPattern) || this.logReader.size() == 0) {
            monitor.done();
            return;
        }
        ArrayList<Integer> tmpFilteredRecords = new ArrayList<Integer>();
        for (int i = 0; i < this.logReader.size(); ++i) {
            LogRecord aRecord;
            if (monitor.isCanceled()) {
                monitor.done();
                return;
            }
            try {
                aRecord = this.logReader.getRecord(i);
            }
            catch (ParseException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                ParseException throwable = new ParseException("Could not parse the " + i + "th record ", 0);
                throwable.initCause(e);
                monitor.done();
                throw throwable;
            }
            if (filterPattern.match(aRecord)) {
                tmpFilteredRecords.add(i);
            }
            monitor.worked(1);
        }
        this.filtered = true;
        this.filteredRecords = tmpFilteredRecords;
        this.filterPattern = filterPattern;
        monitor.done();
    }

    @Override
    public int size() {
        return this.filtered ? this.filteredRecords.size() : this.logReader.size();
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    @Override
    public boolean contains(int id) {
        if (id < 0) {
            return false;
        }
        if (!this.filtered) {
            return this.logReader.contains(id);
        }
        return Collections.binarySearch(this.filteredRecords, id) >= 0;
    }

    @Override
    public int getPositionFromRecordNumber(int id) {
        if (this.logReader.size() == 0 || id < 0) {
            return -1;
        }
        int positionInChildReader = this.logReader.getPositionFromRecordNumber(id);
        if (this.filtered) {
            int index = Collections.binarySearch(this.filteredRecords, positionInChildReader);
            return index >= 0 ? index : -1;
        }
        return positionInChildReader;
    }

    @Override
    public LogRecord getRecord(int position) throws IOException, ParseException {
        if (this.filtered) {
            return this.logReader.getRecord(this.filteredRecords.get(position));
        }
        return this.logReader.getRecord(position);
    }

    @Override
    public LogRecord getRecordById(int id) throws IOException, ParseException {
        int position = this.getPositionFromRecordNumber(id);
        if (position == -1) {
            return null;
        }
        return this.logReader.getRecordById(id);
    }

    @Override
    public void close() {
        this.logReader.close();
    }
}

