/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.lazyfication;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.refactoring.lazyfication.LazyChecker;

class ChangeCreator {
    private final IFile selectedFile;
    private Change change;

    ChangeCreator(IFile selectedFile) {
        this.selectedFile = selectedFile;
    }

    public Change getChange() {
        return this.change;
    }

    public void perform() {
        if (this.selectedFile == null) {
            return;
        }
        this.change = this.createFileChange(this.selectedFile);
    }

    private Change createFileChange(IFile toVisit) {
        if (toVisit == null) {
            return null;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)toVisit.getProject());
        Module module = sourceParser.containedModule(toVisit);
        if (module == null) {
            return null;
        }
        DefinitionVisitor vis = new DefinitionVisitor();
        module.accept((ASTVisitor)vis);
        List nodes = vis.getLocations();
        ArrayList<Location> locations = new ArrayList<Location>();
        try {
            WorkspaceJob job1 = this.calculateEditLocations(nodes, toVisit, locations);
            job1.join();
        }
        catch (InterruptedException ie) {
            ErrorReporter.logExceptionStackTrace((Exception)ie);
        }
        catch (CoreException ce) {
            ErrorReporter.logError((String)("LazyficationRefactoring: CoreException while calculating edit locations in " + toVisit.getName() + "."));
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        if (locations.isEmpty()) {
            return null;
        }
        TextFileChange tfc = new TextFileChange(toVisit.getName(), toVisit);
        MultiTextEdit rootEdit = new MultiTextEdit();
        tfc.setEdit((TextEdit)rootEdit);
        for (Location l : locations) {
            rootEdit.addChild((TextEdit)new InsertEdit(l.getOffset(), "@lazy "));
        }
        return tfc;
    }

    private WorkspaceJob calculateEditLocations(final List<FormalParameter> fparamlist, final IFile file, final List<Location> locations_out) throws CoreException {
        WorkspaceJob job = new WorkspaceJob("LazyficationRefactoring: calculate edit locations"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                for (FormalParameter fparam : fparamlist) {
                    TITANDebugConsole.println((String[])new String[]{"reading: " + file.getName()});
                    Location typeloc = fparam.getType(CompilationTimeStamp.getBaseTimestamp()).getLocation();
                    locations_out.add(0, new Location(fparam.getLocation().getFile(), fparam.getLocation().getLine(), typeloc.getOffset(), typeloc.getOffset()));
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return job;
    }

    private class DefinitionVisitor
    extends ASTVisitor {
        private final LazyChecker lazychecker = new LazyChecker();

        DefinitionVisitor() {
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Definition && this.isGoodType(node)) {
                this.lazychecker.process(node);
            }
            return 3;
        }

        private boolean isGoodType(IVisitableNode node) {
            return node instanceof Def_Altstep || node instanceof Def_Function || node instanceof Def_Testcase;
        }

        private List<FormalParameter> getLocations() {
            return this.lazychecker.getLazyParameterList();
        }
    }
}

