/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.scope.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.statements.Alt_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.For_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.While_Statement;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.scope.MinimizeScopeRefactoring;
import org.eclipse.titanium.refactoring.scope.nodes.BlockNode;
import org.eclipse.titanium.refactoring.scope.nodes.Edit;
import org.eclipse.titanium.refactoring.scope.nodes.Reference;
import org.eclipse.titanium.refactoring.scope.nodes.StatementNode;
import org.eclipse.titanium.refactoring.scope.nodes.Variable;

public class Environment {
    private final MinimizeScopeRefactoring.Settings settings;
    private BlockNode rootNode;
    private final List<Variable> vars = new ArrayList<Variable>();

    public Environment(MinimizeScopeRefactoring.Settings settings) {
        this.settings = settings;
    }

    public BlockNode getRootNode() {
        return this.rootNode;
    }

    public List<Variable> getVars() {
        return this.vars;
    }

    public void setRootNode(BlockNode rootNode) {
        this.rootNode = rootNode;
    }

    public void addVariable(Variable var) {
        this.vars.add(var);
    }

    public Variable getVariable(Assignment as) {
        for (Variable var : this.vars) {
            if (!var.definition.equals(as)) continue;
            return var;
        }
        return null;
    }

    public List<Edit> refactor() {
        ArrayList<Edit> edits = new ArrayList<Edit>();
        ListIterator<Variable> it = this.vars.listIterator(this.vars.size());
        while (it.hasPrevious()) {
            Edit e;
            Variable var = it.previous();
            if (var.isParameter || (e = this.refactorVar(var)) == null) continue;
            edits.add(e);
        }
        return edits;
    }

    private Edit refactorVar(Variable var) {
        StatementNode declSt = var.getDeclaration();
        if (this.settings.getSetting(8) && declSt.hasFunctionCall()) {
            return null;
        }
        if (this.settings.getSetting(4) && var.getReferences().isEmpty()) {
            if (!declSt.getParent().getStatements().remove(declSt)) {
                ErrorReporter.logError((String)"Environment.refactorVar(): Parent block did not contain the statement to remove! ");
            }
            Set<Variable> refs = declSt.getReferredVars();
            for (Variable v : refs) {
                v.removeReference(declSt);
            }
            return new Edit(declSt, null);
        }
        if (var.getReferences().isEmpty()) {
            return null;
        }
        if (!this.settings.getSetting(1)) {
            return null;
        }
        if (this.settings.getSetting(32) && var.getDeclaration().isMultiDeclaration()) {
            return null;
        }
        BlockNode currScope = declSt.getParent();
        BlockNode newScope = this.findSmallestCommonAncestorBlock(var.references);
        while (newScope != null && !newScope.equals(currScope) && Environment.isLoopScope(newScope)) {
            newScope = newScope.getParent() == null ? null : newScope.getParent().getParent();
        }
        if (newScope == null) {
            return null;
        }
        if (!this.settings.getSetting(2) && newScope.equals(currScope)) {
            return null;
        }
        if (declSt.hasUncheckedRef && this.settings.getSetting(16)) {
            return null;
        }
        StatementNode insertionPoint = this.findInsertionPointInScope(var, currScope, newScope);
        newScope = insertionPoint.getParent();
        if (!this.settings.getSetting(2) && newScope.equals(currScope)) {
            return null;
        }
        int declInd = declSt.getParent().getStatements().indexOf(declSt);
        if (declInd == declSt.getParent().getStatements().size() - 1) {
            String errmsg = "variable " + declSt.declaredVar.toString() + ", loc: " + Utils.createLocationString(declSt.astNode);
            ErrorReporter.logError((String)("Environment.refactorVar(): Declaration statement is the last one in the block: " + errmsg));
            return null;
        }
        StatementNode currNextSt = declSt.getParent().getStatements().get(declInd + 1);
        if (currNextSt.equals(insertionPoint)) {
            return null;
        }
        declSt.getParent().getStatements().remove(declSt);
        declSt.setParent(newScope);
        int insertionInd = newScope.getStatements().indexOf(insertionPoint);
        newScope.getStatements().add(insertionInd, declSt);
        declSt.setMoved();
        this.updateReferencePositions(declSt);
        return new Edit(declSt, insertionPoint);
    }

    private BlockNode findSmallestCommonAncestorBlock(List<Reference> refs) {
        if (refs.isEmpty()) {
            ErrorReporter.logError((String)"Environment.findSmallestCommonScope(): Statements list is empty! ");
            return null;
        }
        BlockNode currScope = refs.get((int)0).getRef().parent;
        block0: while (currScope != null) {
            ListIterator<Reference> it = refs.listIterator();
            while (it.hasNext()) {
                StatementNode currRef = it.next().getRef();
                if (currRef.parent.equals(currScope) || currRef.isBlockAncestorOfThis(currScope)) continue;
                currScope = currScope.parent == null ? null : currScope.parent.parent;
                continue block0;
            }
            return currScope;
        }
        ErrorReporter.logError((String)"Environment.findSmallestCommonAncestorBlock(): No common scope was found. ");
        return currScope;
    }

    private StatementNode findInsertionPointInScope(Variable var, BlockNode oldScope, BlockNode newScope) {
        if (var.getReferences().isEmpty()) {
            ErrorReporter.logError((String)"Environment.findInsertionPointInScope(): Parent block did not contain the statement to remove! ");
            return null;
        }
        StatementNode firstRef = var.getReferences().get(0).getRef();
        StatementNode insertionPoint = newScope.findStmtInBlockWhichContainsNode(firstRef);
        if (!var.declaration.getReferredVars().isEmpty()) {
            StatementNode declSt = var.getDeclaration();
            Set<Variable> refdVars = declSt.getReferredVars();
            Reference firstLeftRref = null;
            block0: for (Variable rvar : refdVars) {
                List<Reference> rrefs = rvar.getReferences();
                int declRefInd = Reference.indexOf(declSt, rrefs);
                if (declRefInd < 0) {
                    ErrorReporter.logError((String)("Environment.findInsertionPointInScope(): Ref in other vars decl stmt is not present in the ref list! var: " + var + "; rvar: " + rvar + "; loc: " + Utils.createLocationString(newScope.astNode)));
                    continue;
                }
                for (int i = declRefInd + 1; i < rrefs.size(); ++i) {
                    if (!rrefs.get(i).isLeftHandSide()) continue;
                    if (firstLeftRref == null) {
                        firstLeftRref = rrefs.get(i);
                        continue block0;
                    }
                    if (rrefs.get(i).getRef().compareCurrentPositionTo(firstLeftRref.getRef()) >= 0) continue block0;
                    firstLeftRref = rrefs.get(i);
                    continue block0;
                }
            }
            if (firstLeftRref == null) {
                return insertionPoint;
            }
            int result = insertionPoint.compareCurrentPositionTo(firstLeftRref.getRef());
            if (result < 0) {
                return insertionPoint;
            }
            BlockNode lhsScope = firstLeftRref.getRef().getParent();
            BlockNode commonScope = newScope.findSmallestCommonAncestorBlock(lhsScope);
            while (commonScope != null && !commonScope.equals(oldScope) && Environment.isLoopScope(commonScope)) {
                commonScope = commonScope.getParent() == null ? null : commonScope.getParent().getParent();
            }
            if (commonScope == null) {
                ErrorReporter.logError((String)("Environment.findInsertionPointInScope(): Given new scope of variable and the scope of  the first lhs ref of a referred var has a null common smallest ancestor block! var: " + var + "; loc: " + Utils.createLocationString(newScope.astNode)));
            }
            insertionPoint = commonScope.findStmtInBlockWhichContainsNode(firstLeftRref.getRef());
            return insertionPoint;
        }
        return insertionPoint;
    }

    private void updateReferencePositions(StatementNode declSt) {
        Set<Variable> refdVars = declSt.getReferredVars();
        for (Variable v : refdVars) {
            List<Reference> refsToV = v.getReferences();
            int refInDeclOldInd = Reference.indexOf(declSt, refsToV);
            boolean refInDeclLhs = refsToV.get(refInDeclOldInd).isLeftHandSide();
            refsToV.remove(refInDeclOldInd);
            int refInDeclNewInd = refsToV.size();
            for (int i = refInDeclOldInd; i < refsToV.size(); ++i) {
                StatementNode currSt = refsToV.get(i).getRef();
                int compareSts = currSt.compareCurrentPositionTo(declSt);
                if (compareSts != 1) continue;
                refInDeclNewInd = i;
            }
            refsToV.add(refInDeclNewInd, new Reference(declSt, refInDeclLhs));
        }
    }

    private static boolean isLoopScope(BlockNode scope) {
        StatementNode parentSN = scope.getParent();
        if (parentSN == null) {
            return false;
        }
        IVisitableNode scopeSt = parentSN.getAstNode();
        return scopeSt instanceof For_Statement || scopeSt instanceof While_Statement || scopeSt instanceof Alt_Statement;
    }

    public String toStringRecursive() {
        StringBuilder sb = new StringBuilder();
        sb.append("Env {\n").append("  vars:\n");
        for (Variable var : this.vars) {
            sb.append(var.toStringRecursive(false, 4)).append('\n');
        }
        sb.append("  TREE:\n");
        if (this.rootNode != null) {
            sb.append(this.rootNode.toStringRecursive(true, 4)).append('\n');
        }
        sb.append("}\n");
        return sb.toString();
    }
}

