/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.trace4cps.analysis.mtl.InformativePrefix;
import org.eclipse.trace4cps.analysis.mtl.MtlChecker;
import org.eclipse.trace4cps.analysis.mtl.MtlFuture;
import org.eclipse.trace4cps.analysis.mtl.MtlResult;
import org.eclipse.trace4cps.analysis.mtl.State;
import org.eclipse.trace4cps.analysis.signal.impl.PsopHelper;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.IInterval;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.impl.Event;
import org.eclipse.trace4cps.core.impl.Interval;
import org.eclipse.trace4cps.tl.FormulaBuilder;
import org.eclipse.trace4cps.tl.FormulaBuilderException;
import org.eclipse.trace4cps.tl.FormulaHelper;
import org.eclipse.trace4cps.tl.VerificationResult;
import org.eclipse.trace4cps.tl.etl.EtlModel;
import org.eclipse.trace4cps.tl.etl.Signal;
import org.eclipse.trace4cps.tl.etl.SignalDef;
import org.eclipse.trace4cps.tl.etl.TraceSignal;

public class VerificationHelper {
    private final ITrace trace;
    private final EtlModel model;
    private final VerificationResult verificationResult;
    private final List<State> states;
    private final Map<String, IPsop> signalMap;
    private final IInterval dom;
    private final int numInjectedStates;

    public VerificationHelper(ITrace trace, EtlModel model) throws FormulaBuilderException {
        this.trace = trace;
        this.model = model;
        this.signalMap = FormulaHelper.createSignalMap(trace, FormulaBuilder.get(model, SignalDef.class), false);
        this.dom = this.computeCommonTimeDomain(this.signalMap.values());
        if (this.dom.isEmpty()) {
            throw new FormulaBuilderException("Events and signals used have no common time domain");
        }
        this.addDerivedSignals();
        this.states = this.projectDiscreteStates();
        if (this.states.isEmpty()) {
            throw new FormulaBuilderException("No states on " + this.dom);
        }
        this.numInjectedStates = FormulaHelper.hasMixedCheck(model) ? this.injectSamplingStates() : 0;
        this.verificationResult = new FormulaBuilder(trace, this.signalMap, model).create();
    }

    public IInterval getTimeDomainForVerification() {
        return this.dom;
    }

    public boolean statesInjected() {
        return this.numInjectedStates > 0;
    }

    public int getNumInjectedStates() {
        return this.numInjectedStates;
    }

    public VerificationResult run() throws InterruptedException, ExecutionException {
        MtlChecker engine = new MtlChecker();
        HashSet<InformativePrefix> counterExamples = new HashSet<InformativePrefix>();
        counterExamples.add(InformativePrefix.GOOD);
        counterExamples.add(InformativePrefix.BAD);
        counterExamples.add(InformativePrefix.NON_INFORMATIVE);
        MtlFuture f = engine.checkAll(this.states, this.verificationResult.getChecks(), counterExamples, true);
        for (MtlResult checkResult : f.get()) {
            this.verificationResult.setResult(checkResult);
        }
        return this.verificationResult;
    }

    private void addDerivedSignals() throws FormulaBuilderException {
        for (SignalDef signalDef : FormulaBuilder.get(this.model, SignalDef.class)) {
            Signal signal = signalDef.getSignal();
            if (signal instanceof TraceSignal) continue;
            IPsop psop = FormulaHelper.getDerivedSignal(this.trace, signal);
            if (psop != null && !psop.getFragments().isEmpty()) {
                PsopHelper.projectTo((IPsop)psop, (IInterval)this.dom);
                this.signalMap.put(signalDef.getName(), psop);
                continue;
            }
            throw new FormulaBuilderException("Psop for " + signalDef.getName() + " is empty on domain " + this.dom);
        }
    }

    private List<State> projectDiscreteStates() {
        ArrayList<State> states = new ArrayList<State>();
        for (State state : this.trace.getEvents()) {
            if (!this.dom.contains(state.getTimestamp())) continue;
            states.add(state);
        }
        return states;
    }

    private int injectSamplingStates() {
        int cnt = 0;
        double domWidth = this.dom.ub().doubleValue() - this.dom.lb().doubleValue();
        double stepSize = domWidth / 10000.0;
        int i = 0;
        while (i < this.states.size() - 1) {
            State si = this.states.get(i);
            State sj = this.states.get(i + 1);
            double delta = sj.getTimestamp().doubleValue() - si.getTimestamp().doubleValue();
            if (delta > stepSize) {
                long k = Math.round(Math.floor(delta / stepSize));
                int j = 0;
                while ((long)j < k) {
                    double t = si.getTimestamp().doubleValue() + (double)(j + 1) * stepSize;
                    if (t < sj.getTimestamp().doubleValue()) {
                        this.states.add(i + 1 + j, (State)new Event((Number)t));
                        ++cnt;
                    }
                    ++j;
                }
                i = (int)((long)i + k);
            }
            ++i;
        }
        return cnt;
    }

    private IInterval computeCommonTimeDomain(Collection<IPsop> psops) {
        Interval dom = new Interval(((IEvent)this.trace.getEvents().get(0)).getTimestamp(), false, ((IEvent)this.trace.getEvents().get(this.trace.getEvents().size() - 1)).getTimestamp(), false);
        for (IPsop p : psops) {
            dom = Interval.intersect((Interval)dom, (Interval)PsopHelper.dom((IPsop)p));
        }
        return dom;
    }
}

