/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.widgets.timegraph.model;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.junit.Assert;
import org.junit.Test;

public class TimeGraphEntryTest {
    private static final String NAME = "name";

    @Test
    public void testAddEvent() {
        TimeGraphEntry entry = new TimeGraphEntry(NAME, -1L, -1L);
        TimeEvent event1 = new TimeEvent((ITimeGraphEntry)entry, 0L, 10L, 1);
        TimeEvent event2 = new TimeEvent((ITimeGraphEntry)entry, 10L, 10L, 2);
        entry.addEvent((ITimeEvent)event1);
        entry.addEvent((ITimeEvent)event2);
        Assert.assertEquals((long)0L, (long)entry.getStartTime());
        Assert.assertEquals((long)20L, (long)entry.getEndTime());
        TimeGraphEntryTest.assertIteratorsEqual((Iterator<ITimeEvent>)Iterators.forArray((Object[])new ITimeEvent[]{event1, event2}), entry.getTimeEventsIterator());
    }

    @Test
    public void testAddEventReplaceLast() {
        TimeGraphEntry entry = new TimeGraphEntry(NAME, -1L, -1L);
        TimeEvent event1 = new TimeEvent((ITimeGraphEntry)entry, 0L, 10L, 1);
        TimeEvent event2 = new TimeEvent((ITimeGraphEntry)entry, 10L, 10L, 2);
        TimeEvent event3a = new TimeEvent((ITimeGraphEntry)entry, 20L, 5L, 3);
        TimeEvent event3 = new TimeEvent((ITimeGraphEntry)entry, 20L, 10L, 3);
        entry.addEvent((ITimeEvent)event1);
        entry.addEvent((ITimeEvent)event2);
        entry.addEvent((ITimeEvent)event3a);
        entry.addEvent((ITimeEvent)event3);
        Assert.assertEquals((long)0L, (long)entry.getStartTime());
        Assert.assertEquals((long)30L, (long)entry.getEndTime());
        TimeGraphEntryTest.assertIteratorsEqual((Iterator<ITimeEvent>)Iterators.forArray((Object[])new ITimeEvent[]{event1, event2, event3}), entry.getTimeEventsIterator());
    }

    @Test
    public void testAddEventNulls() {
        TimeGraphEntry entry = new TimeGraphEntry(NAME, -1L, -1L);
        NullTimeEvent event1 = new NullTimeEvent((ITimeGraphEntry)entry, 0L, 10L);
        TimeEvent event2 = new TimeEvent((ITimeGraphEntry)entry, 10L, 10L, 2);
        NullTimeEvent event3 = new NullTimeEvent((ITimeGraphEntry)entry, 20L, 10L);
        entry.addEvent((ITimeEvent)event1);
        entry.addEvent((ITimeEvent)event2);
        entry.addEvent((ITimeEvent)event3);
        Assert.assertEquals((long)10L, (long)entry.getStartTime());
        Assert.assertEquals((long)20L, (long)entry.getEndTime());
        TimeGraphEntryTest.assertIteratorsEqual((Iterator<ITimeEvent>)Iterators.forArray((Object[])new ITimeEvent[]{event1, event2, event3}), entry.getTimeEventsIterator());
    }

    @Test
    public void testaddZoomedEvent() {
        TimeGraphEntry entry = new TimeGraphEntry(NAME, -1L, -1L);
        TimeEvent event1 = new TimeEvent((ITimeGraphEntry)entry, 0L, 10L, 1);
        TimeEvent event2 = new TimeEvent((ITimeGraphEntry)entry, 10L, 10L, 2);
        entry.addZoomedEvent((ITimeEvent)event1);
        entry.addZoomedEvent((ITimeEvent)event2);
        Assert.assertEquals((long)0L, (long)entry.getStartTime());
        Assert.assertEquals((long)20L, (long)entry.getEndTime());
        TimeGraphEntryTest.assertIteratorsEqual((Iterator<ITimeEvent>)Iterators.forArray((Object[])new ITimeEvent[]{event1, event2}), entry.getTimeEventsIterator());
    }

    @Test
    public void testaddZoomedEventDuplicate() {
        TimeGraphEntry entry = new TimeGraphEntry(NAME, -1L, -1L);
        TimeEvent event1 = new TimeEvent((ITimeGraphEntry)entry, 0L, 10L, 1);
        TimeEvent event2 = new TimeEvent((ITimeGraphEntry)entry, 10L, 10L, 2);
        TimeEvent event3 = new TimeEvent((ITimeGraphEntry)entry, 20L, 10L, 3);
        entry.addZoomedEvent((ITimeEvent)event1);
        entry.addZoomedEvent((ITimeEvent)event2);
        entry.addZoomedEvent((ITimeEvent)event1);
        entry.addZoomedEvent((ITimeEvent)event2);
        entry.addZoomedEvent((ITimeEvent)event3);
        Assert.assertEquals((long)0L, (long)entry.getStartTime());
        Assert.assertEquals((long)30L, (long)entry.getEndTime());
        TimeGraphEntryTest.assertIteratorsEqual((Iterator<ITimeEvent>)Iterators.forArray((Object[])new ITimeEvent[]{event1, event2, event3}), entry.getTimeEventsIterator());
    }

    @Test
    public void testaddZoomedEventReplaceLast() {
        TimeGraphEntry entry = new TimeGraphEntry(NAME, -1L, -1L);
        TimeEvent event1 = new TimeEvent((ITimeGraphEntry)entry, 0L, 10L, 1);
        TimeEvent event2 = new TimeEvent((ITimeGraphEntry)entry, 10L, 10L, 2);
        TimeEvent event3a = new TimeEvent((ITimeGraphEntry)entry, 20L, 5L, 3);
        TimeEvent event3 = new TimeEvent((ITimeGraphEntry)entry, 20L, 10L, 3);
        entry.addZoomedEvent((ITimeEvent)event1);
        entry.addZoomedEvent((ITimeEvent)event2);
        entry.addZoomedEvent((ITimeEvent)event3a);
        entry.addZoomedEvent((ITimeEvent)event1);
        entry.addZoomedEvent((ITimeEvent)event2);
        entry.addZoomedEvent((ITimeEvent)event3);
        Assert.assertEquals((long)0L, (long)entry.getStartTime());
        Assert.assertEquals((long)30L, (long)entry.getEndTime());
        TimeGraphEntryTest.assertIteratorsEqual((Iterator<ITimeEvent>)Iterators.forArray((Object[])new ITimeEvent[]{event1, event2, event3}), entry.getTimeEventsIterator());
    }

    @Test
    public void testAddZoomedEventNulls() {
        TimeGraphEntry entry = new TimeGraphEntry(NAME, -1L, -1L);
        NullTimeEvent event1 = new NullTimeEvent((ITimeGraphEntry)entry, 0L, 10L);
        TimeEvent event2 = new TimeEvent((ITimeGraphEntry)entry, 10L, 10L, 2);
        NullTimeEvent event3 = new NullTimeEvent((ITimeGraphEntry)entry, 20L, 10L);
        entry.addZoomedEvent((ITimeEvent)event1);
        entry.addZoomedEvent((ITimeEvent)event2);
        entry.addZoomedEvent((ITimeEvent)event3);
        Assert.assertEquals((long)10L, (long)entry.getStartTime());
        Assert.assertEquals((long)20L, (long)entry.getEndTime());
        TimeGraphEntryTest.assertIteratorsEqual((Iterator<ITimeEvent>)Iterators.forArray((Object[])new ITimeEvent[]{event1, event2, event3}), entry.getTimeEventsIterator());
    }

    @Test
    public void testaddZoomedEventPartialRestart() {
        TimeGraphEntry entry = new TimeGraphEntry(NAME, -1L, -1L);
        TimeEvent event1 = new TimeEvent((ITimeGraphEntry)entry, 0L, 10L, 1);
        TimeEvent event2 = new TimeEvent((ITimeGraphEntry)entry, 10L, 10L, 2);
        TimeEvent event3 = new TimeEvent((ITimeGraphEntry)entry, 20L, 10L, 3);
        entry.addZoomedEvent((ITimeEvent)event2);
        entry.addZoomedEvent((ITimeEvent)event3);
        entry.addZoomedEvent((ITimeEvent)event1);
        entry.addZoomedEvent((ITimeEvent)event2);
        entry.addZoomedEvent((ITimeEvent)event3);
        Assert.assertEquals((long)0L, (long)entry.getStartTime());
        Assert.assertEquals((long)30L, (long)entry.getEndTime());
        TimeGraphEntryTest.assertIteratorsEqual((Iterator<ITimeEvent>)Iterators.forArray((Object[])new ITimeEvent[]{event1, event2, event3}), entry.getTimeEventsIterator());
    }

    @Test
    public void testGetTimeEventsIteratorMixed() {
        TimeGraphEntry entry = new TimeGraphEntry(NAME, -1L, -1L);
        TimeEvent event1 = new TimeEvent((ITimeGraphEntry)entry, 0L, 10L, 1);
        TimeEvent event2 = new TimeEvent((ITimeGraphEntry)entry, 10L, 10L, 2);
        TimeEvent event3 = new TimeEvent((ITimeGraphEntry)entry, 20L, 10L, 3);
        TimeEvent event2a = new TimeEvent((ITimeGraphEntry)entry, 10L, 5L, 4);
        TimeEvent event2b = new TimeEvent((ITimeGraphEntry)entry, 15L, 5L, 5);
        entry.addEvent((ITimeEvent)event1);
        entry.addEvent((ITimeEvent)event2);
        entry.addEvent((ITimeEvent)event3);
        entry.addZoomedEvent((ITimeEvent)event2a);
        entry.addZoomedEvent((ITimeEvent)event2b);
        Assert.assertEquals((long)0L, (long)entry.getStartTime());
        Assert.assertEquals((long)30L, (long)entry.getEndTime());
        TimeGraphEntryTest.assertIteratorsEqual((Iterator<ITimeEvent>)Iterators.forArray((Object[])new ITimeEvent[]{event1, event2a, event2b, event3}), entry.getTimeEventsIterator());
    }

    @Test
    public void testGetTimeEventsIteratorMixedSplit() {
        TimeGraphEntry entry = new TimeGraphEntry(NAME, -1L, -1L);
        TimeEvent event1 = new TimeEvent((ITimeGraphEntry)entry, 0L, 10L, 1);
        TimeEvent event2 = new TimeEvent((ITimeGraphEntry)entry, 10L, 10L, 2);
        TimeEvent event3 = new TimeEvent((ITimeGraphEntry)entry, 20L, 10L, 3);
        TimeEvent event2a = new TimeEvent((ITimeGraphEntry)entry, 5L, 10L, 4);
        TimeEvent event2b = new TimeEvent((ITimeGraphEntry)entry, 15L, 10L, 5);
        TimeEvent event1s = new TimeEvent((ITimeGraphEntry)entry, 0L, 5L, 1);
        TimeEvent event3s = new TimeEvent((ITimeGraphEntry)entry, 25L, 5L, 3);
        entry.addEvent((ITimeEvent)event1);
        entry.addEvent((ITimeEvent)event2);
        entry.addEvent((ITimeEvent)event3);
        entry.addZoomedEvent((ITimeEvent)event2a);
        entry.addZoomedEvent((ITimeEvent)event2b);
        Assert.assertEquals((long)0L, (long)entry.getStartTime());
        Assert.assertEquals((long)30L, (long)entry.getEndTime());
        TimeGraphEntryTest.assertIteratorsEqual((Iterator<ITimeEvent>)Iterators.forArray((Object[])new ITimeEvent[]{event1s, event2a, event2b, event3s}), entry.getTimeEventsIterator());
    }

    @Test
    public void testAddChild() {
        TimeGraphEntry parent = new TimeGraphEntry("parent", -1L, -1L);
        TimeGraphEntry child = new TimeGraphEntry("child", -1L, -1L);
        parent.addChild(child);
        Assert.assertEquals(null, (Object)parent.getParent());
        Assert.assertEquals(Arrays.asList(child), (Object)parent.getChildren());
        Assert.assertEquals((Object)parent, (Object)child.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)child.getChildren());
    }

    @Test
    public void testAddChildAtPosition() {
        TimeGraphEntry parent = new TimeGraphEntry("parent", -1L, -1L);
        TimeGraphEntry child1 = new TimeGraphEntry("child1", -1L, -1L);
        TimeGraphEntry child2 = new TimeGraphEntry("child2", -1L, -1L);
        parent.addChild(0, child1);
        parent.addChild(0, child2);
        Assert.assertEquals(null, (Object)parent.getParent());
        Assert.assertEquals(Arrays.asList(child2, child1), (Object)parent.getChildren());
        Assert.assertEquals((Object)parent, (Object)child1.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)child1.getChildren());
        Assert.assertEquals((Object)parent, (Object)child2.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)child2.getChildren());
    }

    @Test
    public void testAddChildSameParent() {
        TimeGraphEntry parent = new TimeGraphEntry("parent", -1L, -1L);
        TimeGraphEntry child = new TimeGraphEntry("child", -1L, -1L);
        parent.addChild(child);
        parent.addChild(child);
        Assert.assertEquals(null, (Object)parent.getParent());
        Assert.assertEquals(Arrays.asList(child), (Object)parent.getChildren());
        Assert.assertEquals((Object)parent, (Object)child.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)child.getChildren());
    }

    @Test
    public void testAddChildOtherParent() {
        TimeGraphEntry parent1 = new TimeGraphEntry("parent1", -1L, -1L);
        TimeGraphEntry parent2 = new TimeGraphEntry("parent2", -1L, -1L);
        TimeGraphEntry child = new TimeGraphEntry("child", -1L, -1L);
        parent1.addChild(child);
        parent2.addChild(child);
        Assert.assertEquals(null, (Object)parent1.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)parent1.getChildren());
        Assert.assertEquals(null, (Object)parent2.getParent());
        Assert.assertEquals(Arrays.asList(child), (Object)parent2.getChildren());
        Assert.assertEquals((Object)parent2, (Object)child.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)child.getChildren());
    }

    @Test
    public void testRemoveChild() {
        TimeGraphEntry parent = new TimeGraphEntry("parent", -1L, -1L);
        TimeGraphEntry child = new TimeGraphEntry("child", -1L, -1L);
        parent.addChild(child);
        parent.removeChild(child);
        Assert.assertEquals(null, (Object)parent.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)parent.getChildren());
        Assert.assertEquals(null, (Object)child.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)child.getChildren());
    }

    @Test
    public void testRemoveChildNoParent() {
        TimeGraphEntry parent = new TimeGraphEntry("parent", -1L, -1L);
        TimeGraphEntry child = new TimeGraphEntry("child", -1L, -1L);
        parent.removeChild(child);
        Assert.assertEquals(null, (Object)parent.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)parent.getChildren());
        Assert.assertEquals(null, (Object)child.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)child.getChildren());
    }

    @Test
    public void testRemoveChildOtherParent() {
        TimeGraphEntry parent1 = new TimeGraphEntry("parent1", -1L, -1L);
        TimeGraphEntry parent2 = new TimeGraphEntry("parent2", -1L, -1L);
        TimeGraphEntry child = new TimeGraphEntry("child", -1L, -1L);
        parent1.addChild(child);
        parent2.removeChild(child);
        Assert.assertEquals(null, (Object)parent1.getParent());
        Assert.assertEquals(Arrays.asList(child), (Object)parent1.getChildren());
        Assert.assertEquals(null, (Object)parent2.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)parent2.getChildren());
        Assert.assertEquals((Object)parent1, (Object)child.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)child.getChildren());
    }

    @Test
    public void testSortChildren() {
        TimeGraphEntry parent = new TimeGraphEntry("parent", -1L, -1L);
        TimeGraphEntry child1 = new TimeGraphEntry("child1", 2L, 2L);
        TimeGraphEntry child2 = new TimeGraphEntry("child2", 1L, 1L);
        parent.addChild(child1);
        parent.addChild(child2);
        parent.sortChildren(Comparator.comparingLong(entry -> entry.getStartTime()));
        Assert.assertEquals(null, (Object)parent.getParent());
        Assert.assertEquals(Arrays.asList(child2, child1), (Object)parent.getChildren());
        Assert.assertEquals((Object)parent, (Object)child1.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)child1.getChildren());
        Assert.assertEquals((Object)parent, (Object)child2.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)child2.getChildren());
    }

    @Test
    public void testSortChildrenThenAdd() {
        TimeGraphEntry parent = new TimeGraphEntry("parent", -1L, -1L);
        TimeGraphEntry child1 = new TimeGraphEntry("child1", 2L, 2L);
        TimeGraphEntry child2 = new TimeGraphEntry("child2", 1L, 1L);
        parent.sortChildren(Comparator.comparingLong(entry -> entry.getStartTime()));
        parent.addChild(child1);
        parent.addChild(child2);
        Assert.assertEquals(null, (Object)parent.getParent());
        Assert.assertEquals(Arrays.asList(child2, child1), (Object)parent.getChildren());
        Assert.assertEquals((Object)parent, (Object)child1.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)child1.getChildren());
        Assert.assertEquals((Object)parent, (Object)child2.getParent());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)child2.getChildren());
    }

    private static void assertIteratorsEqual(Iterator<ITimeEvent> expected, Iterator<ITimeEvent> actual) {
        int i = 0;
        while (expected.hasNext()) {
            Assert.assertTrue((String)("missing event at position " + i), (boolean)actual.hasNext());
            ITimeEvent e1 = expected.next();
            ITimeEvent e2 = actual.next();
            Assert.assertEquals((String)("not equal events at position " + i), (Object)e1, (Object)e2);
            ++i;
        }
        Assert.assertFalse((String)("extra event at position " + i), (boolean)actual.hasNext());
    }
}

