/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Starter;
import io.vertx.core.Vertx;
import io.vertx.core.impl.Action;
import io.vertx.core.impl.Closeable;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.ContextTask;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.VertxThreadFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ContextImpl
implements Context {
    private static final Logger log = LoggerFactory.getLogger(ContextImpl.class);
    private static final String THREAD_CHECKS_PROP_NAME = "vertx.threadChecks";
    private static final String DISABLE_TIMINGS_PROP_NAME = "vertx.disableContextTimings";
    private static final boolean THREAD_CHECKS = Boolean.getBoolean("vertx.threadChecks");
    private static final boolean DISABLE_TIMINGS = Boolean.getBoolean("vertx.disableContextTimings");
    protected final VertxInternal owner;
    protected final String deploymentID;
    protected final JsonObject config;
    private Deployment deployment;
    private Set<Closeable> closeHooks;
    private final ClassLoader tccl;
    private final EventLoop eventLoop;
    protected final Executor orderedInternalPoolExec;
    protected final Executor workerExec;
    protected VertxThread contextThread;
    private volatile boolean closeHooksRun;
    private Map<String, Object> contextData;

    protected ContextImpl(VertxInternal vertx, Executor orderedInternalPoolExec, Executor workerExec, String deploymentID, JsonObject config, ClassLoader tccl) {
        this.orderedInternalPoolExec = orderedInternalPoolExec;
        this.workerExec = workerExec;
        this.deploymentID = deploymentID;
        this.config = config;
        EventLoopGroup group = vertx.getEventLoopGroup();
        this.eventLoop = group != null ? group.next() : null;
        this.tccl = tccl;
        this.owner = vertx;
    }

    public static void setContext(ContextImpl context) {
        Thread current = Thread.currentThread();
        if (!(current instanceof VertxThread)) {
            throw new IllegalStateException("Attempt to setContext on non Vert.x thread " + Thread.currentThread());
        }
        ContextImpl.setContext((VertxThread)((Object)current), context);
    }

    private static void setContext(VertxThread thread, ContextImpl context) {
        thread.setContext(context);
        if (context != null) {
            context.setTCCL();
        } else {
            Thread.currentThread().setContextClassLoader(null);
        }
    }

    public void setDeployment(Deployment deployment) {
        this.deployment = deployment;
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public void addCloseHook(Closeable hook) {
        if (this.closeHooks == null) {
            this.closeHooks = new ConcurrentHashSet<Closeable>();
        }
        this.closeHooks.add(hook);
    }

    public void removeCloseHook(Closeable hook) {
        if (this.closeHooks != null) {
            this.closeHooks.remove(hook);
        }
    }

    public void runCloseHooks(Handler<AsyncResult<Void>> completionHandler) {
        if (this.closeHooksRun) {
            throw new IllegalStateException("Close hooks already run");
        }
        this.closeHooksRun = true;
        if (this.closeHooks != null && !this.closeHooks.isEmpty()) {
            HashSet<Closeable> copy = new HashSet<Closeable>(this.closeHooks);
            int num = copy.size();
            if (num != 0) {
                AtomicInteger count = new AtomicInteger();
                AtomicBoolean failed = new AtomicBoolean();
                for (Closeable hook : copy) {
                    try {
                        hook.close(ar -> {
                            if (ar.failed()) {
                                if (failed.compareAndSet(false, true)) {
                                    completionHandler.handle(Future.failedFuture(ar.cause()));
                                }
                            } else if (count.incrementAndGet() == num) {
                                completionHandler.handle(Future.succeededFuture());
                            }
                        });
                    }
                    catch (Throwable t) {
                        log.warn("Failed to run close hooks", t);
                    }
                }
            } else {
                completionHandler.handle(Future.succeededFuture());
            }
        } else {
            completionHandler.handle(Future.succeededFuture());
        }
        VertxThreadFactory.unsetContext(this);
    }

    protected abstract void executeAsync(Handler<Void> var1);

    @Override
    public abstract boolean isEventLoopContext();

    @Override
    public abstract boolean isMultiThreadedWorkerContext();

    @Override
    public <T> T get(String key) {
        return (T)this.contextData().get(key);
    }

    @Override
    public void put(String key, Object value) {
        this.contextData().put(key, value);
    }

    @Override
    public boolean remove(String key) {
        return this.contextData().remove(key) != null;
    }

    @Override
    public boolean isWorkerContext() {
        return !this.isEventLoopContext();
    }

    public static boolean isOnWorkerThread() {
        return ContextImpl.isOnVertxThread(true);
    }

    public static boolean isOnEventLoopThread() {
        return ContextImpl.isOnVertxThread(false);
    }

    public static boolean isOnVertxThread() {
        Thread t = Thread.currentThread();
        return t instanceof VertxThread;
    }

    private static boolean isOnVertxThread(boolean worker) {
        Thread t = Thread.currentThread();
        if (t instanceof VertxThread) {
            VertxThread vt = (VertxThread)((Object)t);
            return vt.isWorker() == worker;
        }
        return false;
    }

    public void executeFromIO(ContextTask task) {
        if (THREAD_CHECKS) {
            this.checkCorrectThread();
        }
        this.wrapTask(task, null, true).run();
    }

    protected abstract void checkCorrectThread();

    @Override
    public void runOnContext(Handler<Void> task) {
        try {
            this.executeAsync(task);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public String deploymentID() {
        return this.deploymentID;
    }

    @Override
    public JsonObject config() {
        return this.config;
    }

    @Override
    public List<String> processArgs() {
        return Starter.PROCESS_ARGS;
    }

    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @Override
    public Vertx owner() {
        return this.owner;
    }

    public <T> void executeBlocking(Action<T> action, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(action, null, true, true, resultHandler);
    }

    public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(null, blockingCodeHandler, false, ordered, resultHandler);
    }

    protected synchronized Map<String, Object> contextData() {
        if (this.contextData == null) {
            this.contextData = new ConcurrentHashMap<String, Object>();
        }
        return this.contextData;
    }

    private <T> void executeBlocking(Action<T> action, Handler<Future<T>> blockingCodeHandler, boolean internal, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        try {
            Executor exec = internal ? this.orderedInternalPoolExec : (ordered ? this.workerExec : this.owner.getWorkerPool());
            exec.execute(() -> {
                Future res = Future.future();
                try {
                    if (blockingCodeHandler != null) {
                        ContextImpl.setContext(this);
                        blockingCodeHandler.handle(res);
                    } else {
                        Object result = action.perform();
                        res.complete(result);
                    }
                }
                catch (Throwable e) {
                    res.fail(e);
                }
                if (resultHandler != null) {
                    this.runOnContext(v -> res.setHandler(resultHandler));
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    protected Runnable wrapTask(ContextTask cTask, Handler<Void> hTask, boolean checkThread) {
        return () -> {
            VertxThread current = this.getCurrentThread();
            if (THREAD_CHECKS && checkThread) {
                if (this.contextThread == null) {
                    this.contextThread = current;
                } else if (this.contextThread != current && !this.contextThread.isWorker()) {
                    throw new IllegalStateException("Uh oh! Event loop context executing with wrong thread! Expected " + (Object)((Object)this.contextThread) + " got " + (Object)((Object)current));
                }
            }
            if (!DISABLE_TIMINGS) {
                current.executeStart();
            }
            try {
                ContextImpl.setContext(current, this);
                if (cTask != null) {
                    cTask.run();
                } else {
                    hTask.handle(null);
                }
            }
            catch (Throwable t) {
                log.error("Unhandled exception", t);
            }
            finally {
                if (!DISABLE_TIMINGS) {
                    current.executeEnd();
                }
            }
        };
    }

    private VertxThread getCurrentThread() {
        return (VertxThread)((Object)Thread.currentThread());
    }

    private void setTCCL() {
        Thread.currentThread().setContextClassLoader(this.tccl);
    }

    @Override
    public int getInstanceCount() {
        if (this.deployment == null) {
            return 0;
        }
        if (this.deployment.deploymentOptions() == null) {
            return 1;
        }
        return this.deployment.deploymentOptions().getInstances();
    }
}

