/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientOptionsBaseConverter;
import io.vertx.core.net.TCPSSLOptions;

@DataObject(generateConverter=true)
public abstract class ClientOptionsBase
extends TCPSSLOptions {
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final boolean DEFAULT_TRUST_ALL = false;
    private int connectTimeout;
    private boolean trustAll;

    public ClientOptionsBase() {
        this.init();
    }

    public ClientOptionsBase(ClientOptionsBase other) {
        super(other);
        this.connectTimeout = other.getConnectTimeout();
        this.trustAll = other.isTrustAll();
    }

    public ClientOptionsBase(JsonObject json) {
        super(json);
        this.init();
        ClientOptionsBaseConverter.fromJson(json, this);
    }

    private void init() {
        this.connectTimeout = 60000;
        this.trustAll = false;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public ClientOptionsBase setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ClientOptionsBase setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout must be >= 0");
        }
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientOptionsBase)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientOptionsBase that = (ClientOptionsBase)o;
        if (this.connectTimeout != that.connectTimeout) {
            return false;
        }
        return this.trustAll == that.trustAll;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.connectTimeout;
        result = 31 * result + (this.trustAll ? 1 : 0);
        return result;
    }
}

