/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.observer;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.observer.event.ObserverAdded;
import org.apache.openejb.observer.event.ObserverFailed;
import org.apache.openejb.observer.event.ObserverRemoved;

public class ObserverManager {
    private final List<Observer> observers = new ArrayList<Observer>();

    public boolean addObserver(Object observer) {
        Observer obs;
        if (observer == null) {
            throw new IllegalArgumentException("observer cannot be null");
        }
        try {
            obs = new Observer(observer);
        }
        catch (NotAnObserverException naoe) {
            return false;
        }
        boolean added = this.observers.add(obs);
        this.fireEvent(new ObserverAdded(observer));
        return added;
    }

    public boolean removeObserver(Object observer) {
        if (observer == null) {
            throw new IllegalArgumentException("observer cannot be null");
        }
        this.fireEvent(new ObserverRemoved(observer));
        return this.observers.remove(new Observer(observer));
    }

    public void fireEvent(Object event) {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null");
        }
        for (Observer observer : this.observers) {
            try {
                observer.invoke(event);
            }
            catch (Throwable t) {
                if (!(event instanceof ObserverFailed)) {
                    this.fireEvent(new ObserverFailed(observer, event, t));
                }
                Logger.getLogger(ObserverManager.class.getName()).log(Level.SEVERE, "error invoking " + observer, t);
            }
        }
    }

    private static class NotAnObserverException
    extends RuntimeException {
        public NotAnObserverException(String s) {
            super(s);
        }
    }

    public static class Observer {
        private final Map<Class, Method> methods = new HashMap<Class, Method>();
        private final Object observer;
        private final Method defaultMethod;

        public Observer(Object observer) {
            if (observer == null) {
                throw new IllegalArgumentException("observer cannot be null");
            }
            this.observer = observer;
            for (Method method : observer.getClass().getMethods()) {
                if (!this.isObserver(method)) continue;
                if (method.getParameterTypes().length > 1) {
                    throw new IllegalArgumentException("@Observes method must have only 1 parameter: " + method.toString());
                }
                if (Modifier.isAbstract(method.getModifiers())) {
                    throw new IllegalArgumentException("@Observes method must not be abstract: " + method.toString());
                }
                if (!Modifier.isPublic(method.getModifiers())) {
                    throw new IllegalArgumentException("@Observes method must be public: " + method.toString());
                }
                Class<?> type = method.getParameterTypes()[0];
                if (type.isAnnotation()) {
                    throw new IllegalArgumentException("@Observes method parameter must be a concrete class (not an annotation): " + method.toString());
                }
                if (Modifier.isAbstract(type.getModifiers())) {
                    throw new IllegalArgumentException("@Observes method parameter must be a concrete class (not an abstract class): " + method.toString());
                }
                if (type.isInterface()) {
                    throw new IllegalArgumentException("@Observes method parameter must be a concrete class (not an interface): " + method.toString());
                }
                if (type.isArray()) {
                    throw new IllegalArgumentException("@Observes method parameter must be a concrete class (not an array): " + method.toString());
                }
                if (type.isPrimitive()) {
                    throw new IllegalArgumentException("@Observes method parameter must be a concrete class (not a primitive): " + method.toString());
                }
                this.methods.put(type, method);
            }
            this.defaultMethod = this.methods.get(Object.class);
            if (this.methods.size() == 0) {
                throw new NotAnObserverException("Object has no @Observes methods. For example: public void observe(@Observes RetryConditionAdded event){...}");
            }
        }

        public void invoke(Object event) throws InvocationTargetException, IllegalAccessException {
            if (event == null) {
                throw new IllegalArgumentException("event cannot be null");
            }
            Class<?> eventType = event.getClass();
            Method method = this.methods.get(eventType);
            if (method != null) {
                method.invoke(this.observer, event);
            } else if (this.defaultMethod != null) {
                this.defaultMethod.invoke(this.observer, event);
            }
        }

        private boolean isObserver(Method method) {
            Annotation[][] arr$ = method.getParameterAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = arr$[i$]) {
                    if (!annotation.annotationType().equals(Observes.class)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Observer observer1 = (Observer)o;
            return this.observer.equals(observer1.observer);
        }

        public int hashCode() {
            return this.observer.hashCode();
        }
    }
}

