/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.context;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextException;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.AbstractContextsService;
import org.apache.webbeans.context.ApplicationContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.DependentContext;
import org.apache.webbeans.context.RequestContext;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.context.SingletonContext;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.web.context.ServletRequestContext;
import org.apache.webbeans.web.context.SessionContextManager;
import org.apache.webbeans.web.intercept.RequestScopedBeanInterceptorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebContextsService
extends AbstractContextsService {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebContextsService.class);
    private static ThreadLocal<RequestContext> requestContexts = null;
    private static ThreadLocal<SessionContext> sessionContexts = null;
    private static ThreadLocal<ApplicationContext> applicationContexts = null;
    private ApplicationContext sharedApplicationContext;
    private static ThreadLocal<ConversationContext> conversationContexts = null;
    private static ThreadLocal<SingletonContext> singletonContexts = null;
    private static DependentContext dependentContext;
    private static Map<ServletContext, ApplicationContext> currentApplicationContexts;
    private static Map<ServletContext, SingletonContext> currentSingletonContexts;
    private final SessionContextManager sessionCtxManager = new SessionContextManager();
    private final ConversationManager conversationManager;
    private boolean supportsConversation = false;
    protected FailOverService failoverService = null;
    private WebBeansContext webBeansContext;

    public static void removeThreadLocals() {
        requestContexts.remove();
        sessionContexts.remove();
        applicationContexts.remove();
        conversationContexts.remove();
        singletonContexts.remove();
        RequestScopedBeanInterceptorHandler.removeThreadLocals();
    }

    public WebContextsService(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.supportsConversation = webBeansContext.getOpenWebBeansConfiguration().supportsConversation();
        this.failoverService = (FailOverService)webBeansContext.getService(FailOverService.class);
        this.conversationManager = webBeansContext.getConversationManager();
        this.sharedApplicationContext = new ApplicationContext();
        this.sharedApplicationContext.setActive(true);
    }

    public SessionContextManager getSessionContextManager() {
        return this.sessionCtxManager;
    }

    public void init(Object initializeObject) {
        this.startContext(ApplicationScoped.class, initializeObject);
        this.startContext(Singleton.class, initializeObject);
    }

    public void destroy(Object destroyObject) {
        this.endContext(ApplicationScoped.class, destroyObject);
        this.sharedApplicationContext.destroy();
        this.endContext(Singleton.class, destroyObject);
        currentApplicationContexts.clear();
        currentSingletonContexts.clear();
        requestContexts.set(null);
        sessionContexts.set(null);
        conversationContexts.set(null);
        applicationContexts.set(null);
        singletonContexts.set(null);
        requestContexts.remove();
        sessionContexts.remove();
        conversationContexts.remove();
        applicationContexts.remove();
        singletonContexts.remove();
    }

    public void endContext(Class<? extends Annotation> scopeType, Object endParameters) {
        if (scopeType.equals(RequestScoped.class)) {
            this.destroyRequestContext((ServletRequestEvent)endParameters);
        } else if (scopeType.equals(SessionScoped.class)) {
            this.destroySessionContext((HttpSession)endParameters);
        } else if (scopeType.equals(ApplicationScoped.class)) {
            this.destroyApplicationContext((ServletContext)endParameters);
        } else if (this.supportsConversation && scopeType.equals(ConversationScoped.class)) {
            this.destroyConversationContext();
        } else if (!scopeType.equals(Dependent.class) && scopeType.equals(Singleton.class)) {
            this.destroySingletonContext((ServletContext)endParameters);
        }
    }

    public Context getCurrentContext(Class<? extends Annotation> scopeType) {
        if (scopeType.equals(RequestScoped.class)) {
            return this.getRequestContext();
        }
        if (scopeType.equals(SessionScoped.class)) {
            return this.getSessionContext();
        }
        if (scopeType.equals(ApplicationScoped.class)) {
            return this.getApplicationContext();
        }
        if (this.supportsConversation && scopeType.equals(ConversationScoped.class)) {
            return this.getConversationContext();
        }
        if (scopeType.equals(Dependent.class)) {
            return dependentContext;
        }
        if (scopeType.equals(Singleton.class)) {
            return this.getSingletonContext();
        }
        return null;
    }

    public void startContext(Class<? extends Annotation> scopeType, Object startParameter) throws ContextException {
        if (scopeType.equals(RequestScoped.class)) {
            this.initRequestContext((ServletRequestEvent)startParameter);
        } else if (scopeType.equals(SessionScoped.class)) {
            this.initSessionContext((HttpSession)startParameter);
        } else if (scopeType.equals(ApplicationScoped.class)) {
            this.initApplicationContext((ServletContext)startParameter);
        } else if (this.supportsConversation && scopeType.equals(ConversationScoped.class)) {
            this.initConversationContext((ConversationContext)startParameter);
        } else if (!scopeType.equals(Dependent.class) && scopeType.equals(Singleton.class)) {
            this.initSingletonContext((ServletContext)startParameter);
        }
    }

    public boolean supportsContext(Class<? extends Annotation> scopeType) {
        return scopeType.equals(RequestScoped.class) || scopeType.equals(SessionScoped.class) || scopeType.equals(ApplicationScoped.class) || scopeType.equals(Dependent.class) || scopeType.equals(Singleton.class) || scopeType.equals(ConversationScoped.class) && this.supportsConversation;
    }

    private void initRequestContext(ServletRequestEvent event) {
        ServletRequestContext rq = new ServletRequestContext();
        rq.setActive(true);
        requestContexts.set(rq);
        if (event != null) {
            HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
            rq.setServletRequest(request);
            if (request != null) {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    this.initSessionContext(session);
                }
                this.initApplicationContext(event.getServletContext());
                this.initSingletonContext(event.getServletContext());
            }
        } else {
            this.initApplicationContext(null);
            this.initSingletonContext(null);
        }
    }

    private void destroyRequestContext(ServletRequestEvent request) {
        ELContextStore elStore;
        RequestContext context;
        if (this.supportsConversation) {
            this.cleanupConversations();
        }
        if ((context = this.getRequestContext()) != null) {
            context.destroy();
        }
        if ((elStore = ELContextStore.getInstance((boolean)false)) != null) {
            elStore.destroyELContextStore();
        }
        requestContexts.set(null);
        requestContexts.remove();
        RequestScopedBeanInterceptorHandler.removeThreadLocals();
    }

    private void cleanupConversations() {
        ConversationContext conversationContext = this.getConversationContext();
        if (conversationContext == null) {
            return;
        }
        Conversation conversation = this.conversationManager.getConversationBeanReference();
        if (conversation == null) {
            return;
        }
        if (conversation.isTransient()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Destroying the transient conversation context with cid : [{0}]", conversation.getId());
            }
            this.destroyConversationContext();
        } else {
            ConversationImpl owbConversation = (ConversationImpl)conversation;
            owbConversation.updateTimeOut();
            owbConversation.setInUsed(false);
        }
    }

    private void initSessionContext(HttpSession session) {
        SessionContext currentSessionContext;
        if (session == null) {
            currentSessionContext = new SessionContext();
        } else {
            String sessionId = session.getId();
            currentSessionContext = this.sessionCtxManager.getSessionContextWithSessionId(sessionId);
            if (currentSessionContext == null) {
                currentSessionContext = new SessionContext();
                this.sessionCtxManager.addNewSessionContext(sessionId, currentSessionContext);
            }
        }
        currentSessionContext.setActive(true);
        sessionContexts.set(currentSessionContext);
    }

    private void destroySessionContext(HttpSession session) {
        if (session != null) {
            SessionContext context = sessionContexts.get();
            if (context != null) {
                context.destroy();
            }
            sessionContexts.set(null);
            sessionContexts.remove();
            this.sessionCtxManager.destroySessionContextWithSessionId(session.getId());
        }
    }

    private void initApplicationContext(ServletContext servletContext) {
        if (servletContext != null) {
            if (currentApplicationContexts.containsKey(servletContext)) {
                applicationContexts.set(currentApplicationContexts.get(servletContext));
            } else {
                ApplicationContext currentApplicationContext = new ApplicationContext();
                currentApplicationContext.setActive(true);
                currentApplicationContexts.put(servletContext, currentApplicationContext);
                applicationContexts.set(currentApplicationContext);
            }
        } else {
            applicationContexts.set(this.sharedApplicationContext);
        }
    }

    private void destroyApplicationContext(ServletContext servletContext) {
        ApplicationContext context = null;
        if (servletContext != null) {
            context = currentApplicationContexts.get(servletContext);
        }
        if (context == null) {
            context = this.getApplicationContext();
        }
        if (context != null) {
            context.destroy();
        }
        if (servletContext != null) {
            currentApplicationContexts.remove(servletContext);
        }
        this.sessionCtxManager.destroyAllSessions();
        this.conversationManager.destroyAllConversations();
        applicationContexts.set(null);
        applicationContexts.remove();
        this.webBeansContext.getBeanManagerImpl().clearCacheProxies();
    }

    private void initSingletonContext(ServletContext servletContext) {
        if (servletContext != null && currentSingletonContexts.containsKey(servletContext)) {
            singletonContexts.set(currentSingletonContexts.get(servletContext));
        } else {
            SingletonContext context = new SingletonContext();
            context.setActive(true);
            if (servletContext != null) {
                currentSingletonContexts.put(servletContext, context);
            }
            singletonContexts.set(context);
        }
    }

    private void destroySingletonContext(ServletContext servletContext) {
        SingletonContext context = null;
        if (servletContext != null) {
            context = currentSingletonContexts.get(servletContext);
        }
        if (context == null) {
            context = this.getSingletonContext();
        }
        if (context != null) {
            context.destroy();
        }
        if (servletContext != null) {
            currentSingletonContexts.remove(servletContext);
        }
        singletonContexts.set(null);
        singletonContexts.remove();
    }

    private void initConversationContext(ConversationContext context) {
        if (context == null) {
            if (conversationContexts.get() == null) {
                ConversationContext newContext = new ConversationContext();
                newContext.setActive(true);
                conversationContexts.set(newContext);
            } else {
                conversationContexts.get().setActive(true);
            }
        } else {
            context.setActive(true);
            conversationContexts.set(context);
        }
    }

    private void destroyConversationContext() {
        ConversationContext context = this.getConversationContext();
        if (context != null) {
            context.destroy();
        }
        conversationContexts.set(null);
        conversationContexts.remove();
    }

    private RequestContext getRequestContext() {
        return requestContexts.get();
    }

    private SessionContext getSessionContext() {
        SessionContext context = sessionContexts.get();
        if (null == context) {
            this.lazyStartSessionContext();
            context = sessionContexts.get();
        }
        return context;
    }

    private ApplicationContext getApplicationContext() {
        return applicationContexts.get();
    }

    private SingletonContext getSingletonContext() {
        return singletonContexts.get();
    }

    private ConversationContext getConversationContext() {
        return conversationContexts.get();
    }

    private Context lazyStartSessionContext() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, ">lazyStartSessionContext");
        }
        Context webContext = null;
        Context context = this.getCurrentContext(RequestScoped.class);
        if (context instanceof ServletRequestContext) {
            ServletRequestContext requestContext = (ServletRequestContext)context;
            HttpServletRequest servletRequest = requestContext.getServletRequest();
            if (null != servletRequest) {
                try {
                    HttpSession currentSession = servletRequest.getSession();
                    this.initSessionContext(currentSession);
                    if (this.failoverService != null && this.failoverService.isSupportFailOver()) {
                        this.failoverService.sessionIsInUse(currentSession);
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Lazy SESSION context initialization SUCCESS");
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0013", (Object[])new Object[]{e}));
                }
            } else {
                logger.log(Level.WARNING, "Could NOT lazily initialize session context because NO active request context");
            }
        } else {
            logger.log(Level.WARNING, "Could NOT lazily initialize session context because of " + context + " RequestContext");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "<lazyStartSessionContext " + webContext);
        }
        return webContext;
    }

    public void activateContext(Class<? extends Annotation> scopeType) {
        if (scopeType.equals(ApplicationScoped.class) && applicationContexts.get() == null) {
            applicationContexts.set(this.sharedApplicationContext);
        }
        if (scopeType.equals(SessionScoped.class)) {
            this.getSessionContext().setActive(true);
        } else {
            super.activateContext(scopeType);
        }
    }

    static {
        currentApplicationContexts = new ConcurrentHashMap<ServletContext, ApplicationContext>();
        currentSingletonContexts = new ConcurrentHashMap<ServletContext, SingletonContext>();
        requestContexts = new ThreadLocal();
        sessionContexts = new ThreadLocal();
        applicationContexts = new ThreadLocal();
        conversationContexts = new ThreadLocal();
        singletonContexts = new ThreadLocal();
        dependentContext = new DependentContext();
        dependentContext.setActive(true);
    }
}

