/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.dbgp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.mod.dbgp.IDbgpServerListener;
import org.eclipse.dltk.mod.dbgp.Messages;
import org.eclipse.dltk.mod.dbgp.internal.DbgpDebugingEngine;
import org.eclipse.dltk.mod.dbgp.internal.DbgpSession;
import org.eclipse.dltk.mod.dbgp.internal.DbgpWorkingThread;
import org.eclipse.dltk.mod.debug.core.DLTKDebugPlugin;

public class DbgpServer
extends DbgpWorkingThread {
    private final int port;
    private ServerSocket server;
    private final int clientTimeout;
    private static final int STATE_NONE = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_CLOSED = 2;
    private final Object stateLock = new Object();
    private int state = 0;
    private IDbgpServerListener listener;

    public static int findAvailablePort(int fromPort, int toPort) {
        if (fromPort > toPort) {
            throw new IllegalArgumentException(Messages.DbgpServer_startPortShouldBeLessThanOrEqualToEndPort);
        }
        int port = fromPort;
        ServerSocket socket = null;
        while (port <= toPort) {
            try {
                socket = new ServerSocket(port);
                int n = port;
                return n;
            }
            catch (IOException iOException) {
                ++port;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 1;
        }
    }

    public boolean waitStarted() {
        return this.waitStarted(15000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitStarted(long timeout) {
        Object object = this.stateLock;
        synchronized (object) {
            block8: {
                block7: {
                    if (this.state != 1) break block7;
                    return true;
                }
                if (this.state != 2) break block8;
                return false;
            }
            try {
                this.stateLock.wait(timeout);
            }
            catch (InterruptedException interruptedException) {}
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void workingCycle() throws Exception, IOException {
        try {
            this.server = new ServerSocket(this.port);
            var1_1 = this.stateLock;
            synchronized (var1_1) {
                this.state = 1;
                this.stateLock.notifyAll();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                if (true) ** GOTO lbl16
            }
            do {
                client = this.server.accept();
                client.setSoTimeout(this.clientTimeout);
                this.createSession(client);
lbl16:
                // 2 sources

            } while (!this.server.isClosed());
        }
        catch (Throwable var2_2) {
            if (this.server != null && !this.server.isClosed()) {
                this.server.close();
            }
            var3_3 = this.stateLock;
            synchronized (var3_3) {
                this.state = 2;
                this.stateLock.notifyAll();
            }
            throw var2_2;
        }
        if (this.server != null && !this.server.isClosed()) {
            this.server.close();
        }
        var3_4 = this.stateLock;
        synchronized (var3_4) {
            this.state = 2;
            this.stateLock.notifyAll();
        }
    }

    private void createSession(final Socket client) {
        Job job = new Job(Messages.DbgpServer_acceptingDebuggingEngineConnection){

            protected IStatus run(IProgressMonitor monitor) {
                block3: {
                    IDbgpServerListener savedListener = DbgpServer.this.listener;
                    if (savedListener != null) {
                        DbgpDebugingEngine dbgpDebugingEngine = null;
                        DbgpSession session = null;
                        try {
                            dbgpDebugingEngine = new DbgpDebugingEngine(client);
                            session = new DbgpSession(dbgpDebugingEngine);
                            savedListener.clientConnected(session);
                        }
                        catch (Exception e) {
                            DLTKDebugPlugin.log(e);
                            if (dbgpDebugingEngine == null) break block3;
                            dbgpDebugingEngine.requestTermination();
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public DbgpServer(int port, int clientTimeout) {
        super("DbgpServer");
        this.port = port;
        this.clientTimeout = clientTimeout;
    }

    public DbgpServer(int port, int serverTimeout, int clientTimeout) {
        this(port, clientTimeout);
    }

    @Override
    public void requestTermination() {
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException e) {
            DLTKDebugPlugin.log(e);
        }
        super.requestTermination();
    }

    public void setListener(IDbgpServerListener listener) {
        this.listener = listener;
    }
}

