/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.dbgp.internal.commands;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.dltk.mod.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpStatckCommands;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpDebuggingEngineException;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.mod.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpBaseCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.mod.dbgp.internal.utils.DbgpXmlEntityParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbgpStackCommands
extends DbgpBaseCommands
implements IDbgpStatckCommands {
    private static final String STACK_DEPTH_COMMAND = "stack_depth";
    private static final String STACK_GET_COMMAND = "stack_get";
    private static final String TAG_STACK = "stack";
    private static final String ATTR_DEPTH = "depth";
    private static final Comparator STACK_LEVEL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            IDbgpStackLevel level1 = (IDbgpStackLevel)o1;
            IDbgpStackLevel level2 = (IDbgpStackLevel)o2;
            return level1.getLevel() - level2.getLevel();
        }
    };

    protected int parseStackDepthResponse(Element response) throws DbgpDebuggingEngineException {
        return Integer.parseInt(response.getAttribute(ATTR_DEPTH));
    }

    protected IDbgpStackLevel[] parseStackLevels(Element response) throws DbgpException {
        NodeList nodes = response.getElementsByTagName(TAG_STACK);
        IDbgpStackLevel[] list = new IDbgpStackLevel[nodes.getLength()];
        int i = 0;
        while (i < nodes.getLength()) {
            Element level = (Element)nodes.item(i);
            list[i] = DbgpXmlEntityParser.parseStackLevel(level);
            ++i;
        }
        Arrays.sort(list, STACK_LEVEL_COMPARATOR);
        return list;
    }

    public DbgpStackCommands(IDbgpCommunicator communicator) {
        super(communicator);
    }

    @Override
    public int getStackDepth() throws DbgpException {
        return this.parseStackDepthResponse(this.communicate(this.createRequest(STACK_DEPTH_COMMAND)));
    }

    @Override
    public IDbgpStackLevel getStackLevel(int stackDepth) throws DbgpException {
        DbgpRequest request = this.createRequest(STACK_GET_COMMAND);
        request.addOption("-d", stackDepth);
        IDbgpStackLevel[] levels = this.parseStackLevels(this.communicate(request));
        if (levels.length < 1) {
            return null;
        }
        return levels[0];
    }

    @Override
    public IDbgpStackLevel[] getStackLevels() throws DbgpException {
        return this.parseStackLevels(this.communicate(this.createRequest(STACK_GET_COMMAND)));
    }
}

