/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.dbgp.internal.managers;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.mod.dbgp.IDbgpContinuationHandler;
import org.eclipse.dltk.mod.dbgp.internal.DbgpWorkingThread;
import org.eclipse.dltk.mod.dbgp.internal.IDbgpDebugingEngine;
import org.eclipse.dltk.mod.dbgp.internal.managers.IDbgpStreamManager;
import org.eclipse.dltk.mod.dbgp.internal.packets.DbgpStreamPacket;

public class DbgpStreamManager
extends DbgpWorkingThread
implements IDbgpStreamManager {
    private final ListenerList listeners = new ListenerList();
    private final IDbgpDebugingEngine engine;

    protected void fireStderrReceived(String data) {
        if (data == null || data.length() == 0) {
            return;
        }
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IDbgpContinuationHandler)list[i]).stderrReceived(data);
            ++i;
        }
    }

    protected void fireStdoutReceived(String data) {
        if (data == null || data.length() == 0) {
            return;
        }
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IDbgpContinuationHandler)list[i]).stdoutReceived(data);
            ++i;
        }
    }

    @Override
    protected void workingCycle() throws Exception {
        try {
            while (!Thread.interrupted()) {
                DbgpStreamPacket packet = this.engine.getStreamPacket();
                if (packet.isStderr()) {
                    this.fireStderrReceived(packet.getTextContent());
                    continue;
                }
                if (!packet.isStdout()) continue;
                this.fireStdoutReceived(packet.getTextContent());
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public DbgpStreamManager(IDbgpDebugingEngine engine, String name) {
        super(name);
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
    }

    @Override
    public void addListener(IDbgpContinuationHandler listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IDbgpContinuationHandler listener) {
        this.listeners.remove((Object)listener);
    }
}

