/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.cml.vjetv.reporter.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticProblem;
import org.eclipse.vjet.dsf.jst.ProblemSeverity;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.IHeadLessLauncherResult;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.IHeadlessLauncherConfigure;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.impl.EVLauncherResult;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.impl.VjetvHeadlessConfigure;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.reporter.IHeadLessReporter;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.reporter.LineNumberComparator;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.reporter.impl.XMLReportGenerator;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.util.FileOperator;

public class BaseReporter
implements IHeadLessReporter {
    public static final LineNumberComparator COMPARATOR = new LineNumberComparator();

    @Override
    public void generateReport(IHeadLessLauncherResult result, IHeadlessLauncherConfigure conf) {
        if (conf.getReportPath() == null) {
            return;
        }
        if (conf.getReportType().equalsIgnoreCase("TXT")) {
            this.generateReportFileViaTxt(result, conf, (EVLauncherResult)result);
        } else if (conf.getReportType().equalsIgnoreCase("XML")) {
            XMLReportGenerator.generateXMLFile(conf, (EVLauncherResult)result);
        }
    }

    private void generateReportFileViaTxt(IHeadLessLauncherResult result, IHeadlessLauncherConfigure conf, EVLauncherResult launcherResult) {
        String resultPath = conf.getReportPath();
        File tempFile = new File(resultPath);
        File resultFile = null;
        resultFile = tempFile.isDirectory() ? new File(String.valueOf(resultPath) + File.separatorChar + "VJETVResult.xml") : tempFile;
        if (!resultFile.exists()) {
            try {
                resultFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileWriter fw = new FileWriter(resultFile);
            fw.write("VJET Valdation ===>");
            fw.write(String.valueOf(new Date().toString()) + "\n");
            HashMap<String, Object> map = result.getReportData();
            EVLauncherResult evresult = (EVLauncherResult)result;
            VjetvHeadlessConfigure vconf = (VjetvHeadlessConfigure)conf;
            String reportLevel = vconf.getReportLevel();
            int i = 0;
            fw.write("=============================================================================================================================\n");
            for (File file : map.keySet()) {
                Object value = map.get(file);
                fw.write("<" + ++i + "> JS Path: " + file + "\n");
                if (value == null) continue;
                if (value instanceof String) {
                    fw.write("Error Message :  " + value + "\n");
                    fw.write("Please check verified JS files writtern by VJO syntax. \n");
                    continue;
                }
                if (!(value instanceof ArrayList)) continue;
                ArrayList actualProblems = (ArrayList)value;
                Collections.sort(actualProblems, COMPARATOR);
                fw.write(this.printProblems(actualProblems, evresult, reportLevel, false, file));
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void printCurrentStates(String message) {
        System.out.println(message);
    }

    public String printProblems(List<VjoSemanticProblem> actualProblems, EVLauncherResult evresult, String reportLevel, boolean calc, File validateFile) {
        StringBuffer message = new StringBuffer();
        String sources = "";
        if (validateFile.exists()) {
            sources = FileOperator.getSourceFromFile(validateFile);
        }
        boolean hasProblem = false;
        for (VjoSemanticProblem vjoSemanticProblem : actualProblems) {
            if (vjoSemanticProblem.type().equals((Object)ProblemSeverity.error)) {
                if (calc) {
                    evresult.setErrorNumber(evresult.getErrorNumber() + 1);
                }
                if (!reportLevel.equalsIgnoreCase(ProblemSeverity.error.toString()) && !reportLevel.equalsIgnoreCase("ALL")) continue;
                hasProblem = true;
                this.printProblem(message, vjoSemanticProblem, sources);
                continue;
            }
            if (!vjoSemanticProblem.type().equals((Object)ProblemSeverity.warning)) continue;
            if (calc) {
                evresult.setWarningNumber(evresult.getWarningNumber() + 1);
            }
            if (!reportLevel.equalsIgnoreCase(ProblemSeverity.warning.toString()) && !reportLevel.equalsIgnoreCase("ALL")) continue;
            hasProblem = true;
            this.printProblem(message, vjoSemanticProblem, sources);
        }
        if (hasProblem) {
            return "Problems with: " + validateFile.getAbsolutePath() + "\n" + message.toString();
        }
        return null;
    }

    protected void printProblem(StringBuffer message, VjoSemanticProblem vjoSemanticProblem, String sources) {
    }

    @Override
    public void printSummaryInformation(IHeadLessLauncherResult result) {
        System.out.println(result.getResultInformation());
    }
}

