/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.controller;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.jsgen.shared.generate.CodeStyle;
import org.eclipse.vjet.dsf.jsgen.shared.generate.JsrGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.generate.NativeJsProxyGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.util.CodeGenCleaner;
import org.eclipse.vjet.dsf.jst.FileBinding;
import org.eclipse.vjet.dsf.jst.IJstParseController;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.ts.IJstTypeLoader;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jstojava.controller.GeneratedResult;
import org.eclipse.vjet.dsf.jstojava.controller.GenerationConfig;
import org.eclipse.vjet.dsf.jstojava.controller.JstParseController;
import org.eclipse.vjet.dsf.jstojava.loader.DefaultJstTypeLoader;
import org.eclipse.vjet.dsf.jstojava.loader.OnDemandJstTypeLoader;
import org.eclipse.vjet.dsf.jstojava.parser.VjoParser;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateConfig;
import org.eclipse.vjet.dsf.ts.event.ISourceEvent;
import org.eclipse.vjet.dsf.ts.event.group.AddGroupEvent;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;
import org.eclipse.vjet.vjo.lib.TsLibLoader;

public class BuildController {
    private static final String JS_FILE_EXTENSION = ".js";
    private static final String JSR_FILE_EXTENSION = "Jsr.java";
    private Collection<IJstType> m_typesToProcess;
    private GeneratedResult m_result;
    private DefaultJstTypeLoader.FileSuffix[] m_suffix = new DefaultJstTypeLoader.FileSuffix[]{DefaultJstTypeLoader.FileSuffix.js};
    private IJstTypeLoader m_jstTypeLoader;

    public JstTypeSpaceMgr loadTypes(String group, String groupPath, String srcDir) {
        ArrayList<String> srcDirs = new ArrayList<String>(1);
        srcDirs.add(srcDir);
        return this.loadTypes(group, groupPath, srcDirs);
    }

    public JstTypeSpaceMgr loadTypes(String group, String groupPath, String[] srcDirs) {
        ArrayList<String> list = new ArrayList<String>(srcDirs.length);
        String[] stringArray = srcDirs;
        int n = srcDirs.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            list.add(f);
            ++n2;
        }
        return this.loadTypes(group, groupPath, list);
    }

    public JstTypeSpaceMgr loadTypes(String group, String groupPath, List<String> srcDirs) {
        TranslateConfig cfg = new TranslateConfig();
        cfg.setSkiptImplementation(true);
        VjoParser p = new VjoParser(cfg);
        JstParseController c = new JstParseController(p);
        JstTypeSpaceMgr mgr = new JstTypeSpaceMgr((IJstParseController)c, this.getJstTypeLoader());
        TsLibLoader.loadDefaultLibs((JstTypeSpaceMgr)mgr);
        mgr.initialize();
        mgr.processEvent(this.createBatchGroupEvent(group, groupPath, srcDirs));
        this.m_typesToProcess = mgr.getTypeSpace().getGroup(group).getEntities().values();
        this.processMissingTypes(mgr, mgr.getQueryExecutor().findMissingTypes());
        return mgr;
    }

    private void processMissingTypes(JstTypeSpaceMgr mgr, List<TypeName> findMissingTypes) {
        JstType OBJECT = JstCache.getInstance().getType("vjo.Object");
        JavaSourceLocator locator = JavaSourceLocator.getInstance();
        for (TypeName type : findMissingTypes) {
            System.out.print(String.valueOf(type.typeName()) + " : ");
            URL url = locator.getSourceUrl(type.typeName(), JS_FILE_EXTENSION);
            JstType typeFromCache = JstCache.getInstance().getType(type.typeName());
            if (!(typeFromCache instanceof JstType)) continue;
            JstType wcJstType = typeFromCache;
            wcJstType.addExtend((IJstType)OBJECT);
            System.out.println(url);
        }
    }

    public JstTypeSpaceMgr loadType(String group, IJstType type) {
        TranslateConfig cfg = new TranslateConfig();
        cfg.setSkiptImplementation(true);
        VjoParser p = new VjoParser(cfg);
        JstParseController c = new JstParseController(p);
        JstTypeSpaceMgr mgr = new JstTypeSpaceMgr((IJstParseController)c, (IJstTypeLoader)new OnDemandJstTypeLoader(group, type));
        TsLibLoader.loadDefaultLibs((JstTypeSpaceMgr)mgr);
        mgr.initialize();
        mgr.processEvent(this.createBatchGroupEvent(group, null, null));
        if (type != null) {
            this.m_typesToProcess = mgr.getTypeSpace().getGroup(group).getEntities().values();
        }
        return mgr;
    }

    public BuildController validate(IJstType type) {
        return this;
    }

    public BuildController validateAll(Collection<IJstType> type) {
        return this;
    }

    public DefaultJstTypeLoader.FileSuffix[] getSuffixes() {
        return this.m_suffix;
    }

    public void setSuffixes(DefaultJstTypeLoader.FileSuffix[] suffixes) {
        this.m_suffix = suffixes;
    }

    public BuildController generate(File file) {
        return this;
    }

    public BuildController generate(File file, GenerationConfig config) throws IOException {
        IJstType type = this.lookUpFromFile(file);
        return this.generate(type, config);
    }

    private IJstType lookUpFromFile(File file) {
        return null;
    }

    public BuildController generate(IJstType type, GenerationConfig config) throws IOException {
        this.m_result = new GeneratedResult();
        BuildInfo info = this.createBuildInfo(type, config);
        BuildController.generateJava(this.m_result, type, info, config);
        return this;
    }

    public BuildController generateAll() throws IOException {
        return this.generateAll(new GenerationConfig());
    }

    public BuildController generateAll(GenerationConfig config) throws IOException {
        Collection<IJstType> types = this.getTypesToProcess();
        if (types.size() == 0) {
            System.err.println("Found nothing to generateJs 2 Jsr/Native Proxy ");
            return this;
        }
        this.m_result = new GeneratedResult();
        for (IJstType t : types) {
            BuildInfo info = this.createBuildInfo(t, config);
            if (info == null) continue;
            BuildController.generateJava(this.m_result, t, info, config);
        }
        this.generatePkgSpecs(config);
        return this;
    }

    private BuildController generatePkgSpecs(GenerationConfig config) {
        Collection<IJstType> types = this.getTypesToProcess();
        new HashMap();
        for (IJstType t : types) {
            if (t.isEmbededType()) continue;
            if (t.getSource() == null || t.getSource().getBinding() == null) {
                System.out.println("JstType " + t.getName() + " has null source binding!");
                continue;
            }
            if (t.getPackage() == null) {
                System.out.println("JstType " + t.getName() + " has empty package!");
                continue;
            }
            if (config.getOutputDir() != null) {
                config.getOutputDir().getAbsolutePath();
                continue;
            }
            ((FileBinding)t.getSource().getBinding()).getFile().getParent();
        }
        return this;
    }

    private ISourceEvent createBatchGroupEvent(String groupName, String groupPath, List<String> srcDirs) {
        return new AddGroupEvent(groupName, groupPath, srcDirs, null);
    }

    private BuildInfo createBuildInfo(IJstType t, GenerationConfig config) {
        if (t.getSource() == null) {
            return null;
        }
        FileBinding fileBinding = (FileBinding)t.getSource().getBinding();
        if (fileBinding == null) {
            return null;
        }
        File jsFile = fileBinding.getFile();
        String pkg = t.getPackage().getName();
        File outputDir = fileBinding.getFile().getParentFile();
        if (config.getOutputDir() != null) {
            String rootOutput = config.getOutputDir().getAbsolutePath();
            String pkgPath = t.getPackage().getName().replace('.', File.separatorChar);
            outputDir = new File(String.valueOf(rootOutput) + File.separatorChar + pkgPath);
        }
        File jsrFile = BuildController.getVjo3OutputFile(t.getPackage().getName(), jsFile, outputDir);
        File nativeJsProxyFile = new File(outputDir, String.valueOf(t.getSimpleName()) + ".java");
        return new BuildInfo(fileBinding, jsFile, pkg, outputDir, jsrFile, nativeJsProxyFile);
    }

    private static IJstType generateJava(GeneratedResult result, IJstType jstType, BuildInfo info, GenerationConfig config) throws IOException {
        boolean isInputFileCodeGened = CodeGenCleaner.isCodeGened((File)info.getFile(), (boolean)false);
        if (config.isGenJsr() && !isInputFileCodeGened && BuildController.isOutputFileCodeGened(info.getJsrFile())) {
            FileWriter jsrWriter = new FileWriter(info.getJsrFile());
            BuildController.generateJsr(jstType, jsrWriter);
            result.addFile(info.getFile(), info.getJsrFile());
        }
        if (config.isGenNJP() && !isInputFileCodeGened && BuildController.isOutputFileCodeGened(info.getNJPFile())) {
            BuildController.generateNativeProxy(jstType, info);
            result.addFile(info.getFile(), info.getNJPFile());
        }
        return jstType;
    }

    private static boolean isOutputFileCodeGened(File file) {
        if (!file.exists()) {
            return true;
        }
        return CodeGenCleaner.isCodeGened((File)file, (boolean)true);
    }

    private static void generateJsr(IJstType jstType, FileWriter jsrWriter) {
        JsrGenerator generator = new JsrGenerator(new PrintWriter(jsrWriter), CodeStyle.PRETTY);
        try {
            generator.writeJsr(jstType);
            jsrWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new DsfRuntimeException("type could not be generated" + jstType.getName(), (Throwable)e);
        }
    }

    private static void generateNativeProxy(IJstType jstType, BuildInfo info) throws IOException {
        FileWriter writerForNativeJsProxy = null;
        if (!BuildController.skipProxyGen(jstType)) {
            File nativeJsProxyFile = info.getNJPFile();
            if (!nativeJsProxyFile.exists()) {
                nativeJsProxyFile.createNewFile();
            }
            if (nativeJsProxyFile.canWrite()) {
                writerForNativeJsProxy = new FileWriter(nativeJsProxyFile);
            }
        }
        if (writerForNativeJsProxy != null) {
            new NativeJsProxyGenerator(new PrintWriter(writerForNativeJsProxy), CodeStyle.PRETTY).writeProxy(jstType);
            writerForNativeJsProxy.flush();
            writerForNativeJsProxy.close();
        }
    }

    private static boolean skipProxyGen(IJstType jstType) {
        if (jstType.getName().startsWith("org.eclipse.vjet.vjo.java.")) {
            return true;
        }
        if (jstType.isInterface() || jstType.isEnum()) {
            return false;
        }
        if (jstType.isClass() || jstType.isOType()) {
            String typeName = jstType.getSimpleName();
            return "Object".equals(typeName) || "Class".equals(typeName);
        }
        return true;
    }

    private static File getVjo3OutputFile(String pkg, File jsFile, File outputDir) {
        String outputFileName = "";
        if (outputDir != null && pkg != null) {
            String jsrName = jsFile.getName().substring(0, jsFile.getName().indexOf("."));
            File f = new File(outputDir, "");
            if (!f.exists()) {
                f.mkdirs();
            }
            outputFileName = String.valueOf(f.getAbsolutePath()) + File.separatorChar + jsrName + JSR_FILE_EXTENSION;
        } else {
            outputFileName = jsFile.getPath().replace(JS_FILE_EXTENSION, JSR_FILE_EXTENSION);
        }
        return new File(outputFileName);
    }

    public Collection<IJstType> getTypesToProcess() {
        if (this.m_typesToProcess == null) {
            throw new DsfRuntimeException("no types to process, loading must be done first");
        }
        return this.m_typesToProcess;
    }

    public void clean() {
        if (this.m_result != null) {
            this.clean(this.m_result);
        }
    }

    public void clean(GeneratedResult result) {
        List<File> files = result.getAllGeneratedFiles();
        for (File f : files) {
            f.delete();
        }
    }

    public void printOut(PrintStream out, GeneratedResult result) {
        if (result == null) {
            return;
        }
        for (String key : result.getAllSourceFiles()) {
            out.println("source:" + key);
            for (File f : result.getGenFilesForSource(key)) {
                out.println("\t" + f);
            }
        }
    }

    public GeneratedResult getResult() {
        return this.m_result;
    }

    public IJstTypeLoader getJstTypeLoader() {
        if (this.m_jstTypeLoader == null) {
            this.m_jstTypeLoader = new DefaultJstTypeLoader(this.getSuffixes());
        }
        return this.m_jstTypeLoader;
    }

    public void setJstTypeLoader(IJstTypeLoader typeLoader) {
        this.m_jstTypeLoader = typeLoader;
    }

    static class BuildInfo {
        private final File m_file;
        private final FileBinding m_fileBinding;
        private final String m_pkg;
        private final File m_outputDir;
        private File m_jsrFile;
        private File m_njpFile;

        BuildInfo(FileBinding fileBinding, File jsFile, String pkg, File outputDir, File jsrFile, File njpFile) {
            this.m_file = jsFile;
            this.m_fileBinding = fileBinding;
            this.m_pkg = pkg;
            this.m_outputDir = outputDir;
            this.m_jsrFile = jsrFile;
            this.m_njpFile = njpFile;
        }

        File getFile() {
            return this.m_file;
        }

        FileBinding getFileBinding() {
            return this.m_fileBinding;
        }

        String getPkg() {
            return this.m_pkg;
        }

        File getOutputDir() {
            return this.m_outputDir;
        }

        private File getJsrFile() {
            return this.m_jsrFile;
        }

        private File getNJPFile() {
            return this.m_njpFile;
        }
    }
}

