/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.parser.bootstrap;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jst.meta.JsTypingMeta;
import org.eclipse.vjet.dsf.jst.util.bootstrap.JsBuilderDef;
import org.eclipse.vjet.dsf.jstojava.parser.AstCompilationResult;
import org.eclipse.vjet.dsf.jstojava.parser.SyntaxTreeFactory2;
import org.eclipse.vjet.dsf.jstojava.parser.VjoParser;
import org.eclipse.vjet.dsf.jstojava.parser.bootstrap.CombinationGenerator;
import org.eclipse.vjet.dsf.jstojava.parser.bootstrap.IFilter;
import org.eclipse.vjet.dsf.jstojava.parser.comments.CommentCollector;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsAttributed;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsFuncType;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsParam;
import org.eclipse.vjet.dsf.jstojava.report.DefaultErrorReporter;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.JstSourceUtil;
import org.eclipse.vjet.vjo.lib.LibManager;

public class BootstrapParser {
    private static final StateInfo ENDSTATE = new StateInfo(StateInfo.OrderedState.ORDERED, "END", 1000);

    public static Map<String, ? extends IJstType> createJstType(String groupName, File bootstrapFile, JsBuilderDef def, File topLevelExtApi) throws IOException {
        ArrayList<JsBuilderDef> list = new ArrayList<JsBuilderDef>(1);
        list.add(def);
        return BootstrapParser.createJstType(groupName, bootstrapFile, list, topLevelExtApi);
    }

    public static Map<String, ? extends IJstType> createJstType(String groupName, File bootstrapFile, List<JsBuilderDef> defs, File topLevelExtApi) throws IOException {
        LinkedHashMap<String, IJstType> typeList = new LinkedHashMap<String, IJstType>();
        IJstType topLevel = BootstrapParser.createTopLevelObj(topLevelExtApi, groupName);
        typeList.put(topLevel.getName(), topLevel);
        typeList.putAll(BootstrapParser.processDefs(defs, bootstrapFile.toURI().toURL()));
        return typeList;
    }

    public static Map<String, ? extends IJstType> createJstType(String groupName, URL bootstrapFile, JsBuilderDef def, URL topLevelExtApi) throws IOException {
        ArrayList<JsBuilderDef> list = new ArrayList<JsBuilderDef>(1);
        list.add(def);
        return BootstrapParser.createJstType(groupName, bootstrapFile, list, topLevelExtApi, new URL[0]);
    }

    public static Map<String, ? extends IJstType> createJstType(String groupName, URL bootstrapFile, List<JsBuilderDef> defs, URL topLevelExtApi, URL ... extentionTypes) throws IOException {
        LinkedHashMap<? extends String, Object> typeList = new LinkedHashMap<String, Object>();
        typeList.putAll(BootstrapParser.addExtentionTypes(extentionTypes, groupName));
        IJstType topLevel = BootstrapParser.createTopLevelObj(topLevelExtApi, groupName);
        typeList.put(topLevel.getName(), topLevel);
        typeList.putAll(BootstrapParser.processDefs(defs, bootstrapFile));
        BootstrapParser.dump(typeList.values());
        return typeList;
    }

    private static Map<? extends String, ? extends IJstType> addExtentionTypes(URL[] extentionTypes, String groupName) {
        LinkedHashMap<String, IJstType> mapOfTypes = new LinkedHashMap<String, IJstType>(extentionTypes.length);
        VjoParser p = new VjoParser();
        p.addLib(LibManager.getInstance().getJsNativeGlobalLib());
        URL[] uRLArray = extentionTypes;
        int n = extentionTypes.length;
        int n2 = 0;
        while (n2 < n) {
            URL extention = uRLArray[n2];
            IJstType unit = p.parse(groupName, extention);
            BootstrapParser.fixUnit((JstType)unit);
            JstCache.getInstance().addType((JstType)unit);
            mapOfTypes.put(unit.getName(), unit);
            ++n2;
        }
        return mapOfTypes;
    }

    private static void fixUnit(JstType t) {
        t.setImpliedImport(true);
        t.getModifiers().setStatic(true);
        if ("vjo.Object".equals(t.getName())) {
            t.removeExtend(t.getExtend());
            JstType object = JstCache.getInstance().getType("Object", false);
            t.addExtend((IJstType)object);
            ((JstProperty)t.getProperty("prototype", true)).setType((IJstType)object);
        }
    }

    protected static void dump(Collection<IJstType> jstTypes) {
        for (IJstType jstType : jstTypes) {
            JstArg arg;
            Iterator iter;
            JstArg arg2;
            Z z = new Z();
            z.format((Object)">> JstType");
            z.format("name", (Object)jstType.getName());
            z.format("modifiers", (Object)jstType.getModifiers());
            if (!jstType.getAnnotations().isEmpty()) {
                z.format("annotations", (Object)jstType.getAnnotations());
            }
            z.format("extends", (Object)jstType.getExtends());
            z.format((Object)"static props:");
            for (IJstProperty p : jstType.getAllPossibleProperties(true, true)) {
                if (!p.getAnnotations().isEmpty()) {
                    z.format("\tprops-annotations", (Object)p.getAnnotations());
                }
                z.append((Object)("\t" + p.getModifiers().toString()));
                z.append((Object)(" " + p.getType().getName()));
                z.append((Object)(" " + p.getName()));
                z.format((Object)";");
            }
            z.format((Object)"instance props:");
            for (IJstProperty p : jstType.getAllPossibleProperties(false, true)) {
                if (!p.getAnnotations().isEmpty()) {
                    z.format("\tprops-annotations", (Object)p.getAnnotations());
                }
                z.append((Object)("\t" + p.getModifiers().toString()));
                z.append((Object)(" " + p.getName()));
                z.format((Object)";");
            }
            IJstMethod cons = jstType.getConstructor();
            if (cons != null) {
                z.format((Object)"constructor:");
                z.append((Object)("\t" + cons.getModifiers().toString()));
                z.append((Object)(" " + cons.getName()));
                z.append((Object)"(");
                Iterator iter2 = cons.getArgs().iterator();
                while (iter2.hasNext()) {
                    JstArg arg3 = (JstArg)iter2.next();
                    z.append((Object)arg3.getType().getName());
                    z.append((Object)(" " + arg3.getName()));
                    if (!iter2.hasNext()) continue;
                    z.append((Object)", ");
                }
                z.format((Object)");");
                for (IJstMethod over : cons.getOverloaded()) {
                    z.format((Object)"overloaded-constructor:");
                    z.append((Object)("\t" + over.getModifiers().toString()));
                    z.append((Object)(" " + over.getName()));
                    z.append((Object)"(");
                    iter2 = over.getArgs().iterator();
                    while (iter2.hasNext()) {
                        arg2 = (JstArg)iter2.next();
                        z.append((Object)arg2.getType().getName());
                        z.append((Object)(" " + arg2.getName()));
                        if (!iter2.hasNext()) continue;
                        z.append((Object)", ");
                    }
                    z.format((Object)");");
                }
            }
            z.format((Object)"static methods:");
            for (IJstMethod m : jstType.getMethods(true, true)) {
                if (!m.getAnnotations().isEmpty()) {
                    z.format("\tmtd-annotations", (Object)m.getAnnotations());
                }
                z.append((Object)("\t" + m.getModifiers().toString() + " "));
                if (m.getRtnType() != null) {
                    z.append((Object)m.getRtnType().getName());
                    z.append((Object)" ");
                }
                z.append((Object)m.getName());
                z.append((Object)"(");
                iter = m.getArgs().iterator();
                while (iter.hasNext()) {
                    arg2 = (JstArg)iter.next();
                    z.append((Object)arg2.getType().getName());
                    z.append((Object)(" " + (arg2.isVariable() ? "..." : "") + arg2.getName()));
                    if (!iter.hasNext()) continue;
                    z.append((Object)", ");
                }
                z.format((Object)");");
                for (IJstMethod over : m.getOverloaded()) {
                    z.format((Object)"overloaded-method:");
                    z.append((Object)("\t" + over.getModifiers().toString()));
                    if (over.getRtnType() != null) {
                        z.append((Object)" ");
                        z.append((Object)over.getRtnType().getName());
                        z.append((Object)" ");
                    }
                    z.append((Object)(" " + over.getName()));
                    z.append((Object)"(");
                    iter = over.getArgs().iterator();
                    while (iter.hasNext()) {
                        arg = (JstArg)iter.next();
                        z.append((Object)arg.getType().getName());
                        z.append((Object)(" " + arg.getName()));
                        if (!iter.hasNext()) continue;
                        z.append((Object)", ");
                    }
                    z.format((Object)");");
                }
            }
            z.format((Object)"instance methods:");
            for (IJstMethod m : jstType.getMethods(false, true)) {
                if (!m.getAnnotations().isEmpty()) {
                    z.format("\tmtd-annotations", (Object)m.getAnnotations());
                }
                z.append((Object)("\t" + m.getModifiers().toString() + " "));
                if (m.getRtnType() != null) {
                    z.append((Object)m.getRtnType().getName());
                    z.append((Object)" ");
                }
                z.append((Object)m.getName());
                z.append((Object)"(");
                iter = m.getArgs().iterator();
                while (iter.hasNext()) {
                    arg2 = (JstArg)iter.next();
                    z.append((Object)arg2.getType().getName());
                    z.append((Object)(" " + (arg2.isVariable() ? "..." : "") + arg2.getName()));
                    if (!iter.hasNext()) continue;
                    z.append((Object)", ");
                }
                z.format((Object)");");
                for (IJstMethod over : m.getOverloaded()) {
                    z.format((Object)"overloaded-method:");
                    z.append((Object)("\t" + over.getModifiers().toString()));
                    if (over.getRtnType() != null) {
                        z.append((Object)" ");
                        z.append((Object)over.getRtnType().getName());
                        z.append((Object)" ");
                    }
                    z.append((Object)(" " + over.getName()));
                    z.append((Object)"(");
                    iter = over.getArgs().iterator();
                    while (iter.hasNext()) {
                        arg = (JstArg)iter.next();
                        z.append((Object)arg.getType().getName());
                        z.append((Object)(" " + arg.getName()));
                        if (!iter.hasNext()) continue;
                        z.append((Object)", ");
                    }
                    z.format((Object)");");
                }
            }
            System.out.println(z);
        }
    }

    private static IJstType createTopLevelObj(File topLevelExtApi, String groupName) {
        VjoParser p = new VjoParser();
        p.addLib(LibManager.getInstance().getJsNativeGlobalLib());
        return p.parse(groupName, topLevelExtApi);
    }

    private static IJstType createTopLevelObj(URL topLevelExtApi, String groupName) {
        VjoParser p = new VjoParser();
        p.addLib(LibManager.getInstance().getJsNativeGlobalLib());
        IJstType type = p.parse(groupName, topLevelExtApi);
        if (type instanceof JstType) {
            ((JstType)type).setImpliedImport(true);
        }
        return type;
    }

    private static Map<String, IJstType> processDefs(List<JsBuilderDef> defs, URL bootstrapFile) {
        Collection<IJsCommentMeta> commentList = null;
        try {
            commentList = BootstrapParser.collectComments(bootstrapFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LinkedHashMap<String, IJstType> list = new LinkedHashMap<String, IJstType>();
        for (JsBuilderDef def : defs) {
            Map<String, List<JstMethod>> map = BootstrapParser.createJstMethodMap(def, commentList, new IFilter(){

                @Override
                public boolean filter(JsBuilderDef def, JstMethod m) {
                    if (m.getRtnType().getName().equals(def.getType().getName())) {
                        return false;
                    }
                    return !m.getRtnType().getName().equals("T");
                }
            });
            list.putAll(BootstrapParser.processDef(def, map));
        }
        return list;
    }

    private static Map<String, ? extends JstType> processDef(JsBuilderDef def, Map<String, List<JstMethod>> map) {
        LinkedHashMap<String, JstType> types = new LinkedHashMap<String, JstType>();
        Map<String, StateInfo> states = BootstrapParser.calculateStates(def);
        BootstrapParser.printStates(states);
        for (StateInfo st : states.values()) {
            String baseName = def.getType().getName();
            JstType t = null;
            t = BootstrapParser.getType(st.m_id, baseName);
            t.setImpliedImport(true);
            t.clearMethods();
            for (SectionInfo si : st.m_sections) {
                List<JstMethod> methods = map.get(si.m_section.getMtd());
                if (methods == null) continue;
                BootstrapParser.addMethod(t, BootstrapParser.getType(si.m_nextState.m_id, baseName), methods);
            }
            types.put(t.getName(), t);
        }
        return types;
    }

    private static JstType getType(int id, String baseName) {
        JstType t;
        if (id == 0) {
            t = BootstrapParser.getType(baseName);
        } else {
            t = BootstrapParser.getType(String.valueOf(baseName) + id);
            t.setMetaType(true);
        }
        return t;
    }

    private static void calculateNextState(Map<String, StateInfo> states, JsBuilderDef def) {
        for (String state : states.keySet()) {
            StateInfo stateInfo = states.get(state);
            List<SectionInfo> sections = stateInfo.m_sections;
            for (SectionInfo sec : sections) {
                BootstrapParser.determineNextState(state, sec, states, def);
            }
        }
    }

    private static void determineNextState(String state, SectionInfo info, Map<String, StateInfo> states, JsBuilderDef def) {
        StateInfo stateInfo = states.get(state);
        if (info.m_section.getMax() > 1) {
            info.m_nextState = stateInfo;
            return;
        }
        List<SectionInfo> sections = stateInfo.m_sections;
        int lengthOfKey = sections.size() - 1;
        ArrayList<String> candidateKeys = new ArrayList<String>();
        for (String s : states.keySet()) {
            if (s.contains(info.m_section.getMtd())) continue;
            candidateKeys.add(s);
        }
        StateInfo currentState = states.get(state);
        BootstrapParser.determineKey(currentState, info, states, lengthOfKey, candidateKeys, sections, def.getAnyOrderGroup(info.m_section.getMtd()));
    }

    private static void determineKey(StateInfo currentState, SectionInfo info, Map<String, StateInfo> states, int lengthOfKey, List<String> candidateKeys, List<SectionInfo> sections, List<JsBuilderDef.Section> samegrp) {
        for (String candidateKey : candidateKeys) {
            StateInfo candiateState = states.get(candidateKey);
            if (candiateState.m_id < currentState.m_id) continue;
            boolean useKey = false;
            for (SectionInfo section : sections) {
                if (candiateState.m_sections.size() > lengthOfKey || candidateKey.indexOf(section.m_section.getMtd()) == -1) continue;
                useKey = true;
            }
            if (useKey) {
                info.m_nextState = states.get(candidateKey);
                return;
            }
            info.m_nextState = ENDSTATE;
        }
    }

    private static Map<String, StateInfo> calculateStates(JsBuilderDef def) {
        LinkedHashMap<String, StateInfo> states = new LinkedHashMap<String, StateInfo>();
        int stateCount = 0;
        StringBuilder sb = new StringBuilder();
        StateInfo firstState = new StateInfo(StateInfo.OrderedState.ORDERED, def.getType().getName(), stateCount);
        BootstrapParser.addStateSections(null, def, 0, firstState, sb);
        BootstrapParser.addState(states, sb.toString(), firstState);
        ++stateCount;
        HashMap temp = new HashMap();
        int i = 0;
        while (i < def.getSections().size()) {
            JsBuilderDef.Section sec = (JsBuilderDef.Section)def.getSections().get(i);
            if (!sec.isAnyOrder() && sec.getMax() == 1) {
                StateInfo info2 = new StateInfo(StateInfo.OrderedState.ORDERED, "", stateCount);
                StringBuilder sb2 = new StringBuilder();
                BootstrapParser.addStateSections(sec, def, i, info2, sb2);
                BootstrapParser.addState(states, sb2.toString(), info2);
                info2.m_name = sb2.toString();
                ++stateCount;
            } else if (sec.isAnyOrder() && sec.getMax() == 1 && temp.get(sec.getMtd()) == null) {
                List grps = def.getAnyOrderGroupMaxOne(sec.getMtd());
                for (JsBuilderDef.Section s : grps) {
                    temp.put(s.getMtd(), null);
                }
                int grpSize = grps.size();
                if (grpSize == 1) {
                    StateInfo info3 = new StateInfo(StateInfo.OrderedState.UNORDERED, "", stateCount);
                    List sections = def.getSections();
                    StringBuilder key = new StringBuilder();
                    boolean startNow = false;
                    for (JsBuilderDef.Section s : sections) {
                        if (s.getMtd().equals(sec.getMtd())) {
                            startNow = true;
                            continue;
                        }
                        if (!startNow) continue;
                        key.append(String.valueOf(s.getMtd()) + ",");
                        SectionInfo secInfo = new SectionInfo();
                        secInfo.m_section = s;
                        info3.m_sections.add(secInfo);
                    }
                    info3.m_name = key.toString();
                    BootstrapParser.addState(states, key.toString(), info3);
                    ++stateCount;
                } else {
                    int r = grpSize - 1;
                    while (r > 0) {
                        CombinationGenerator gen = new CombinationGenerator(grps.size(), r);
                        while (gen.hasMore()) {
                            String key;
                            StringBuffer combination = new StringBuffer();
                            int[] indices = gen.getNext();
                            StateInfo info3 = new StateInfo(StateInfo.OrderedState.UNORDERED, "", stateCount);
                            int j = 0;
                            while (j < indices.length) {
                                JsBuilderDef.Section section;
                                SectionInfo sectionInfo = new SectionInfo();
                                sectionInfo.m_section = section = (JsBuilderDef.Section)grps.get(indices[j]);
                                info3.m_sections.add(sectionInfo);
                                combination.append(String.valueOf(section.getMtd()) + ",");
                                if (j == indices.length - 1) {
                                    List sections = def.getNextOrderSections(section.getMtd());
                                    List samegrp = def.getAnyOrderGroup(section.getMtd());
                                    for (JsBuilderDef.Section s : sections) {
                                        if (s.isAnyOrder() && BootstrapParser.isInSameGrp(s, samegrp)) continue;
                                        SectionInfo secInfo = new SectionInfo();
                                        secInfo.m_section = s;
                                        info3.m_sections.add(secInfo);
                                        combination.append(String.valueOf(s.getMtd()) + ",");
                                    }
                                }
                                ++j;
                            }
                            info3.m_name = key = combination.toString().substring(0, combination.toString().lastIndexOf(44));
                            if (states.get(key) != null) continue;
                            states.put(key, info3);
                            ++stateCount;
                        }
                        --r;
                    }
                }
            }
            ++i;
        }
        BootstrapParser.ENDSTATE.m_id = stateCount;
        states.put("END", ENDSTATE);
        BootstrapParser.calculateNextState(states, def);
        return states;
    }

    private static void addState(Map<String, StateInfo> states, String stateName, StateInfo firstState) {
        if (states.get(stateName) == null) {
            states.put(stateName, firstState);
        }
    }

    private static boolean isInSameGrp(JsBuilderDef.Section s, List<JsBuilderDef.Section> samegrp) {
        for (JsBuilderDef.Section sec : samegrp) {
            if (!sec.getMtd().equals(s.getMtd())) continue;
            return true;
        }
        return false;
    }

    private static void addStateSections(JsBuilderDef.Section sec, JsBuilderDef def, int i, StateInfo info, StringBuilder sb) {
        int secId = i;
        while (secId < def.getSections().size()) {
            SectionInfo sinfo = new SectionInfo();
            JsBuilderDef.Section section = (JsBuilderDef.Section)def.getSections().get(secId);
            sb.append(String.valueOf(section.getMtd()) + ",");
            sinfo.m_section = section;
            info.m_sections.add(sinfo);
            ++secId;
        }
    }

    private static void printStates(Map<String, StateInfo> states) {
        System.out.println("&&&&&&&&&&&&&&&&&&&&&&");
        System.out.print("section\t");
        Iterator<StateInfo> iter = states.values().iterator();
        int i = 0;
        StateInfo firstKey = null;
        while (iter.hasNext()) {
            String key;
            StateInfo si = iter.next();
            if (i == 0) {
                firstKey = si;
            }
            if ((key = si.m_name).length() >= 3) {
                key = key.substring(0, 3);
                key = String.valueOf(key) + "(" + si.m_id + ")";
            }
            System.out.print(String.valueOf(key) + "\t");
            ++i;
        }
        System.out.println("");
        for (SectionInfo info : firstKey.m_sections) {
            JsBuilderDef.Section section = info.m_section;
            int max = section.getMtd().length();
            System.out.print(String.valueOf(section.getMtd().substring(0, max > 4 ? 4 : max)) + "\t");
            for (StateInfo state : states.values()) {
                SectionInfo section2 = state.getSection(section.getMtd());
                if (section2 != null && section2.m_nextState != null) {
                    System.out.print(String.valueOf(section2.m_nextState.m_id) + "\t");
                    continue;
                }
                if (section2 == null) {
                    System.out.print("no def\t");
                    continue;
                }
                System.out.print("unknown\t");
            }
            System.out.println();
        }
        System.out.println("\n&&&&&&&&&&&&&&&&&&&&&&");
    }

    private static JstType getType(List<JsTypingMeta> list) {
        JstType t = null;
        for (JsTypingMeta m : list) {
            JstType typeFromCache = JstCache.getInstance().getType(m.getType());
            if (typeFromCache == null && m instanceof JsAttributed) {
                JsAttributed jsa = (JsAttributed)m;
                typeFromCache = JstCache.getInstance().getType(String.valueOf(jsa.getAttributor().getType()) + "." + jsa.getName());
            }
            if (typeFromCache != null) {
                return typeFromCache;
            }
            System.out.println("creating empty type =" + list);
            t = JstFactory.getInstance().createJstType(m.getType(), true);
        }
        return t;
    }

    private static JstType getType(String type) {
        JstType typeFromCache = JstCache.getInstance().getType(type);
        if (typeFromCache != null) {
            return typeFromCache;
        }
        System.out.println("creating empty type =" + type);
        return JstFactory.getInstance().createJstType(type, true);
    }

    private static void addMethod(JstType t, JstType rtnType, List<JstMethod> methods) {
        if (methods == null) {
            return;
        }
        if (methods.size() > 1 || BootstrapParser.hasOptionalArgs(methods)) {
            BootstrapParser.handleOverloading(t, rtnType, methods);
        } else {
            JstMethod jstMethod = methods.get(0);
            JstMethod copy = BootstrapParser.createNewJstMethod((IJstMethod)jstMethod);
            copy.setRtnType((IJstType)rtnType);
            t.addMethod((IJstMethod)copy);
        }
    }

    private static boolean hasOptionalArgs(List<JstMethod> methods) {
        for (JstMethod m : methods) {
            for (JstArg a : m.getArgs()) {
                if (!a.isOptional()) continue;
                return true;
            }
        }
        return false;
    }

    private static void handleOverloading(JstType t, JstType rtnType, List<JstMethod> methods) {
        IJstMethod first = (IJstMethod)methods.get(0);
        JstArg[] argArr = first.getArgs().toArray(new JstArg[0]);
        JstMethod dispatcher = BootstrapParser.createNewJstMethod(first, argArr);
        if (rtnType != null) {
            dispatcher.setRtnType((IJstType)rtnType);
        }
        for (IJstMethod iJstMethod : methods) {
            if (first.getArgs().size() > 0 && ((JstArg)first.getArgs().get(0)).isOptional()) {
                argArr = new JstArg[]{};
            }
            JstMethod copy = BootstrapParser.createNewJstMethod(iJstMethod, argArr);
            if (rtnType != null) {
                copy.setRtnType((IJstType)rtnType);
            }
            dispatcher.addOverloaded(copy);
            copy.setParent((IJstNode)dispatcher, false);
        }
        TranslateHelper.fixArgsForDispatchMethod(dispatcher);
        t.addMethod((IJstMethod)dispatcher);
    }

    private static JstMethod createNewJstMethod(IJstMethod first) {
        JstArg[] argArr = new JstArg[first.getArgs().size()];
        return BootstrapParser.createNewJstMethod(first, argArr);
    }

    private static JstMethod createNewJstMethod(IJstMethod first, JstArg[] argArr) {
        JstMethod dispatcher = new JstMethod(first.getName(), first.getModifiers(), first.getRtnType(), first.getArgs().toArray(argArr));
        return dispatcher;
    }

    public static Collection<IJsCommentMeta> collectComments(URL f) throws IOException {
        Map settings = Collections.EMPTY_MAP;
        String mysource = VjoParser.getContent(f);
        char[] charsource = mysource.toCharArray();
        String encoding = null;
        AstCompilationResult astResult = SyntaxTreeFactory2.createASTCompilationResult(settings, charsource, f.toExternalForm(), encoding);
        CompilationUnitDeclaration compilationUnitDeclaration = astResult.getCompilationUnitDeclaration();
        JstSourceUtil jstSourceUtil = new JstSourceUtil(compilationUnitDeclaration.compilationResult.lineSeparatorPositions, compilationUnitDeclaration.sourceStart, compilationUnitDeclaration.sourceEnd);
        DefaultErrorReporter reporter = new DefaultErrorReporter();
        CommentCollector cc = new CommentCollector();
        cc.handle(compilationUnitDeclaration, reporter, jstSourceUtil);
        if (reporter.getErrors().size() > 0) {
            throw new DsfRuntimeException("file has syntax errors");
        }
        return cc.getCommentAllMeta();
    }

    public static Map<String, List<JstMethod>> createJstMethodMap(JsBuilderDef def, Collection<IJsCommentMeta> list, IFilter filter) {
        if (list.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, List<JstMethod>> map = new HashMap<String, List<JstMethod>>();
        BootstrapParser.processMtds(def, list, map, filter);
        return map;
    }

    private static void processMtds(JsBuilderDef def, Collection<IJsCommentMeta> list, Map<String, List<JstMethod>> map, IFilter filter) {
        for (IJsCommentMeta meta : list) {
            List<Object> mtdList;
            JstMethod mtd = new JstMethod(meta.getName(), new JstArg[0]);
            TranslateHelper.setModifiersFromMeta(meta, mtd.getModifiers());
            mtd.setHasJsAnnotation(true);
            JsFuncType funcType = (JsFuncType)meta.getTyping();
            mtd.setRtnType((IJstType)BootstrapParser.getType(funcType.getReturnType().getType()));
            BootstrapParser.processArgs(meta, mtd);
            if (filter != null && filter.filter(def, mtd)) continue;
            if (map.get(meta.getName()) == null) {
                mtdList = new ArrayList<JstMethod>();
                mtdList.add(mtd);
                map.put(meta.getName(), mtdList);
                continue;
            }
            mtdList = map.get(meta.getName());
            mtdList.add(mtd);
        }
    }

    private static void processArgs(IJsCommentMeta meta, JstMethod mtd) {
        for (JsParam param : ((JsFuncType)meta.getTyping()).getParams()) {
            JstType type = BootstrapParser.getType(param.getTypes());
            JstArg arg = new JstArg((IJstType)type, param.getName(), param.isVariable(), param.isOptional());
            mtd.addArg(arg);
        }
    }

    static class SectionInfo {
        JsBuilderDef.Section m_section;
        StateInfo m_nextState;

        SectionInfo() {
        }
    }

    static class SectionTuple {
        private final JsBuilderDef.Section m_section;
        private final int m_id;
        private final JstType m_type;

        public SectionTuple(JsBuilderDef.Section section, int id, JstType t) {
            this.m_section = section;
            this.m_id = id;
            this.m_type = t;
        }

        public JsBuilderDef.Section getSection() {
            return this.m_section;
        }

        public int getId() {
            return this.m_id;
        }

        public JstType getType() {
            return this.m_type;
        }
    }

    static class StateInfo {
        public int m_id;
        String m_name;
        List<SectionInfo> m_sections = new ArrayList<SectionInfo>();
        OrderedState m_orderedState;

        public StateInfo(OrderedState state, String name, int id) {
            this.m_orderedState = state;
            this.m_name = name;
            this.m_id = id;
        }

        public SectionInfo getSection(String s) {
            for (SectionInfo sec : this.m_sections) {
                if (!s.equals(sec.m_section.getMtd())) continue;
                return sec;
            }
            return null;
        }

        public OrderedState getOrderedState() {
            return this.m_orderedState;
        }

        static enum OrderedState {
            ORDERED,
            UNORDERED;

        }
    }
}

