/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.resolver;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.jstojava.resolver.ITypeResolver;

public class MapBasedTypeResolver
implements ITypeResolver {
    private final String m_groupId;
    private final Map<String, String> m_typeMapping = new HashMap<String, String>();

    public MapBasedTypeResolver(String groupId) {
        this.m_groupId = groupId;
    }

    @Override
    public String[] getGroupIds() {
        return new String[]{this.m_groupId};
    }

    @Override
    public String resolve(String[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        String val = MapBasedTypeResolver.getStrValue(args[0]);
        return val == null ? null : this.m_typeMapping.get(val);
    }

    public MapBasedTypeResolver addMapping(String lookupKey, String typeName) {
        this.m_typeMapping.put(lookupKey, typeName);
        return this;
    }

    private static String getStrValue(String quottedValue) {
        if (quottedValue.startsWith("\"") && quottedValue.endsWith("\"") || quottedValue.startsWith("'") && quottedValue.endsWith("'")) {
            return quottedValue.substring(1, quottedValue.length() - 1);
        }
        return null;
    }
}

