/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.meta.JsTypingMeta;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsCommentMeta;
import org.eclipse.vjet.dsf.jstojava.parser.comments.ParseException;
import org.eclipse.vjet.dsf.jstojava.parser.comments.TokenMgrError;
import org.eclipse.vjet.dsf.jstojava.parser.comments.VjComment;
import org.eclipse.vjet.dsf.jstojava.report.ErrorReporter;
import org.eclipse.vjet.dsf.jstojava.resolver.IOTypeResolver;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;

public class OTypeResolverRegistry {
    private static final OTypeResolverRegistry s_instance = new OTypeResolverRegistry();
    private Map<String, List<IOTypeResolver>> m_resolvers = new HashMap<String, List<IOTypeResolver>>();

    public static OTypeResolverRegistry getInstance() {
        return s_instance;
    }

    public OTypeResolverRegistry addResolver(String key, IOTypeResolver resolver) {
        List<IOTypeResolver> resolverList = this.m_resolvers.get(key);
        if (resolverList == null) {
            resolverList = new ArrayList<IOTypeResolver>(1);
            this.m_resolvers.put(key, resolverList);
        }
        resolverList.add(resolver);
        return this;
    }

    public IJstType resolve(String key, NV args) {
        List<IOTypeResolver> resolverList = this.m_resolvers.get(key);
        if (resolverList == null) {
            return null;
        }
        int i = 0;
        while (i < resolverList.size()) {
            IOTypeResolver resolver = resolverList.get(i);
            String typeName = resolver.resolve(args);
            if (typeName == null) {
                return null;
            }
            if (typeName.contains("org.mozilla.mod.javascript.Undefined")) {
                return null;
            }
            try {
                JsCommentMeta commentMeta = VjComment.parse("//> " + typeName);
                JsTypingMeta typingMeta = commentMeta.getTyping();
                IFindTypeSupport findSupport = new IFindTypeSupport(){

                    @Override
                    public char[] getOriginalSource() {
                        return null;
                    }

                    @Override
                    public IFindTypeSupport.ILineInfoProvider getLineInfoProvider() {
                        return null;
                    }

                    @Override
                    public ErrorReporter getErrorReporter() {
                        return null;
                    }

                    @Override
                    public IJstType getCurrentType() {
                        return null;
                    }

                    @Override
                    public IJstType findTypeByName(String name) {
                        return null;
                    }

                    @Override
                    public int[] getLineEndings() {
                        return null;
                    }
                };
                return TranslateHelper.findType(findSupport, typingMeta, commentMeta);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (TokenMgrError tokenMgrError) {}
            ++i;
        }
        return null;
    }

    public boolean hasResolver(String key) {
        return this.m_resolvers.containsKey(key);
    }

    public boolean hasResolvers() {
        return !this.m_resolvers.isEmpty();
    }

    public void clear(String groupId) {
        for (List<IOTypeResolver> resolverList : this.m_resolvers.values()) {
            int i = resolverList.size() - 1;
            while (i >= 0) {
                IOTypeResolver resolver = resolverList.get(i);
                String[] stringArray = resolver.getGroupIds();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String group = stringArray[n2];
                    if (groupId.endsWith(group)) {
                        resolverList.remove(resolver);
                    }
                    ++n2;
                }
                --i;
            }
        }
    }

    public void clearAll() {
        this.m_resolvers.clear();
    }

    public Set<String> getKeys() {
        return this.m_resolvers.keySet();
    }
}

