/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust;

import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;

public class JstSourceUtil
implements IFindTypeSupport.ILineInfoProvider {
    private int[] lineEndTable;
    private int m_startPosition;
    private int m_length;

    public JstSourceUtil(int[] lineSeperatorPositions, int startPosition, int length) {
        this.lineEndTable = lineSeperatorPositions;
        this.m_startPosition = startPosition;
        this.m_length = length;
    }

    @Override
    public int line(int startOffset) {
        return this.getLineNumber(startOffset);
    }

    public int getLineNumber(int position) {
        if (this.lineEndTable == null) {
            return -2;
        }
        int length = this.lineEndTable.length;
        if (length == 0) {
            if (position >= this.getStartPosition() + this.getLength()) {
                return -1;
            }
            return 1;
        }
        int low = 0;
        if (position < 0) {
            return -1;
        }
        if (position <= this.lineEndTable[low]) {
            return 1;
        }
        int hi = length - 1;
        if (position > this.lineEndTable[hi]) {
            if (position >= this.getStartPosition() + this.getLength()) {
                return -1;
            }
            return length + 1;
        }
        while (low + 1 != hi) {
            int mid = low + (hi - low) / 2;
            if (position <= this.lineEndTable[mid]) {
                hi = mid;
                continue;
            }
            low = mid;
        }
        return low + 2;
    }

    private int getLength() {
        return 0;
    }

    private int getStartPosition() {
        return 0;
    }

    @Override
    public int col(int beginOffset) {
        return this.getColumnNumber(beginOffset);
    }

    public int getColumnNumber(int position) {
        int currentLineEnd;
        if (this.lineEndTable == null) {
            return -2;
        }
        int line = this.getLineNumber(position);
        if (line == -1) {
            return -1;
        }
        if (line == 1) {
            if (position >= this.getStartPosition() + this.getLength()) {
                return -1;
            }
            return position;
        }
        int length = this.lineEndTable.length;
        int previousLineOffset = this.lineEndTable[line - 2];
        int offsetForLine = previousLineOffset + 1;
        int n = currentLineEnd = line == length + 1 ? this.getStartPosition() + this.getLength() - 1 : this.lineEndTable[line - 1];
        if (offsetForLine > currentLineEnd) {
            return -1;
        }
        return position - offsetForLine;
    }
}

