/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.mod.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstDefaultConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.TopLevelJstBlock;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jstojava.translator.BaseTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.TypeTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.IntegerHolder;
import org.eclipse.vjet.dsf.jstojava.translator.robust.RootRobustTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCommentCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnSingleNameReference;

public class RobustASTTranslator
extends BaseTranslator {
    private static Set<String> VJO_TYPE_DEF_KEYS = new HashSet<String>();

    static {
        VJO_TYPE_DEF_KEYS.add("type");
        VJO_TYPE_DEF_KEYS.add("ctype");
        VJO_TYPE_DEF_KEYS.add("itype");
        VJO_TYPE_DEF_KEYS.add("ftype");
        VJO_TYPE_DEF_KEYS.add("mtype");
        VJO_TYPE_DEF_KEYS.add("otype");
        VJO_TYPE_DEF_KEYS.add("etype");
        VJO_TYPE_DEF_KEYS.add("ltype");
    }

    public RobustASTTranslator(TranslateCtx ctx) {
        super(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JstType translate(CompilationUnitDeclaration astUnit) {
        String name = String.valueOf(astUnit.getFileName());
        IJstType jstType = TranslateHelper.findType((IFindTypeSupport)this.m_ctx, name);
        JstType jst = (JstType)TranslateHelper.getJstType(jstType);
        if (jst == null) {
            return null;
        }
        JstType jstType2 = jst;
        synchronized (jstType2) {
            jst.clearAll();
            JstModifiers modifiers = jst.getModifiers();
            modifiers.setPublic();
            modifiers.setStatic(false);
            modifiers.setFinal(false);
            modifiers.setAbstract(false);
            if (RootRobustTranslator.preTransform(jst, this.m_ctx, this.m_ctx.getCompletionPos())) {
                this.m_ctx.setCompletionPos(-1);
            }
            IntegerHolder completionPos = new IntegerHolder(this.m_ctx.getCompletionPos());
            StatementGroup group = RobustASTTranslator.getStatementGroup(astUnit);
            if (group.m_needsDeclarations.size() > 0) {
                for (Stack<IProgramElement> elements : group.m_needsDeclarations) {
                    new RootRobustTranslator(elements, jst, this, completionPos).transform();
                }
            }
            if (group.m_typeDeclaration != null) {
                JstPackage jstPackage;
                JstMethod constructor;
                new RootRobustTranslator(group.m_typeDeclaration, jst, this, completionPos).transform();
                if (jst.isClass() && (constructor = jst.getConstructor()) == null) {
                    jst.setConstructor((JstMethod)new JstDefaultConstructor((IJstType)jst));
                }
                if ((jstPackage = jst.getPackage()) == null) {
                    jstPackage = new JstPackage();
                    jstPackage.setGroupName(this.m_ctx.getGroup());
                    jst.setPackage(jstPackage);
                }
            } else if (group.m_extraStatements.size() >= 0) {
                Statement[] statements = new Statement[group.m_extraStatements.size()];
                statements = group.m_extraStatements.toArray(statements);
                JstSource oldSrc = jst.getSource();
                JstSource src = new JstSource(2, oldSrc == null ? null : oldSrc.getBinding(), -1, -1, astUnit.sourceEnd() + 2, 0, astUnit.sourceEnd() + 2);
                int index = name.lastIndexOf(".");
                if (index != -1) {
                    jst.setPackage(new JstPackage(name.substring(0, index)));
                    jst.setSimpleName(name.substring(index + 1));
                } else {
                    jst.setSimpleName(name);
                }
                jst.setFakeType(true);
                jst.setSource(src);
                if (statements.length > 0) {
                    jst.setCommentLocations(this.m_ctx.getCommentCollector().getCommentLocationNonMeta(statements[0].sourceStart, 0));
                }
                TypeTranslator.addInactiveNeeds(jst, this.m_ctx);
                if (jst.getImports().size() > 0 || jst.getInactiveImports().size() > 0) {
                    TopLevelJstBlock proxy = new TopLevelJstBlock();
                    jst.setInitBlock((JstBlock)proxy);
                    for (IJstType importedType : jst.getImports()) {
                        if (!importedType.isFakeType()) continue;
                        proxy.addIncludedType(importedType);
                    }
                    for (IJstType importedType : jst.getInactiveImports()) {
                        if (!importedType.isFakeType()) continue;
                        proxy.addIncludedType(importedType);
                    }
                }
                jst.getInitBlock().setSource(src);
                this.m_ctx.setCurrentType(jst);
                this.m_ctx.enterBlock(ScopeIds.INITS);
                JstBlock block = new JstBlock();
                block.setSource(src);
                TranslateHelper.addStatementsToJstBlock(statements, block, astUnit.sourceEnd(), this.m_ctx);
                if (this.m_ctx.getJstErrors().size() == 0) {
                    JstCompletion completion = null;
                    int[] commentOffsets = this.inCommentRange(astUnit.comments, this.m_ctx.getCompletionPos());
                    if (commentOffsets != null) {
                        char[] source = this.m_ctx.getOriginalSource();
                        StringBuilder commentchars = new StringBuilder();
                        int i = Math.abs(commentOffsets[0]);
                        while (i < Math.abs(commentOffsets[1])) {
                            commentchars.append(source[i]);
                            ++i;
                        }
                        completion = new JstCommentCompletion((BaseJstNode)jst, commentchars.toString(), this.m_ctx.getCompletionPos() - Math.abs(commentOffsets[0]));
                    } else {
                        completion = new JstCompletionOnSingleNameReference((BaseJstNode)jst);
                        completion.setToken("");
                    }
                    JstSource completionSource = TranslateHelper.createJstSource(this.m_ctx.getSourceUtil(), 0, this.m_ctx.getCompletionPos(), this.m_ctx.getCompletionPos());
                    completion.setSource(completionSource);
                    completion.setScopeStack(this.m_ctx.getScopeStack());
                    this.m_ctx.setCreatedCompletion(true);
                    this.m_ctx.addSyntaxError(completion);
                }
                for (IStmt stmt : block.getStmts()) {
                    jst.addInit(stmt, true);
                }
                this.m_ctx.exitBlock();
            }
        }
        return jst;
    }

    private int[] inCommentRange(int[][] comments, int completionPos) {
        int[][] nArray = comments;
        int n = comments.length;
        int n2 = 0;
        while (n2 < n) {
            int[] location = nArray[n2];
            if (Math.abs(location[0]) < completionPos && Math.abs(location[1]) + 1 > completionPos) {
                return location;
            }
            ++n2;
        }
        return null;
    }

    private static StatementGroup getStatementGroup(CompilationUnitDeclaration astUnit) {
        IProgramElement[] statements;
        StatementGroup group = new StatementGroup();
        IProgramElement[] iProgramElementArray = statements = astUnit.getStatements();
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            IProgramElement statement;
            IProgramElement receiver = statement = iProgramElementArray[n2];
            Stack<IProgramElement> elements = new Stack<IProgramElement>();
            IProgramElement pre = null;
            boolean isExtra = true;
            while (receiver != null) {
                elements.push(receiver);
                if (receiver instanceof MessageSend) {
                    pre = receiver;
                    receiver = ((MessageSend)receiver).receiver;
                    continue;
                }
                if (receiver instanceof FieldReference) {
                    pre = receiver;
                    receiver = ((FieldReference)receiver).receiver;
                    continue;
                }
                if (!(receiver instanceof SingleNameReference) || !"vjo".equals(((SingleNameReference)receiver).toString())) break;
                String name = null;
                if (pre instanceof MessageSend) {
                    name = new String(((MessageSend)pre).getSelector());
                } else if (pre instanceof FieldReference) {
                    name = new String(((FieldReference)pre).getToken());
                }
                if (name != null && RobustASTTranslator.isValidTypeDef(name)) {
                    group.m_typeDeclaration = elements;
                    isExtra = false;
                    break;
                }
                if (!"needs".equals(name)) break;
                group.m_needsDeclarations.add(elements);
                isExtra = false;
                break;
            }
            if (isExtra && statement instanceof Statement) {
                group.m_extraStatements.add((Statement)statement);
            }
            ++n2;
        }
        return group;
    }

    private static boolean isValidTypeDef(String name) {
        return VJO_TYPE_DEF_KEYS.contains(name);
    }

    private static class StatementGroup {
        Stack<IProgramElement> m_typeDeclaration = null;
        List<Stack<IProgramElement>> m_needsDeclarations = new ArrayList<Stack<IProgramElement>>(1);
        List<Statement> m_extraStatements = new ArrayList<Statement>();

        private StatementGroup() {
        }
    }
}

