/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst;

import java.util.ArrayList;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ForStatement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.ConditionalExpr;
import org.eclipse.vjet.dsf.jst.expr.JstInitializer;
import org.eclipse.vjet.dsf.jst.expr.ListExpr;
import org.eclipse.vjet.dsf.jst.stmt.ForStmt;
import org.eclipse.vjet.dsf.jst.token.IBoolExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IInitializer;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;

public class ForStatementTranslator
extends BaseAst2JstTranslator<ForStatement, ForStmt> {
    @Override
    protected ForStmt doTranslate(ForStatement statement) {
        assert (statement != null);
        ForStmt forStmt = new ForStmt();
        if (this.m_parent != null) {
            this.m_parent.addChild((IJstNode)forStmt);
        }
        try {
            this.m_ctx.enterBlock(ScopeIds.LOOP);
            this.doTranslate(statement, forStmt);
        }
        finally {
            this.m_ctx.exitBlock();
        }
        return forStmt;
    }

    private void doTranslate(ForStatement statement, ForStmt forStmt) {
        Object obj;
        if (statement.initializations != null && statement.initializations.length > 0) {
            Statement[] inits = statement.initializations;
            ArrayList<AssignExpr> list = new ArrayList<AssignExpr>();
            ArrayList<JstVars> multipleVars = new ArrayList<JstVars>();
            boolean isLocalDeclaration = false;
            JstVars jstVars = null;
            int initcount = 0;
            Statement[] statementArray = inits;
            int n = inits.length;
            int n2 = 0;
            while (n2 < n) {
                Statement initializer = statementArray[n2];
                if (initializer.getASTType() == 66) {
                    isLocalDeclaration = true;
                }
                if (initcount + 1 < inits.length) {
                    this.m_ctx.setNextNodeSourceStart(inits[initcount + 1].sourceStart);
                } else if (statement.condition != null) {
                    this.m_ctx.setNextNodeSourceStart(statement.condition.sourceStart);
                } else if (statement.condition == null && statement.increments != null && statement.increments.length > 0) {
                    this.m_ctx.setNextNodeSourceStart(statement.increments[0].sourceStart);
                }
                Object translated = this.getTranslatorAndTranslate((IASTNode)initializer, (BaseJstNode)forStmt);
                if (translated instanceof JstVars[]) {
                    JstVars[] multiVars;
                    JstVars[] jstVarsArray = multiVars = (JstVars[])translated;
                    int n3 = multiVars.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        JstVars jstVars2 = jstVarsArray[n4];
                        multipleVars.add(jstVars2);
                        ++n4;
                    }
                } else if (translated instanceof JstVars) {
                    multipleVars.add((JstVars)translated);
                } else if (translated instanceof AssignExpr) {
                    AssignExpr assignExpr = (AssignExpr)translated;
                    list.add(assignExpr);
                } else if (translated instanceof ListExpr) {
                    IExpr[] listOfAsignments;
                    JstType obj2 = JstCache.getInstance().getType("Undefined");
                    jstVars = new JstVars((IJstType)obj2);
                    ListExpr listExpr = (ListExpr)translated;
                    IExpr[] iExprArray = listOfAsignments = listExpr.getExprTerms();
                    int n5 = listOfAsignments.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IExpr iExpr = iExprArray[n6];
                        if (iExpr instanceof AssignExpr) {
                            jstVars.addAssignment((AssignExpr)iExpr);
                        }
                        ++n6;
                    }
                } else {
                    System.err.println("Unprocessed type: " + initializer.getClass() + " in ForStatementTranslator");
                }
                ++initcount;
                ++n2;
            }
            if (isLocalDeclaration) {
                JstVars primaryVar = (JstVars)multipleVars.get(0);
                if (multipleVars.size() > 1) {
                    int i = 1;
                    while (i < multipleVars.size()) {
                        primaryVar.addChild((IJstNode)multipleVars.get(i));
                        ++i;
                    }
                }
                forStmt.setInitializer((IInitializer)primaryVar);
            } else {
                JstInitializer jstInitializer = null;
                for (AssignExpr assignExpr : list) {
                    if (jstInitializer == null) {
                        jstInitializer = new JstInitializer();
                        forStmt.setInitializer((IInitializer)jstInitializer);
                    }
                    jstInitializer.addAssignment(assignExpr);
                }
                forStmt.setInitializer(jstInitializer);
            }
        }
        if (statement.condition != null) {
            IExpr cond = (IExpr)this.getTranslatorAndTranslate((IASTNode)statement.condition, (BaseJstNode)forStmt);
            forStmt.setCondition((IBoolExpr)TranslateHelper.buildCondition(cond));
        }
        if (statement.increments != null) {
            Statement[] statementArray = statement.increments;
            int n = statement.increments.length;
            int n7 = 0;
            while (n7 < n) {
                Statement increment = statementArray[n7];
                forStmt.addUpdater((IExpr)this.getTranslatorAndTranslate((IASTNode)increment, (BaseJstNode)forStmt));
                ++n7;
            }
        }
        if (!statement.isEmptyBlock() && !((obj = this.getTranslatorAndTranslate((IASTNode)statement.action, (BaseJstNode)forStmt.getBody())) instanceof JstBlock)) {
            if (obj instanceof IStmt) {
                forStmt.getBody().addStmt((IStmt)obj);
            } else if (obj instanceof ConditionalExpr) {
                forStmt.getBody().addChild((IJstNode)((ConditionalExpr)obj));
            }
        }
        forStmt.setSource(TranslateHelper.getSource((IASTNode)statement, this.m_ctx.getSourceUtil()));
    }
}

