/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.core.StepFilterManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.mod.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.mod.internal.debug.ui.ScriptDebugOptionsManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.vjet.eclipse.debug.ui.VjetDebugUIPlugin;

public class VjetDebugOptionsManager
implements IPropertyChangeListener,
IDebugEventSetListener,
Preferences.IPropertyChangeListener {
    private static VjetDebugOptionsManager instance;
    private String[] m_activeStepFilters;

    public static VjetDebugOptionsManager getDefault() {
        if (instance == null) {
            instance = new VjetDebugOptionsManager();
        }
        return instance;
    }

    private VjetDebugOptionsManager() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (this.isFilterListProperty(property)) {
            this.refreshActiveStepFilters();
            this.notifyTargetsOfFilters();
        }
    }

    private boolean isFilterListProperty(String property) {
        return "org.eclipse.dltk.mod.debug.ui.preference_active_filters_list".equals(property) || "org.eclipse.dltk.mod.debug.ui.preference_inactive_filters_list".equals(property);
    }

    protected void notifyTargetsOfFilters() {
        IDebugTarget[] targets = this.getAllDebugTargets();
        int i = 0;
        while (i < targets.length) {
            if (targets[i] instanceof IScriptDebugTarget) {
                IScriptDebugTarget target = (IScriptDebugTarget)targets[i];
                this.notifyTargetOfFilters(target);
            }
            ++i;
        }
    }

    private IDebugTarget[] getAllDebugTargets() {
        return DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
    }

    private void notifyTargetOfFilters(IScriptDebugTarget target) {
        target.setUseStepFilters(DebugUITools.isUseStepFilters());
        target.setFilters(this.getActiveStepFilters());
    }

    private String[] getActiveStepFilters() {
        if (this.m_activeStepFilters == null) {
            this.refreshActiveStepFilters();
            this.registerListener();
        }
        return this.m_activeStepFilters;
    }

    private void registerListener() {
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    private void refreshActiveStepFilters() {
        String[] storedActiveStepFilters = ScriptDebugOptionsManager.parseList((String)this.getPreferenceStore().getString("org.eclipse.dltk.mod.debug.ui.preference_active_filters_list"));
        storedActiveStepFilters = VjetDebugOptionsManager.convert2RegExp(storedActiveStepFilters);
        this.m_activeStepFilters = storedActiveStepFilters;
    }

    public static String[] convert2RegExp(String[] filters) {
        int i = 0;
        while (i < filters.length) {
            String filter = filters[i];
            filter = filter.replace('\\', '/');
            filter = filter.replace(".", "\\.");
            filters[i] = filter.replace("*", ".*");
            ++i;
        }
        return filters;
    }

    private IPreferenceStore getPreferenceStore() {
        return VjetDebugUIPlugin.getDefault().getPreferenceStore();
    }

    public void start() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void stop() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            Object source = event.getSource();
            switch (event.getKind()) {
                case 4: {
                    if (!(source instanceof IScriptDebugTarget)) break;
                    this.notifyTargetOfFilters((IScriptDebugTarget)source);
                    break;
                }
            }
            ++n2;
        }
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        String property = event.getProperty();
        if (StepFilterManager.PREF_USE_STEP_FILTERS.equals(property)) {
            IDebugTarget[] debugTargets;
            IDebugTarget[] iDebugTargetArray = debugTargets = this.getAllDebugTargets();
            int n = debugTargets.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugTarget target = iDebugTargetArray[n2];
                if (target instanceof IScriptDebugTarget) {
                    ((IScriptDebugTarget)target).setUseStepFilters(DebugUITools.isUseStepFilters());
                }
                ++n2;
            }
        }
    }
}

