/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui.pref;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelElementVisitor;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptModel;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.debug.ui.preferences.Filter;
import org.eclipse.dltk.mod.debug.ui.preferences.FilterLabelProvider;
import org.eclipse.dltk.mod.debug.ui.preferences.FilterViewerComparator;
import org.eclipse.dltk.mod.debug.ui.preferences.ScriptDebugPreferencesMessages;
import org.eclipse.dltk.mod.debug.ui.preferences.dialogs.CreateStepFilterDialog;
import org.eclipse.dltk.mod.internal.debug.ui.ScriptDebugOptionsManager;
import org.eclipse.dltk.mod.ui.DLTKExecuteExtensionHelper;
import org.eclipse.dltk.mod.ui.DLTKUILanguageManager;
import org.eclipse.dltk.mod.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.mod.ui.ModelElementLabelProvider;
import org.eclipse.dltk.mod.ui.util.SWTFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.vjet.eclipse.debug.ui.VjetDebugUIPlugin;
import org.eclipse.vjet.eclipse.internal.debug.ui.pref.VjetDebugPrefMessages;
import org.eclipse.vjet.eclipse.internal.ui.dialogs.VjoTypeSelectionDialog;

public class VjetStepFilterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IExecutableExtension {
    public static final String PAGE_ID = "org.eclipse.vjet.eclipse.preferences.debug.stepfiltering";
    private CheckboxTableViewer m_tableViewer;
    private Button m_useStepFiltersButton;
    private Button m_removeFilterButton;
    private Button m_selectAllButton;
    private Button m_deselectAllButton;
    private IDLTKLanguageToolkit m_toolkit;
    private Button m_addFilterButton;

    public VjetStepFilterPreferencePage() {
        this.setTitle(ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_title);
        this.setDescription(ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_description);
    }

    protected Control createContents(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808, (int)0, (int)0);
        this.createStepFilterPreferences(composite);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    private void handleFilterViewerKeyPress(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            this.removeFilters();
        }
    }

    private void createStepFilterPreferences(Composite parent) {
        Composite container = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)2, (int)1, (int)1808, (int)0, (int)0);
        this.m_useStepFiltersButton = SWTFactory.createCheckButton((Composite)container, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage__Use_step_filters, null, (boolean)DebugUITools.isUseStepFilters(), (int)2);
        this.m_useStepFiltersButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VjetStepFilterPreferencePage.this.setPageEnablement(VjetStepFilterPreferencePage.this.m_useStepFiltersButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        SWTFactory.createLabel((Composite)container, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Defined_step_fi_lters__8, (int)2);
        this.m_tableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)68354);
        this.m_tableViewer.getTable().setFont(container.getFont());
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider(){

            public Image getColumnImage(Object object, int column) {
                return null;
            }
        });
        this.m_tableViewer.setComparator((ViewerComparator)new FilterViewerComparator());
        this.m_tableViewer.setContentProvider((IContentProvider)new StepFilterContentProvider());
        this.m_tableViewer.setInput((Object)this.getAllStoredFilters(false));
        this.m_tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.m_tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((Filter)event.getElement()).setChecked(event.getChecked());
            }
        });
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    VjetStepFilterPreferencePage.this.m_removeFilterButton.setEnabled(false);
                } else {
                    VjetStepFilterPreferencePage.this.m_removeFilterButton.setEnabled(true);
                }
            }
        });
        this.m_tableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                VjetStepFilterPreferencePage.this.handleFilterViewerKeyPress(event);
            }
        });
        this.createStepFilterButtons(container);
        this.createStepFilterCheckboxes(container);
        this.setPageEnablement(this.m_useStepFiltersButton.getSelection());
    }

    private void initTableState(boolean defaults) {
        Filter[] filters = this.getAllStoredFilters(defaults);
        int i = 0;
        while (i < filters.length) {
            this.m_tableViewer.add((Object)filters[i]);
            this.m_tableViewer.setChecked((Object)filters[i], filters[i].isChecked());
            ++i;
        }
    }

    protected void setPageEnablement(boolean enabled) {
        this.m_addFilterButton.setEnabled(enabled);
        this.m_deselectAllButton.setEnabled(enabled);
        this.m_selectAllButton.setEnabled(enabled);
        this.m_tableViewer.getTable().setEnabled(enabled);
        this.m_removeFilterButton.setEnabled(enabled & !this.m_tableViewer.getSelection().isEmpty());
    }

    private void createStepFilterCheckboxes(Composite container) {
    }

    private void createStepFilterButtons(Composite container) {
        this.initializeDialogUnits((Control)container);
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.m_addFilterButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)VjetDebugPrefMessages.VjetStepFilterPreferencePage_addFilterButton_text, (String)VjetDebugPrefMessages.VjetStepFilterPreferencePage_addFilterButton_description, null);
        this.m_addFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VjetStepFilterPreferencePage.this.addNewFilter();
            }
        });
        this.m_removeFilterButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage__Remove_15, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Remove_all_selected_step_filters_16, null);
        this.m_removeFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VjetStepFilterPreferencePage.this.removeFilters();
            }
        });
        this.m_removeFilterButton.setEnabled(false);
        Label separator = new Label(buttonContainer, 0);
        separator.setVisible(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        this.m_selectAllButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage__Select_All_1, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Selects_all_step_filters_2, null);
        this.m_selectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VjetStepFilterPreferencePage.this.m_tableViewer.setAllChecked(true);
            }
        });
        this.m_deselectAllButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Deselect_All_3, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Deselects_all_step_filters_4, null);
        this.m_deselectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VjetStepFilterPreferencePage.this.m_tableViewer.setAllChecked(false);
            }
        });
    }

    protected void addNewFilter() {
        Filter newFilter = CreateStepFilterDialog.showCreateStepFilterDialog((Shell)this.getShell(), (Filter[])this.getAllFiltersFromTable());
        this.addFilter(newFilter);
    }

    protected void addPackage() {
        IScriptFolder selectedPackage = this.selectPackage();
        if (selectedPackage == null) {
            return;
        }
        String filterString = this.getPackageFilterString(selectedPackage);
        this.addFilter(filterString, true, 4096);
    }

    private String getPackageFilterString(IScriptFolder pack) {
        return String.valueOf(pack.getPath().removeFirstSegments(this.getProjectFragement(pack).getPath().segmentCount()).toPortableString().replace('/', '.')) + ".*";
    }

    private IProjectFragment getProjectFragement(IScriptFolder pack) {
        IModelElement e;
        while (3 != (e = pack.getParent()).getElementType()) {
        }
        return (IProjectFragment)e;
    }

    protected IScriptFolder selectPackage() {
        Object[] packages = this.getAllPacakges();
        if (packages == null) {
            packages = new IScriptFolder[]{};
        }
        ModelElementLabelProvider labelProvider = new ModelElementLabelProvider(ModelElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setIgnoreCase(false);
        dialog.setTitle("Package Selection");
        dialog.setMessage("&Choose a folder:");
        dialog.setElements(packages);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            return (IScriptFolder)dialog.getFirstResult();
        }
        return null;
    }

    protected void addType() {
        IType type = this.selectType();
        if (type == null) {
            return;
        }
        try {
            this.addFilter(type.getTypeQualifiedName("."), true, type.getFlags());
        }
        catch (ModelException e) {
            VjetDebugUIPlugin.error(e.getLocalizedMessage(), e);
        }
    }

    protected IType selectType() {
        VjoTypeSelectionDialog dialog = new VjoTypeSelectionDialog(this.getShell(), true, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), this.getSearchScope(), 0, this.getUILanguageToolkit());
        dialog.setTitle(this.getTypeDialogTitle());
        dialog.setMessage(this.getTypeDialogMessage());
        int result = dialog.open();
        if (result != 0) {
            return null;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IType type = null;
            type = (IType)types[0];
            return type;
        }
        return null;
    }

    protected IDLTKSearchScope getSearchScope() {
        return null;
    }

    protected String getTypeDialogTitle() {
        return VjetDebugPrefMessages.VjetStepFilterPreferencePage_typeDialog_title;
    }

    protected IDLTKUILanguageToolkit getUILanguageToolkit() {
        return DLTKUILanguageManager.getLanguageToolkit((String)this.m_toolkit.getNatureId());
    }

    protected String getTypeDialogMessage() {
        return VjetDebugPrefMessages.VjetStepFilterPreferencePage_typeDialog_message;
    }

    private IScriptFolder[] getAllPacakges() {
        IScriptModel model = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        final ArrayList folderList = new ArrayList();
        try {
            model.accept(new IModelElementVisitor(){
                List<String> nameList = new ArrayList<String>();

                public boolean visit(IModelElement element) {
                    if (element.getElementType() == 2) {
                        IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element);
                        if (!VjetStepFilterPreferencePage.this.m_toolkit.getNatureId().equals(languageToolkit.getNatureId())) {
                            return false;
                        }
                    }
                    if (element.getElementType() == 4 && !folderList.contains(element) && !this.nameList.contains(element.getElementName())) {
                        folderList.add((IScriptFolder)element);
                        this.nameList.add(element.getElementName());
                    }
                    return element.getElementType() != 7;
                }
            });
        }
        catch (ModelException e) {
            VjetDebugUIPlugin.error(e.getLocalizedMessage(), e);
        }
        return folderList.toArray(new IScriptFolder[0]);
    }

    protected void removeFilters() {
        this.m_tableViewer.remove(((IStructuredSelection)this.m_tableViewer.getSelection()).toArray());
    }

    public boolean performOk() {
        DebugUITools.setUseStepFilters((boolean)this.m_useStepFiltersButton.getSelection());
        IPreferenceStore store = this.getPreferenceStore();
        ArrayList<String> active = new ArrayList<String>();
        ArrayList<String> inactive = new ArrayList<String>();
        String name = "";
        Filter[] filters = this.getAllFiltersFromTable();
        int i = 0;
        while (i < filters.length) {
            name = filters[i].getName();
            String modifiers = "::" + Integer.toString(filters[i].getModifiers());
            if (filters[i].isChecked()) {
                active.add(String.valueOf(name) + modifiers);
            } else {
                inactive.add(String.valueOf(name) + modifiers);
            }
            ++i;
        }
        String pref = ScriptDebugOptionsManager.serializeList((String[])active.toArray(new String[active.size()]));
        store.setValue("org.eclipse.dltk.mod.debug.ui.preference_active_filters_list", pref);
        pref = ScriptDebugOptionsManager.serializeList((String[])inactive.toArray(new String[inactive.size()]));
        store.setValue("org.eclipse.dltk.mod.debug.ui.preference_inactive_filters_list", pref);
        return super.performOk();
    }

    protected void performDefaults() {
        boolean stepenabled = DebugUITools.isUseStepFilters();
        this.m_useStepFiltersButton.setSelection(stepenabled);
        this.setPageEnablement(stepenabled);
        this.m_tableViewer.getTable().removeAll();
        this.initTableState(true);
        super.performDefaults();
    }

    protected void addFilter(String filter, boolean checked, int modifiers) {
        if (filter != null) {
            Filter f = new Filter(filter, checked, modifiers);
            this.addFilter(f);
        }
    }

    protected void addFilter(Filter filter) {
        if (filter != null) {
            Filter[] allFiltersFromTable = this.getAllFiltersFromTable();
            int i = 0;
            while (i < allFiltersFromTable.length) {
                if (filter.equals((Object)allFiltersFromTable[i])) {
                    return;
                }
                ++i;
            }
            this.m_tableViewer.add((Object)filter);
            this.m_tableViewer.setChecked((Object)filter, filter.isChecked());
        }
    }

    protected Filter[] getAllFiltersFromTable() {
        TableItem[] items = this.m_tableViewer.getTable().getItems();
        Filter[] filters = new Filter[items.length];
        int i = 0;
        while (i < items.length) {
            filters[i] = (Filter)items[i].getData();
            filters[i].setChecked(items[i].getChecked());
            ++i;
        }
        return filters;
    }

    protected Filter[] getAllStoredFilters(boolean defaults) {
        String[] split;
        String[] inactivefilters;
        String[] activefilters;
        Filter[] filters = null;
        IPreferenceStore store = this.getPreferenceStore();
        if (defaults) {
            activefilters = ScriptDebugOptionsManager.parseList((String)store.getDefaultString("org.eclipse.dltk.mod.debug.ui.preference_active_filters_list"));
            inactivefilters = ScriptDebugOptionsManager.parseList((String)store.getDefaultString("org.eclipse.dltk.mod.debug.ui.preference_inactive_filters_list"));
        } else {
            activefilters = ScriptDebugOptionsManager.parseList((String)store.getString("org.eclipse.dltk.mod.debug.ui.preference_active_filters_list"));
            inactivefilters = ScriptDebugOptionsManager.parseList((String)store.getString("org.eclipse.dltk.mod.debug.ui.preference_inactive_filters_list"));
        }
        filters = new Filter[activefilters.length + inactivefilters.length];
        int i = 0;
        while (i < activefilters.length) {
            split = activefilters[i].split("::");
            filters[i] = split.length == 1 ? new Filter(split[0], true, 0) : new Filter(split[0], true, new Integer(split[1]).intValue());
            ++i;
        }
        i = 0;
        while (i < inactivefilters.length) {
            split = inactivefilters[i].split("::");
            filters[i + activefilters.length] = split.length == 1 ? new Filter(split[0], false, 0) : new Filter(split[0], false, new Integer(split[1]).intValue());
            ++i;
        }
        return filters;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.m_toolkit = DLTKExecuteExtensionHelper.getLanguageToolkit((IConfigurationElement)config, (String)propertyName, (Object)data);
        this.setPreferenceStore(VjetDebugUIPlugin.getDefault().getPreferenceStore());
    }

    class StepFilterContentProvider
    implements IStructuredContentProvider {
        public StepFilterContentProvider() {
            VjetStepFilterPreferencePage.this.initTableState(false);
        }

        public Object[] getElements(Object inputElement) {
            return VjetStepFilterPreferencePage.this.getAllFiltersFromTable();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

