/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.spyglass;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.context.BaseSubCtx;
import org.eclipse.vjet.dsf.common.context.ContextHelper;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.spyglass.ShowDiagType;
import org.eclipse.vjet.dsf.dom.DNode;

public class SpyGlassCtx
extends BaseSubCtx {
    private boolean m_isRunOnServer = true;
    private boolean m_needComponentViewerCSS;
    private boolean m_needHtmlViewerCSS;
    private boolean m_replaceOutput;
    private String m_content4Output;
    private String m_calLog = null;
    private final Map<String, ArrayList<DNode>> m_customerTitledDiags = new HashMap<String, ArrayList<DNode>>();
    private final Map<ShowDiagType, ArrayList<DNode>> m_diagnostics = new HashMap<ShowDiagType, ArrayList<DNode>>();
    private boolean m_hasDiagnostics = false;
    private boolean m_isShowDiag = false;

    public static SpyGlassCtx ctx() {
        SpyGlassCtx context = CtxAssociator.getCtx();
        if (context == null) {
            context = new SpyGlassCtx();
            SpyGlassCtx.setCtx(context);
        }
        return context;
    }

    public static void setCtx(SpyGlassCtx context) {
        CtxAssociator.setCtx(context);
    }

    private SpyGlassCtx() {
    }

    public boolean isNeedHtmlViewerCSS() {
        return this.m_needHtmlViewerCSS;
    }

    public void setNeedHtmlViewerCSS(boolean needHtmlViewerCSS) {
        this.m_needHtmlViewerCSS = needHtmlViewerCSS;
    }

    public boolean isNeedComponentViewerCSS() {
        return this.m_needComponentViewerCSS;
    }

    public void setNeedComponentViewerCSS(boolean needComponentViewerCSS) {
        this.m_needComponentViewerCSS = needComponentViewerCSS;
    }

    public String getContent4Output() {
        return this.m_content4Output;
    }

    public void setContent4Output(String output) {
        this.m_content4Output = output;
    }

    public boolean isReplaceOutput() {
        return this.m_replaceOutput;
    }

    public void setReplaceOutput(boolean output) {
        this.m_replaceOutput = output;
    }

    public boolean isRunOnServer() {
        return this.m_isRunOnServer;
    }

    public void setRunOnServer(boolean runOnServer) {
        this.m_isRunOnServer = runOnServer;
    }

    public void reset() {
        this.m_isShowDiag = false;
        this.clearAllDiagnostic();
    }

    public void addCustomerTitledDiagnostic(String title, DNode diag) {
        if (!this.m_isShowDiag || title == null || diag == null) {
            return;
        }
        ArrayList<DNode> nodes = this.m_customerTitledDiags.get(title);
        if (nodes == null) {
            nodes = new ArrayList(1);
        }
        nodes.add(diag);
        this.m_customerTitledDiags.put(title, nodes);
        this.m_hasDiagnostics = true;
    }

    public void addDiagnostic(ShowDiagType type, DNode diag) {
        if (!this.m_isShowDiag || type == null || diag == null) {
            return;
        }
        ArrayList<DNode> nodes = this.m_diagnostics.get((Object)type);
        if (nodes == null) {
            nodes = new ArrayList(2);
        }
        nodes.add(diag);
        this.m_diagnostics.put(type, nodes);
        this.m_hasDiagnostics = true;
    }

    public void clearAllDiagnostic() {
        this.m_hasDiagnostics = false;
        this.m_diagnostics.clear();
        this.m_customerTitledDiags.clear();
    }

    public void clearCustomerTitledDiagnostic(String Title) {
        if (this.m_customerTitledDiags == null || this.m_customerTitledDiags.isEmpty()) {
            this.m_hasDiagnostics = false;
            return;
        }
        if (this.m_customerTitledDiags.get(Title) == null) {
            return;
        }
        this.m_customerTitledDiags.remove(Title);
        this.confirmHasDiagnostics();
    }

    public void clearDiagnostic(ShowDiagType type) {
        if (this.m_diagnostics == null || this.m_diagnostics.isEmpty()) {
            this.m_hasDiagnostics = false;
            return;
        }
        if (this.m_diagnostics.get((Object)type) == null) {
            return;
        }
        this.m_diagnostics.remove((Object)type);
        this.confirmHasDiagnostics();
    }

    private void confirmHasDiagnostics() {
        this.m_hasDiagnostics = !this.m_diagnostics.isEmpty() || !this.m_customerTitledDiags.isEmpty();
    }

    public String getCalLogUrl() {
        return this.m_calLog;
    }

    public Map<String, ArrayList<DNode>> getCustomerTitledDiagnostics() {
        return this.m_customerTitledDiags;
    }

    public Map<ShowDiagType, ArrayList<DNode>> getDiagnostics() {
        return this.m_diagnostics;
    }

    public ArrayList<DNode> getDiagnostics(ShowDiagType type) {
        if (this.m_diagnostics == null || type == null) {
            return null;
        }
        return this.m_diagnostics.get((Object)type);
    }

    public boolean hasDiagnostics() {
        return this.m_hasDiagnostics;
    }

    public boolean isShowDiag() {
        return this.m_isShowDiag;
    }

    public void setCalLogUrl(String calLogUrl) {
        this.m_calLog = calLogUrl;
    }

    public void setShowDiag(boolean isShowDiag) {
        this.m_isShowDiag = isShowDiag;
    }

    private static class CtxAssociator
    extends ContextHelper {
        private static final String CTX_NAME = SpyGlassCtx.class.getSimpleName();

        private CtxAssociator() {
        }

        protected static SpyGlassCtx getCtx() {
            return (SpyGlassCtx)CtxAssociator.getSubCtx(DsfCtx.ctx(), CTX_NAME);
        }

        protected static void setCtx(SpyGlassCtx ctx) {
            CtxAssociator.setSubCtx(DsfCtx.ctx(), CTX_NAME, ctx);
        }
    }
}

