/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace;

import org.eclipse.vjet.dsf.common.context.BaseSubCtx;
import org.eclipse.vjet.dsf.common.context.ContextHelper;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.trace.ContentTracker;
import org.eclipse.vjet.dsf.common.trace.DefaultTracer;
import org.eclipse.vjet.dsf.common.trace.IDsfInstrumenter;
import org.eclipse.vjet.dsf.common.trace.IDsfTracer;
import org.eclipse.vjet.dsf.common.tracer.ITracer;
import org.eclipse.vjet.dsf.common.tracer.TraceManager;

public class TraceCtx
extends BaseSubCtx {
    private IDsfTracer m_tracer;
    private IDsfInstrumenter m_instrumenter;
    private ContentTracker m_contentTracker;
    private TraceManager m_traceManager;

    public static TraceCtx ctx() {
        TraceCtx context = CtxAssociator.getCtx();
        if (context == null) {
            context = new TraceCtx();
            TraceCtx.setCtx(context);
        }
        return context;
    }

    public static void setCtx(TraceCtx context) {
        CtxAssociator.setCtx(context);
    }

    public void reset() {
        if (this.m_tracer != null) {
            this.m_tracer.reset();
        }
        this.m_traceManager = null;
        this.resetInstrumenter();
        this.resetContentTracker();
    }

    public void setTracer(IDsfTracer tracer) {
        if (tracer == null) {
            throw new DsfRuntimeException("tracer is null");
        }
        this.m_tracer = tracer;
    }

    public IDsfTracer getTracer() {
        if (this.m_tracer == null) {
            this.m_tracer = new DefaultTracer();
        }
        return this.m_tracer;
    }

    public TraceManager getTraceManager() {
        if (this.m_traceManager == null) {
            this.m_traceManager = new TraceManager();
        }
        return this.m_traceManager;
    }

    public ITracer getTracer(String scope) {
        return this.getTraceManager().getTracer(scope);
    }

    public ITracer getTracer(Class callingClass) {
        return this.getTraceManager().getTracer(callingClass);
    }

    public IDsfInstrumenter getInstrumenter() {
        return this.m_instrumenter;
    }

    public void setInstrumenter(IDsfInstrumenter instrumenter) {
        if (instrumenter == null) {
            throw new DsfRuntimeException("instrumenter is nulll");
        }
        this.m_instrumenter = instrumenter;
    }

    public boolean haveInstrumenter() {
        return this.m_instrumenter != null;
    }

    public boolean haveContentTracker() {
        return this.m_contentTracker != null;
    }

    public ContentTracker getContentTracker() {
        return this.m_contentTracker;
    }

    public void setContentTracker(ContentTracker contentTracker) {
        if (contentTracker == null) {
            throw new DsfRuntimeException("contentTracker is nulll");
        }
        this.m_contentTracker = contentTracker;
    }

    public void resetContentTracker() {
        if (this.m_contentTracker != null) {
            this.m_contentTracker = null;
        }
    }

    public void resetInstrumenter() {
        if (this.m_instrumenter != null) {
            this.m_instrumenter.resetInstrumenter();
            this.m_instrumenter = null;
        }
    }

    private static class CtxAssociator
    extends ContextHelper {
        private static final String CTX_NAME = TraceCtx.class.getSimpleName();

        private CtxAssociator() {
        }

        protected static TraceCtx getCtx() {
            return (TraceCtx)CtxAssociator.getSubCtx(DsfCtx.ctx(), CTX_NAME);
        }

        protected static void setCtx(TraceCtx ctx) {
            CtxAssociator.setSubCtx(DsfCtx.ctx(), CTX_NAME, ctx);
        }
    }
}

