/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.tracer;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.config.FilterKey;
import org.eclipse.vjet.dsf.common.trace.config.HandlerKey;
import org.eclipse.vjet.dsf.common.trace.config.IntrospectorKey;
import org.eclipse.vjet.dsf.common.trace.config.ListenerKey;
import org.eclipse.vjet.dsf.common.trace.filter.FilterId;
import org.eclipse.vjet.dsf.common.trace.filter.ITraceEventFilter;
import org.eclipse.vjet.dsf.common.trace.handler.HandlerId;
import org.eclipse.vjet.dsf.common.trace.handler.ITraceEventHandler;
import org.eclipse.vjet.dsf.common.trace.handler.TraceFileHandler;
import org.eclipse.vjet.dsf.common.trace.introspect.ITraceObjectIntrospector;
import org.eclipse.vjet.dsf.common.trace.listener.ITraceEventListener;
import org.eclipse.vjet.dsf.common.trace.listener.ListenerId;
import org.eclipse.vjet.dsf.common.tracer.TraceManager;

public class Factory {
    private static final String FILE_PREFIX = "v4trace";
    private static final String FILE_EXTENSION = ".xml";
    private static final int FILE_MAX_SIZE = 10000000;
    private static final int FILE_MAX_COUT = 10;
    private static List<String> s_initializedLoggers = new ArrayList<String>(5);

    public static ITraceEventListener createListener(ListenerKey key) {
        if (key == null) {
            DsfExceptionHelper.chuck((String)"key is null");
        }
        Class type = key.getType();
        ITraceEventListener listener = null;
        Constructor c = null;
        try {
            c = type.getConstructor(ListenerId.class);
        }
        catch (SecurityException securityException) {
            DsfExceptionHelper.chuck((String)("SecurityException when getting constructor for: " + type.getName()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            DsfExceptionHelper.chuck((String)("NoSuchMethodException when getting constructor for: " + type.getName()));
        }
        try {
            listener = (ITraceEventListener)c.newInstance(key.getId());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DsfExceptionHelper.chuck((String)("IllegalArgumentException when instantiate: " + type.getName()));
        }
        catch (InstantiationException instantiationException) {
            DsfExceptionHelper.chuck((String)("InstantiationException when instantiate: " + type.getName()));
        }
        catch (IllegalAccessException illegalAccessException) {
            DsfExceptionHelper.chuck((String)("IllegalAccessException when instantiate: " + type.getName()));
        }
        catch (InvocationTargetException invocationTargetException) {
            DsfExceptionHelper.chuck((String)("InvocationTargetException when instantiate: " + type.getName()));
        }
        return listener;
    }

    public static ITraceEventFilter createFilter(FilterKey key) {
        if (key == null) {
            DsfExceptionHelper.chuck((String)"key is null");
        }
        Class type = key.getType();
        ITraceEventFilter filter = null;
        Constructor c = null;
        try {
            c = type.getConstructor(FilterId.class);
        }
        catch (SecurityException securityException) {
            DsfExceptionHelper.chuck((String)("SecurityException when getting constructor for: " + type.getName()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            DsfExceptionHelper.chuck((String)("NoSuchMethodException when getting constructor for: " + type.getName()));
        }
        try {
            filter = (ITraceEventFilter)c.newInstance(key.getId());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DsfExceptionHelper.chuck((String)("IllegalArgumentException when instantiate: " + type.getName()));
        }
        catch (InstantiationException instantiationException) {
            DsfExceptionHelper.chuck((String)("InstantiationException when instantiate: " + type.getName()));
        }
        catch (IllegalAccessException illegalAccessException) {
            DsfExceptionHelper.chuck((String)("IllegalAccessException when instantiate: " + type.getName()));
        }
        catch (InvocationTargetException invocationTargetException) {
            DsfExceptionHelper.chuck((String)("InvocationTargetException when instantiate: " + type.getName()));
        }
        return filter;
    }

    public static ITraceEventHandler createHandler(HandlerKey key) {
        if (key == null) {
            DsfExceptionHelper.chuck((String)"key is null");
        }
        Class type = key.getType();
        ITraceEventHandler handler = null;
        Constructor c = null;
        try {
            c = type.getConstructor(HandlerId.class);
        }
        catch (SecurityException securityException) {
            DsfExceptionHelper.chuck((String)("SecurityException when getting constructor for: " + type.getName()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            DsfExceptionHelper.chuck((String)("NoSuchMethodException when getting constructor for: " + type.getName()));
        }
        try {
            handler = (ITraceEventHandler)c.newInstance(key.getId());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DsfExceptionHelper.chuck((String)("IllegalArgumentException when instantiate: " + type.getName()));
        }
        catch (InstantiationException instantiationException) {
            DsfExceptionHelper.chuck((String)("InstantiationException when instantiate: " + type.getName()));
        }
        catch (IllegalAccessException illegalAccessException) {
            DsfExceptionHelper.chuck((String)("IllegalAccessException when instantiate: " + type.getName()));
        }
        catch (InvocationTargetException invocationTargetException) {
            DsfExceptionHelper.chuck((String)("InvocationTargetException when instantiate: " + type.getName()));
        }
        return handler;
    }

    public static ITraceObjectIntrospector createInspector(IntrospectorKey key) {
        if (key == null) {
            DsfExceptionHelper.chuck((String)"key is null");
        }
        Class type = key.getType();
        ITraceObjectIntrospector inspector = null;
        try {
            inspector = (ITraceObjectIntrospector)type.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            DsfExceptionHelper.chuck((String)("IllegalAccessException when instantiate: " + type.getName()));
        }
        catch (InstantiationException instantiationException) {
            DsfExceptionHelper.chuck((String)("InstantiationException when instantiate: " + type.getName()));
        }
        return inspector;
    }

    public static Logger createDefaultLogger(String scope, Formatter formatter) {
        return Factory.createDefaultLogger(scope, formatter, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger createDefaultLogger(String scope, Formatter formatter, int maxFileCount) {
        String fileName = "v4trace.xml";
        Logger logger = Logger.getLogger(scope);
        Class<Factory> clazz = Factory.class;
        synchronized (Factory.class) {
            if (s_initializedLoggers.contains(scope)) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return logger;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            logger.setLevel(Level.INFO);
            Handler[] handlerArray = logger.getHandlers();
            int n = handlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Handler h = handlerArray[n2];
                if (h instanceof ConsoleHandler) {
                    logger.removeHandler(h);
                }
                ++n2;
            }
            try {
                TraceFileHandler fileHandler = new TraceFileHandler(fileName, 10000000, maxFileCount, true);
                fileHandler.setFormatter(formatter);
                fileHandler.setLevel(Level.ALL);
                fileHandler.setFilter(new TraceFilter());
                logger.addHandler((Handler)fileHandler);
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {}
            clazz = Factory.class;
            synchronized (Factory.class) {
                s_initializedLoggers.add(scope);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return logger;
            }
        }
    }

    static class TraceFilter
    implements Filter {
        TraceFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            return TraceManager.class.getName().equals(record.getLoggerName());
        }
    }
}

