/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DEntityReference;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DRawString;
import org.eclipse.vjet.dsf.dom.util.TextChildOperationUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Entity;

public class DEntity
extends DNode
implements Entity {
    private static final long serialVersionUID = 4066512827364288302L;
    private boolean m_parameterEntity = false;
    private String m_publicId;
    private String m_systemId;
    private String m_notationName;
    private String m_xmlEncoding;
    private String m_inputEncoding;
    private String m_xmlVersion;

    public DEntity(DDocument doc, String name) {
        super(doc, name);
    }

    public DEntity(DDocument doc, String name, String rawStringValue) {
        this(doc, name);
        this.add(new DRawString(rawStringValue));
    }

    @Override
    public final short getNodeType() {
        return 6;
    }

    @Override
    public DEntity add(DNode node) {
        super.add(node);
        return this;
    }

    @Override
    public String getPublicId() {
        return this.m_publicId;
    }

    @Override
    public String getSystemId() {
        return this.m_systemId;
    }

    @Override
    public String getNotationName() {
        return this.m_notationName;
    }

    @Override
    public String getInputEncoding() {
        return this.m_inputEncoding;
    }

    @Override
    public String getXmlEncoding() {
        return this.m_xmlEncoding;
    }

    @Override
    public String getXmlVersion() {
        return this.m_xmlVersion;
    }

    public DEntity setDsfNotationName(String name) {
        this.setNotationName(name);
        return this;
    }

    public void setNotationName(String name) {
        this.m_notationName = name;
    }

    public DEntity setDsfPublicId(String id) {
        this.setPublicId(id);
        return this;
    }

    public void setPublicId(String id) {
        this.m_publicId = id;
    }

    public DEntity setDsfSystemId(String id) {
        this.setSystemId(id);
        return this;
    }

    public void setSystemId(String id) {
        this.m_systemId = id;
    }

    public DEntity setDsfXmlVersion(String xmlVersion) throws DOMException {
        this.setXmlVersion(xmlVersion);
        return this;
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        if (xmlVersion == null || DDocument.XML_VERSIONS.indexOf(xmlVersion) == -1) {
            throw new DOMException(9, "unknown xml version " + xmlVersion);
        }
        this.m_xmlVersion = xmlVersion;
    }

    public DEntity setDsfXmlEncoding(String value) {
        this.setXmlEncoding(value);
        return this;
    }

    public void setXmlEncoding(String value) {
        if (value == null || DDocument.ENCODEINGS.indexOf(value.toLowerCase()) == -1) {
            throw new DOMException(9, "unsupported XmlEncoding " + value);
        }
        this.m_xmlEncoding = value;
    }

    public DEntity setDsfInputEncoding(String value) {
        this.setInputEncoding(value);
        return this;
    }

    public void setInputEncoding(String value) {
        if (value == null || DDocument.ENCODEINGS.indexOf(value.toLowerCase()) == -1) {
            throw new DOMException(9, "unsupported InputEncoding " + value);
        }
        this.m_inputEncoding = value;
    }

    public boolean isParameterEntity() {
        return this.m_parameterEntity;
    }

    public DEntity setDsfParameterEntry(boolean value) {
        this.setParameterEntry(value);
        return this;
    }

    public void setParameterEntry(boolean value) {
        this.m_parameterEntity = value;
    }

    public DEntityReference getRef() {
        if (this.getOwnerDocument() == null) {
            throw new DsfRuntimeException("Cannot get an entity reference because this instance does not have a document yet.");
        }
        return new DEntityReference(this.getDsfOwnerDocument(), this.getNodeName());
    }

    @Override
    public DEntity jif(String jif) {
        super.jif(jif);
        return this;
    }

    @Override
    public String toString() {
        StringWriter out = new StringWriter(100);
        this.write(out);
        return out.toString();
    }

    public void write(Writer out) {
        String entityNodeName = this.getNodeName();
        String entityPublicId = this.getPublicId();
        String entitySystemId = this.getSystemId();
        String entityNotationName = this.getNotationName();
        boolean entityHasPublic = false;
        try {
            out.write("<!ENTITY ");
            if (this.isParameterEntity()) {
                out.write("% ");
            }
            if (entityNodeName != null) {
                out.write(entityNodeName);
            }
            if (entityPublicId != null) {
                out.write(" PUBLIC \"");
                out.write(entityPublicId);
                out.write("\"");
                entityHasPublic = true;
            }
            if (entitySystemId != null) {
                if (!entityHasPublic) {
                    out.write(" SYSTEM");
                }
                out.write(" \"");
                out.write(entitySystemId);
                out.write("\"");
            }
            if (this.hasChildNodes()) {
                String textValue = TextChildOperationUtil.getTextValue(this);
                out.write(" '");
                out.write(textValue);
                out.write(39);
            }
            if (entityNotationName != null) {
                out.write(" ");
                out.write(entityNotationName);
            }
            out.write(">");
        }
        catch (IOException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }
}

