/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import org.eclipse.vjet.dsf.common.resource.ResourceUtil;
import org.eclipse.vjet.dsf.js.dbgp.Base64Helper;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugFrame;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugger;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.NativeArray;
import org.mozilla.mod.javascript.NativeFunction;
import org.mozilla.mod.javascript.NativeJavaArray;
import org.mozilla.mod.javascript.NativeJavaClass;
import org.mozilla.mod.javascript.NativeJavaObject;
import org.mozilla.mod.javascript.NativeObject;

final class EvalCommand
extends DBGPDebugger.Command {
    private final DBGPDebugger m_debugger;
    public static final String DETAIL_EVAL_TYPE = "com.ebay.vjo.runner.DescriptUtils";
    public static final String DETAIL_EVAL_FUN = "com.ebay.vjo.runner.DescriptUtils.detail";

    EvalCommand(DBGPDebugger debugger) {
        this.m_debugger = debugger;
    }

    @Override
    void parseAndExecute(String command, Map<String, String> options) {
        Object tempEvaluated;
        String value = Base64Helper.decodeString(options.get("--"));
        if (value.length() == 0) {
            value = "this";
        }
        StringBuffer valueBuffer = new StringBuffer();
        int depth = 1;
        if (options.containsKey("-d")) {
            depth = Integer.parseInt(options.get("-d"));
        }
        if (this.m_debugger.m_stackmanager.getStackDepth() == 0 || value == null) {
            this.m_debugger.printProperty("", "", "", valueBuffer, 0, true);
            this.m_debugger.printResponse("<response command=\"eval\"\r\n transaction_id=\"" + options.get("-i") + "\" depth=\"" + depth + "\" success=\"1\" " + ">\r\n" + valueBuffer + "</response>\r\n");
            return;
        }
        DBGPDebugFrame fr = this.m_debugger.m_stackmanager.getStackFrame(depth);
        Object evaluated = fr.eval(value);
        boolean needReevaluate = false;
        if (evaluated instanceof Function || evaluated instanceof NativeObject || evaluated instanceof NativeArray || evaluated instanceof NativeFunction || evaluated instanceof NativeJavaClass || evaluated instanceof NativeJavaClass || evaluated instanceof NativeJavaArray) {
            needReevaluate = true;
        } else if (evaluated instanceof NativeJavaObject) {
            if (((NativeJavaObject)evaluated).unwrap() instanceof String) {
                evaluated = ((NativeJavaObject)evaluated).getDefaultValue(String.class);
            } else {
                needReevaluate = true;
            }
        }
        if (needReevaluate && this.existDescripUtils(fr) && !"".equals(tempEvaluated = fr.eval("com.ebay.vjo.runner.DescriptUtils.detail(" + value + ")"))) {
            evaluated = tempEvaluated;
        }
        this.m_debugger.printProperty("", "", evaluated, valueBuffer, 0, true);
        this.m_debugger.printResponse("<response command=\"eval\"\r\n transaction_id=\"" + options.get("-i") + "\" depth=\"" + depth + "\" success=\"1\" " + ">\r\n" + valueBuffer + "</response>\r\n");
    }

    private boolean existDescripUtils(DBGPDebugFrame fr) {
        Object desc = fr.eval(DETAIL_EVAL_FUN);
        if (desc instanceof Function) {
            return true;
        }
        return this.loadDescriptUtil(fr);
    }

    private boolean loadDescriptUtil(DBGPDebugFrame fr) {
        URL sourceUrl = null;
        try {
            sourceUrl = JavaSourceLocator.getInstance().getSourceUrl(DETAIL_EVAL_TYPE, ".js");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (sourceUrl == null) {
            String path = String.valueOf(DETAIL_EVAL_TYPE.replace(".", "/")) + ".js";
            int index = path.lastIndexOf("/");
            String resourceName = path;
            String relDir = "";
            if (index > 0) {
                relDir = path.substring(0, index);
                resourceName = path.substring(index + 1);
            }
            try {
                sourceUrl = ResourceUtil.getResource((String)relDir, (String)resourceName);
            }
            catch (IOException iOException) {}
        }
        if (sourceUrl != null) {
            try {
                fr.eval(new InputStreamReader(sourceUrl.openStream(), "UTF-8"));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }
}

