/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdebugger.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import org.eclipse.vjet.dsf.jsdebugger.gui.EvalTextArea;
import org.eclipse.vjet.dsf.jsdebugger.gui.Evaluator;
import org.eclipse.vjet.dsf.jsdebugger.gui.MyTreeTable;
import org.eclipse.vjet.dsf.jsdebugger.gui.SimpleTableModel;
import org.eclipse.vjet.dsf.jsdebugger.gui.SwingGui;
import org.eclipse.vjet.dsf.jsdebugger.gui.VariableDataModel;
import org.eclipse.vjet.dsf.jsdi.ISession;
import org.eclipse.vjet.dsf.jsdi.IValue;
import org.eclipse.vjet.dsf.jsdi.IVariable;
import org.eclipse.vjet.dsf.jsdi.StackFrameInfo;
import org.eclipse.vjet.dsf.jsdi.Value;
import org.eclipse.vjet.dsf.jsdi.Variable;
import org.eclipse.vjet.dsf.jsdi.VariableType;

class ContextWindow
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 2306040975490228051L;
    private SwingGui m_debugGui;
    JComboBox m_context;
    Vector<String> m_toolTips;
    private JTabbedPane m_tabs;
    private JTabbedPane m_tabs2;
    private MyTreeTable m_thisTable;
    private MyTreeTable m_localsTable;
    private SimpleTableModel m_watchTableModel;
    private Evaluator m_evaluator;
    private EvalTextArea m_cmdLine;
    JSplitPane m_split;
    private boolean m_enabled;

    public ContextWindow(final SwingGui debugGui) {
        this.m_debugGui = debugGui;
        this.m_enabled = false;
        JPanel left = new JPanel();
        JToolBar t1 = new JToolBar();
        t1.setName("Variables");
        t1.setLayout(new GridLayout());
        t1.add(left);
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout());
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout());
        p1.add(t1);
        JLabel label = new JLabel("Context:");
        this.m_context = new JComboBox();
        this.m_context.setLightWeightPopupEnabled(false);
        this.m_toolTips = new Vector();
        label.setBorder(this.m_context.getBorder());
        this.m_context.addActionListener(this);
        this.m_context.setActionCommand("ContextSwitch");
        GridBagLayout layout = new GridBagLayout();
        left.setLayout(layout);
        GridBagConstraints lc = new GridBagConstraints();
        lc.insets.left = 5;
        lc.anchor = 17;
        lc.ipadx = 5;
        layout.setConstraints(label, lc);
        left.add(label);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.anchor = 17;
        layout.setConstraints(this.m_context, c);
        left.add(this.m_context);
        this.m_tabs = new JTabbedPane(3);
        this.m_tabs.setPreferredSize(new Dimension(500, 300));
        this.m_thisTable = new MyTreeTable(new VariableDataModel());
        JScrollPane jsp = new JScrollPane(this.m_thisTable);
        jsp.getViewport().setViewSize(new Dimension(5, 2));
        this.m_tabs.add("this", jsp);
        this.m_localsTable = new MyTreeTable(new VariableDataModel());
        this.m_localsTable.setAutoResizeMode(4);
        this.m_localsTable.setPreferredSize(null);
        jsp = new JScrollPane(this.m_localsTable);
        this.m_tabs.add("Locals", jsp);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridheight = 0;
        c.fill = 1;
        c.anchor = 17;
        layout.setConstraints(this.m_tabs, c);
        left.add(this.m_tabs);
        this.m_evaluator = new Evaluator(debugGui);
        this.m_cmdLine = new EvalTextArea(debugGui);
        this.m_watchTableModel = this.m_evaluator.tableModel;
        jsp = new JScrollPane(this.m_evaluator);
        JToolBar t2 = new JToolBar();
        t2.setName("Evaluate");
        this.m_tabs2 = new JTabbedPane(3);
        this.m_tabs2.add("Watch", jsp);
        this.m_tabs2.add("Evaluate", new JScrollPane(this.m_cmdLine));
        this.m_tabs2.setPreferredSize(new Dimension(500, 300));
        t2.setLayout(new GridLayout());
        t2.add(this.m_tabs2);
        p2.add(t2);
        this.m_evaluator.setAutoResizeMode(4);
        this.m_split = new JSplitPane(1, p1, p2);
        this.m_split.setOneTouchExpandable(true);
        SwingGui.setResizeWeight(this.m_split, 0.5);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_split, "Center");
        final JToolBar finalT1 = t1;
        final JToolBar finalT2 = t2;
        final JPanel finalP1 = p1;
        final JPanel finalP2 = p2;
        final JSplitPane finalSplit = this.m_split;
        final ContextWindow finalThis = this;
        ComponentListener clistener = new ComponentListener(){
            boolean t2Docked = true;

            void check(Component comp) {
                JFrame frame;
                Container thisParent = finalThis.getParent();
                if (thisParent == null) {
                    return;
                }
                Container parent = finalT1.getParent();
                boolean leftDocked = true;
                boolean rightDocked = true;
                boolean adjustVerticalSplit = false;
                if (parent != null) {
                    if (parent != finalP1) {
                        while (!(parent instanceof JFrame)) {
                            parent = parent.getParent();
                        }
                        frame = (JFrame)parent;
                        debugGui.addTopLevel("Variables", frame);
                        if (!frame.isResizable()) {
                            frame.setResizable(true);
                            frame.setDefaultCloseOperation(0);
                            final EventListener[] l = frame.getListeners(WindowListener.class);
                            frame.removeWindowListener((WindowListener)l[0]);
                            frame.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosing(WindowEvent e) {
                                    (this).ContextWindow.this.m_context.hidePopup();
                                    ((WindowListener)l[0]).windowClosing(e);
                                }
                            });
                        }
                        leftDocked = false;
                    } else {
                        leftDocked = true;
                    }
                }
                if ((parent = finalT2.getParent()) != null) {
                    if (parent != finalP2) {
                        while (!(parent instanceof JFrame)) {
                            parent = parent.getParent();
                        }
                        frame = (JFrame)parent;
                        debugGui.addTopLevel("Evaluate", frame);
                        frame.setResizable(true);
                        rightDocked = false;
                    } else {
                        rightDocked = true;
                    }
                }
                if (leftDocked && this.t2Docked && rightDocked && this.t2Docked) {
                    return;
                }
                this.t2Docked = rightDocked;
                JSplitPane split = (JSplitPane)thisParent;
                if (leftDocked) {
                    if (rightDocked) {
                        finalSplit.setDividerLocation(0.5);
                    } else {
                        finalSplit.setDividerLocation(1.0);
                    }
                    if (adjustVerticalSplit) {
                        split.setDividerLocation(0.66);
                    }
                } else if (rightDocked) {
                    finalSplit.setDividerLocation(0.0);
                    split.setDividerLocation(0.66);
                } else {
                    split.setDividerLocation(1.0);
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                this.check(e.getComponent());
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                this.check(e.getComponent());
            }

            @Override
            public void componentResized(ComponentEvent e) {
                this.check(e.getComponent());
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.check(e.getComponent());
            }
        };
        p1.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Container thisParent = finalThis.getParent();
                JSplitPane split = (JSplitPane)thisParent;
                if (e.getChild() == finalT1) {
                    if (finalT2.getParent() == finalP2) {
                        finalSplit.setDividerLocation(0.5);
                    } else {
                        finalSplit.setDividerLocation(1.0);
                    }
                    split.setDividerLocation(0.66);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Container thisParent = finalThis.getParent();
                JSplitPane split = (JSplitPane)thisParent;
                if (e.getChild() == finalT1) {
                    if (finalT2.getParent() == finalP2) {
                        finalSplit.setDividerLocation(0.0);
                        split.setDividerLocation(0.66);
                    } else {
                        split.setDividerLocation(1.0);
                    }
                }
            }
        });
        t1.addComponentListener(clistener);
        t2.addComponentListener(clistener);
        this.disable();
    }

    @Override
    public void disable() {
        this.m_context.setEnabled(false);
        this.m_thisTable.resetTree(new VariableDataModel());
        this.m_thisTable.setEnabled(false);
        this.m_localsTable.resetTree(new VariableDataModel());
        this.m_localsTable.setEnabled(false);
        this.m_evaluator.setEnabled(false);
        this.m_cmdLine.setEnabled(false);
    }

    @Override
    public void enable() {
        this.m_context.setEnabled(true);
        this.m_thisTable.setEnabled(true);
        this.m_localsTable.setEnabled(true);
        this.m_evaluator.setEnabled(true);
        this.m_cmdLine.setEnabled(true);
    }

    public void reset() {
        this.disable();
        this.m_watchTableModel.clear();
    }

    public void disableUpdate() {
        this.m_enabled = false;
    }

    public void enableUpdate() {
        this.m_enabled = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.m_enabled) {
            return;
        }
        if (e.getActionCommand().equals("ContextSwitch")) {
            try {
                int frameIndex = this.m_context.getSelectedIndex();
                this.m_context.setToolTipText(this.m_toolTips.elementAt(frameIndex).toString());
                int frameCount = this.m_debugGui.m_debuggerControl.getFrameCount();
                if (frameIndex >= frameCount) {
                    return;
                }
                this.m_debugGui.m_debuggerControl.contextSwitch(frameIndex);
                StackFrameInfo frame = this.m_debugGui.m_debuggerControl.getFrameInfo(frameIndex);
                this.m_thisTable.resetTree(new VariableDataModel((IVariable)new Variable("this", (IValue)new Value(VariableType.OBJECT, "this", (Object)-3L)), (ISession)this.m_debugGui.m_debuggerControl));
                VariableDataModel scopeModel = frame.hasDifferentScope() ? new VariableDataModel((IVariable)new Variable("scope", (IValue)new Value(VariableType.OBJECT, "scope", (Object)-2L)), (ISession)this.m_debugGui.m_debuggerControl) : new VariableDataModel();
                this.m_localsTable.resetTree(scopeModel);
                this.m_debugGui.showStopLine(frame.getSourceName(), frame.getLineNumber());
                this.m_watchTableModel.updateModel();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
    }
}

