/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace.handler;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.DataModelCtx;
import org.eclipse.vjet.dsf.common.trace.TraceCtx;
import org.eclipse.vjet.dsf.common.trace.event.TraceEvent;
import org.eclipse.vjet.dsf.common.trace.event.TraceType;
import org.eclipse.vjet.dsf.common.trace.handler.HandlerId;
import org.eclipse.vjet.dsf.common.trace.handler.ITraceEventHandler;
import org.eclipse.vjet.dsf.common.trace.introspect.DefaultTraceIntrospector;
import org.eclipse.vjet.dsf.common.trace.introspect.ITraceObjectIntrospector;
import org.eclipse.vjet.dsf.common.trace.introspect.JavaBeanTraceIntrospector;
import org.eclipse.vjet.dsf.common.tracer.TraceManager;
import org.eclipse.vjet.dsf.common.tracer.TraceUtil;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.common.xml.XmlEncoder;
import org.eclipse.vjet.dsf.common.xml.XmlStreamWriter;

public class DefaultTraceEventHandler
implements ITraceEventHandler {
    private HandlerId m_handlerId;
    private final Map<Class, ITraceObjectIntrospector> m_inspectors = new HashMap<Class, ITraceObjectIntrospector>(10);
    private XmlStreamWriter m_xmlWriter;
    private DefaultTraceIntrospector m_defaultIntrospector;
    private int m_traceDepth = -1;
    private ListOrderedMap m_stackLabels = new ListOrderedMap();
    private static final String DOT = ".";
    private boolean m_endElement = false;
    private boolean m_active = true;
    private static final String TAG_MSG = "Msg";
    private static final String TAG_LOOP = "Loop";
    private static final String TAG_CALL = "Call";
    private static final String ATTR_METHOD = "mtd";
    private static final String ATTR_OBJ = "obj";

    public DefaultTraceEventHandler(HandlerId handlerId) {
        this(handlerId, null);
        this.m_xmlWriter.writeStartElement("V4Trace");
        this.m_endElement = true;
    }

    public DefaultTraceEventHandler(HandlerId handlerId, XmlStreamWriter xmlWriter) {
        if (handlerId == null) {
            DsfExceptionHelper.chuck((String)"handlerId is null");
        }
        this.m_handlerId = handlerId;
        TraceManager traceMgr = TraceCtx.ctx().getTraceManager();
        this.m_xmlWriter = xmlWriter != null ? xmlWriter : new XmlStreamWriter(traceMgr.getDefaultWriter(), IIndenter.COMPACT);
        this.m_defaultIntrospector = traceMgr.getDefaultIntrospector();
        DataModelCtx ctx = DataModelCtx.getCtx();
        ctx.setWriter((IXmlStreamWriter)this.m_xmlWriter);
    }

    public HandlerId getId() {
        return this.m_handlerId;
    }

    public void handle(TraceEvent event) {
        TraceType type = event.getType();
        if (TraceType.ENTER_METHOD.equals(type)) {
            this.traceEnterMethod(event);
        } else if (TraceType.EXIT_METHOD.equals(type)) {
            this.traceExitMethod(event);
        } else if (TraceType.OBJECT_TYPE.equals(type)) {
            this.traceObjectType(event);
        } else if (TraceType.OBJECT_STATE.equals(type)) {
            this.traceObjectState(event);
        } else if (TraceType.DATAMODEL.equals(type)) {
            this.traceJavaBean(event);
        } else if (TraceType.NV.equals(type)) {
            this.traceNV(event);
        } else if (TraceType.MSG.equals(type)) {
            this.traceMsg(event);
        } else if (TraceType.START_LOOP.equals(type)) {
            this.traceStartLoop(event);
        } else if (TraceType.END_LOOP.equals(type)) {
            this.traceEndLoop(event);
        } else if (TraceType.START_CALL.equals(type)) {
            this.traceStartCall(event);
        } else if (TraceType.END_CALL.equals(type)) {
            this.traceEndCall(event);
        }
    }

    public synchronized void close() {
        if (!this.m_active) {
            return;
        }
        this.m_active = false;
        if (this.m_endElement) {
            this.m_xmlWriter.writeEndElement();
        }
        this.m_xmlWriter.flush();
    }

    protected XmlStreamWriter getWriter() {
        return this.m_xmlWriter;
    }

    private void traceEnterMethod(TraceEvent event) {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        Object caller = event.getSource();
        String clsName = TraceUtil.getClassName((Object)caller);
        String methodName = TraceUtil.getMethodName((Object)caller, (Throwable)t);
        this.push(String.valueOf(clsName) + DOT + methodName);
        this.m_xmlWriter.writeStartElement(clsName);
        this.m_xmlWriter.writeAttribute(ATTR_METHOD, methodName);
        Object[] args = event.getArgs();
        if (args == null || args.length == 0) {
            return;
        }
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.m_xmlWriter.writeAttribute("param", TraceUtil.getType((Object)obj));
            ++n2;
        }
    }

    private void traceExitMethod(TraceEvent event) {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        Object caller = event.getSource();
        String clsName = TraceUtil.getClassName((Object)caller);
        String methodName = TraceUtil.getMethodName((Object)caller, (Throwable)t);
        this.pop(String.valueOf(clsName) + DOT + methodName);
        this.m_xmlWriter.writeEndElement();
    }

    private void traceObjectType(TraceEvent event) {
        if (event.getArgs() == null || event.getArgs().length == 0) {
            return;
        }
        Object[] objectArray = event.getArgs();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.m_xmlWriter.writeStartElement(TraceUtil.getType((Object)obj));
            this.m_xmlWriter.writeEndElement();
            ++n2;
        }
    }

    private void traceObjectState(TraceEvent event) {
        if (event.getArgs() == null || event.getArgs().length == 0) {
            return;
        }
        Object[] objectArray = event.getArgs();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj == null) {
                this.m_xmlWriter.writeStartElement("null");
                this.m_xmlWriter.writeEndElement();
            } else {
                Class<?> type = obj.getClass();
                ITraceObjectIntrospector inspector = this.m_inspectors.get(type);
                if (inspector == null) {
                    inspector = this.m_defaultIntrospector;
                }
                inspector.writeState(obj, (IXmlStreamWriter)this.m_xmlWriter);
            }
            ++n2;
        }
    }

    private void traceJavaBean(TraceEvent event) {
        JavaBeanTraceIntrospector inspector = JavaBeanTraceIntrospector.getDefault();
        if (event.getArgs() == null || event.getArgs().length == 0) {
            return;
        }
        Object[] objectArray = event.getArgs();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            inspector.writeState(obj, (IXmlStreamWriter)this.m_xmlWriter);
            ++n2;
        }
    }

    private void traceNV(TraceEvent event) {
        if (event.getArgs() == null || event.getArgs().length == 0) {
            return;
        }
        Object name = event.getArgs()[0];
        Object value = event.getArgs()[1];
        if (name == null) {
            return;
        }
        this.m_xmlWriter.writeStartElement(XmlEncoder.encode((String)name.toString()));
        if (value != null) {
            this.m_xmlWriter.writeRaw(XmlEncoder.encode((String)value.toString()));
        }
        this.m_xmlWriter.writeEndElement();
    }

    private void traceMsg(TraceEvent event) {
        if (event.getArgs() == null || event.getArgs().length == 0) {
            return;
        }
        this.m_xmlWriter.writeStartElement(TAG_MSG);
        Object msg = event.getArgs()[0];
        if (msg != null) {
            this.m_xmlWriter.writeCData(msg.toString());
        }
        this.m_xmlWriter.writeEndElement();
    }

    private void traceStartLoop(TraceEvent event) {
        Object[] args = event.getArgs();
        if (args == null || args.length == 0) {
            return;
        }
        String objType = TraceUtil.getType((Object)args[0]);
        this.push("Loop." + objType);
        this.m_xmlWriter.writeStartElement(TAG_LOOP);
        this.m_xmlWriter.writeAttribute(ATTR_OBJ, objType);
    }

    private void traceEndLoop(TraceEvent event) {
        Object[] args = event.getArgs();
        if (args == null || args.length == 0) {
            return;
        }
        String objType = TraceUtil.getType((Object)args[0]);
        this.pop("Loop." + objType);
        this.m_xmlWriter.writeEndElement();
    }

    private void traceStartCall(TraceEvent event) {
        Object[] args = event.getArgs();
        if (args == null || args.length == 0) {
            return;
        }
        String objType = TraceUtil.getType((Object)args[0]);
        this.push("Call." + objType);
        this.m_xmlWriter.writeStartElement(TAG_CALL);
        this.m_xmlWriter.writeAttribute("cls", objType);
    }

    private void traceEndCall(TraceEvent event) {
        Object[] args = event.getArgs();
        if (args == null || args.length == 0) {
            return;
        }
        String objType = TraceUtil.getType((Object)args[0]);
        this.pop("Call." + objType);
        this.m_xmlWriter.writeEndElement();
    }

    private void push(String label) {
        if (label == null || label.trim().length() == 0) {
            DsfExceptionHelper.chuck((String)"label is null");
        }
        ++this.m_traceDepth;
        this.m_stackLabels.put((Object)this.m_traceDepth, (Object)label);
    }

    private void pop(String label) {
        if (this.m_stackLabels.remove(this.m_stackLabels.lastKey()) != null) {
            --this.m_traceDepth;
        }
    }
}

