/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;

public class DNotation
extends DNode
implements Notation {
    private static final long serialVersionUID = 5984087719387769295L;
    private String m_publicId;
    private String m_systemId;

    public DNotation(DDocument doc, String name) {
        super(doc, name);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        throw new DOMException(16, "Notation does not support having children");
    }

    @Override
    public final short getNodeType() {
        return 12;
    }

    @Override
    public String getPublicId() {
        return this.m_publicId;
    }

    @Override
    public String getSystemId() {
        return this.m_systemId;
    }

    public DNotation setDsfPublicId(String id) {
        this.setPublicId(id);
        return this;
    }

    public void setPublicId(String id) {
        this.m_publicId = id;
    }

    public DNotation setDsfSystemId(String id) {
        this.setSystemId(id);
        return this;
    }

    public void setSystemId(String id) {
        this.m_systemId = id;
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public DNotation jif(String jif) {
        super.jif(jif);
        return this;
    }

    @Override
    public String toString() {
        StringWriter out = new StringWriter(100);
        this.write(out);
        return out.toString();
    }

    public void write(Writer out) {
        String entityNodeName = this.getNodeName();
        String entityPublicId = this.getPublicId();
        String entitySystemId = this.getSystemId();
        boolean entityHasPublic = false;
        try {
            out.write("<!NOTATION ");
            if (entityNodeName != null) {
                out.write(entityNodeName);
            }
            if (entityPublicId != null) {
                out.write(" PUBLIC \"");
                out.write(entityPublicId);
                out.write("\"");
                entityHasPublic = true;
            }
            if (entitySystemId != null) {
                if (!entityHasPublic) {
                    out.write(" SYSTEM");
                }
                out.write(" \"");
                out.write(entitySystemId);
                out.write("\"");
            }
            out.write(">");
        }
        catch (IOException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }
}

