/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ast.expressions;

import org.eclipse.dltk.mod.ast.DLTKToken;
import org.eclipse.dltk.mod.ast.expressions.Literal;
import org.eclipse.dltk.mod.utils.CorePrinter;

public class NumericLiteral
extends Literal {
    private long intValue;

    public NumericLiteral(DLTKToken number) {
        super(number);
    }

    public NumericLiteral(int start, int end, long value) {
        super(start, end);
        this.intValue = value;
    }

    public long getIntValue() {
        return this.intValue;
    }

    @Override
    public String getValue() {
        return String.valueOf(this.intValue);
    }

    @Override
    public int getKind() {
        return 1055;
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrintLn(this.getValue());
    }
}

