/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.core.environment;

import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.PriorityDLTKExtensionManager;
import org.eclipse.dltk.mod.core.SimplePriorityClassDLTKExtensionManager;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.environment.IEnvironmentChangedListener;
import org.eclipse.dltk.mod.core.environment.IEnvironmentProvider;

public final class EnvironmentManager {
    private static final String ENVIRONMENT_EXTENSION = "org.eclipse.dltk.mod.core.environment";
    private static SimplePriorityClassDLTKExtensionManager manager = new SimplePriorityClassDLTKExtensionManager("org.eclipse.dltk.mod.core.environment", "id");
    private static ListenerList listeners = new ListenerList();

    private EnvironmentManager() {
    }

    public static IEnvironment getEnvironment(IModelElement element) {
        if (element == null) {
            return null;
        }
        IScriptProject scriptProject = element.getScriptProject();
        if (scriptProject == null) {
            return null;
        }
        IProject project = scriptProject.getProject();
        if (project == null) {
            return null;
        }
        return EnvironmentManager.getEnvironment(project);
    }

    public static IEnvironment getEnvironment(IProject project) {
        Object[] objects = manager.getObjects();
        int i = 0;
        while (i < objects.length) {
            IEnvironmentProvider provider = (IEnvironmentProvider)objects[i];
            IEnvironment environment = provider.getProjectEnvironment(project);
            if (environment != null) {
                return environment;
            }
            ++i;
        }
        return null;
    }

    public static IEnvironment[] getEnvironments() {
        LinkedList<IEnvironment> envList = new LinkedList<IEnvironment>();
        Object[] objects = manager.getObjects();
        int i = 0;
        while (i < objects.length) {
            IEnvironmentProvider provider = (IEnvironmentProvider)objects[i];
            envList.addAll(Arrays.asList(provider.getEnvironments()));
            ++i;
        }
        IEnvironment[] environments = new IEnvironment[envList.size()];
        envList.toArray(environments);
        return environments;
    }

    public static boolean isLocal(IEnvironment env) {
        return "org.eclipse.dltk.mod.core.environment.localEnvironment".equals(env.getId());
    }

    public static IEnvironment getEnvironmentById(String envId) {
        PriorityDLTKExtensionManager.ElementInfo[] elementInfos = manager.getElementInfos();
        int i = 0;
        while (i < elementInfos.length) {
            IEnvironmentProvider provider = (IEnvironmentProvider)manager.getInitObject(elementInfos[i]);
            IEnvironment env = provider.getEnvironment(envId);
            if (env != null) {
                return env;
            }
            ++i;
        }
        return null;
    }

    public static void addEnvironmentChangedListener(IEnvironmentChangedListener listener) {
        listeners.add((Object)listener);
    }

    public static void removeEnvironmentChangedListener(IEnvironmentChangedListener listener) {
        listeners.remove((Object)listener);
    }

    public static void environmentAdded(IEnvironment environment) {
        Object[] environmentListeners = listeners.getListeners();
        int i = 0;
        while (i < environmentListeners.length) {
            IEnvironmentChangedListener listener = (IEnvironmentChangedListener)environmentListeners[i];
            listener.environmentAdded(environment);
            ++i;
        }
    }

    public static void environmentRemoved(IEnvironment environment) {
        Object[] environmentListeners = listeners.getListeners();
        int i = 0;
        while (i < environmentListeners.length) {
            IEnvironmentChangedListener listener = (IEnvironmentChangedListener)environmentListeners[i];
            listener.environmentRemoved(environment);
            ++i;
        }
    }

    public static void environmentChanged(IEnvironment environment) {
        Object[] environmentListeners = listeners.getListeners();
        int i = 0;
        while (i < environmentListeners.length) {
            IEnvironmentChangedListener listener = (IEnvironmentChangedListener)environmentListeners[i];
            listener.environmentChanged(environment);
            ++i;
        }
    }

    public static IEnvironment getLocalEnvironment() {
        return EnvironmentManager.getEnvironmentById("org.eclipse.dltk.mod.core.environment.localEnvironment");
    }

    public static void waitInitialized() {
    }
}

