/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.mod.compiler.problem.IProblemReporter;
import org.eclipse.dltk.mod.compiler.task.ITaskReporter;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.builder.IBuildParticipant;
import org.eclipse.dltk.mod.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.internal.core.AccumulatingProblemReporter;
import org.eclipse.dltk.mod.internal.core.builder.AbstractBuildContext;
import org.eclipse.dltk.mod.internal.core.builder.BuildParticipantManager;

public class StructureBuilder {
    public static void build(String natureId, ISourceModule module, AccumulatingProblemReporter reporter) {
        IBuildParticipant participant;
        NullProgressMonitor monitor = new NullProgressMonitor();
        IScriptProject project = module.getScriptProject();
        IBuildParticipant[] validators = BuildParticipantManager.getBuildParticipants(project, natureId);
        if (validators.length == 0) {
            return;
        }
        int j = 0;
        while (j < validators.length) {
            IBuildParticipant participant2 = validators[j];
            if (participant2 instanceof IBuildParticipantExtension) {
                ((IBuildParticipantExtension)((Object)participant2)).beginBuild(10);
            }
            ++j;
        }
        ReconcileBuildContext context = new ReconcileBuildContext(module, reporter);
        try {
            int k = 0;
            while (k < validators.length) {
                participant = validators[k];
                participant.build(context);
                ++k;
            }
        }
        catch (CoreException e) {
            DLTKCore.error("error", e);
        }
        int j2 = 0;
        while (j2 < validators.length) {
            participant = validators[j2];
            if (participant instanceof IBuildParticipantExtension) {
                ((IBuildParticipantExtension)((Object)participant)).endBuild((IProgressMonitor)monitor);
            }
            ++j2;
        }
    }

    private static class ReconcileBuildContext
    extends AbstractBuildContext {
        final AccumulatingProblemReporter reporter;

        protected ReconcileBuildContext(ISourceModule module, AccumulatingProblemReporter reporter) {
            super(module);
            this.reporter = reporter;
        }

        @Override
        public IFileHandle getFileHandle() {
            return null;
        }

        @Override
        public IProblemReporter getProblemReporter() {
            return this.reporter;
        }

        @Override
        public ITaskReporter getTaskReporter() {
            return this.reporter;
        }
    }
}

