/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.BuildpathContainerInitializer;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IBuildpathContainer;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.internal.core.Messages;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.UserLibrary;
import org.eclipse.dltk.mod.internal.core.UserLibraryBuildpathContainer;
import org.eclipse.dltk.mod.internal.core.util.Util;

public class UserLibraryBuildpathContainerInitializer
extends BuildpathContainerInitializer {
    private IDLTKLanguageToolkit toolkit;

    @Override
    public boolean canUpdateBuildpathContainer(IPath containerPath, IScriptProject project) {
        return this.isUserLibraryContainer(containerPath);
    }

    @Override
    public Object getComparisonID(IPath containerPath, IScriptProject project) {
        return containerPath;
    }

    @Override
    public String getDescription(IPath containerPath, IScriptProject project) {
        if (this.isUserLibraryContainer(containerPath)) {
            return containerPath.segment(1);
        }
        return super.getDescription(containerPath, project);
    }

    @Override
    public void initialize(IPath containerPath, IScriptProject project) throws CoreException {
        if (this.isUserLibraryContainer(containerPath)) {
            String userLibName = containerPath.segment(1);
            IDLTKLanguageToolkit tk = DLTKLanguageManager.getLanguageToolkit(project);
            int pos = userLibName.indexOf("#");
            if (tk == null && pos != -1) {
                String nature = userLibName.substring(0, pos);
                tk = DLTKLanguageManager.getLanguageToolkit(nature);
                userLibName = userLibName.substring(pos + 1);
            }
            if (tk == null) {
                tk = this.toolkit;
            }
            if (tk == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.mod.core", Messages.UserLibraryBuildpathContainerInitializer_dltkLanguageToolkitIsNull));
            }
            UserLibrary userLibrary = ModelManager.getUserLibraryManager().getUserLibrary(userLibName, tk);
            if (userLibrary != null) {
                UserLibraryBuildpathContainer container = new UserLibraryBuildpathContainer(userLibName, tk);
                DLTKCore.setBuildpathContainer(containerPath, new IScriptProject[]{project}, new IBuildpathContainer[]{container}, null);
            } else if (ModelManager.BP_RESOLVE_VERBOSE) {
                this.verbose_no_user_library_found(project, userLibName);
            }
        } else if (ModelManager.BP_RESOLVE_VERBOSE) {
            this.verbose_not_a_user_library(project, containerPath);
        }
    }

    private boolean isUserLibraryContainer(IPath path) {
        return path != null && path.segmentCount() == 2 && "org.eclipse.dltk.mod.USER_LIBRARY".equals(path.segment(0));
    }

    @Override
    public void requestBuildpathContainerUpdate(IPath containerPath, IScriptProject project, IBuildpathContainer containerSuggestion) throws CoreException {
        if (this.isUserLibraryContainer(containerPath)) {
            String name = containerPath.segment(1);
            if (containerSuggestion != null) {
                ModelManager.getUserLibraryManager().setUserLibrary(name, containerSuggestion.getBuildpathEntries(project), containerSuggestion.getKind() == 2, this.toolkit);
            } else {
                ModelManager.getUserLibraryManager().removeUserLibrary(name, this.toolkit);
            }
        }
    }

    private void verbose_no_user_library_found(IScriptProject project, String userLibraryName) {
        Util.verbose("UserLibrary INIT - FAILED (no user library found)\n\tproject: " + project.getElementName() + '\n' + "\tuserLibraryName: " + userLibraryName);
    }

    private void verbose_not_a_user_library(IScriptProject project, IPath containerPath) {
        Util.verbose("UserLibrary INIT - FAILED (not a user library)\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath);
    }

    public void setToolkit(IDLTKLanguageToolkit languageToolkit) {
        this.toolkit = languageToolkit;
    }
}

