/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ast.expressions;

import org.eclipse.dltk.mod.ast.ASTVisitor;
import org.eclipse.dltk.mod.ast.DLTKToken;
import org.eclipse.dltk.mod.ast.expressions.Expression;
import org.eclipse.dltk.mod.utils.CorePrinter;

public abstract class Literal
extends Expression {
    protected String fLiteralValue;

    protected Literal(int start, int end) {
        super(start, end);
    }

    protected Literal(DLTKToken token) {
        super(token);
        this.fLiteralValue = token.getText();
    }

    @Override
    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit(this)) {
            pVisitor.endvisit(this);
        }
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    public String getValue() {
        return this.fLiteralValue;
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrintLn("Literal" + this.getSourceRange().toString() + ":" + this.getValue());
    }
}

