/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ti;

import org.eclipse.dltk.mod.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.ti.IContext;
import org.eclipse.dltk.mod.ti.ISourceModuleContext;

public class BasicContext
implements IContext,
ISourceModuleContext {
    private final ISourceModule sourceModule;
    private final ModuleDeclaration rootNode;

    public BasicContext(ISourceModule sourceModule, ModuleDeclaration rootNode) {
        this.sourceModule = sourceModule;
        this.rootNode = rootNode;
    }

    public BasicContext(ISourceModuleContext parent) {
        this.sourceModule = parent.getSourceModule();
        this.rootNode = parent.getRootNode();
    }

    @Override
    public ModuleDeclaration getRootNode() {
        return this.rootNode;
    }

    @Override
    public ISourceModule getSourceModule() {
        return this.sourceModule;
    }

    @Override
    public String getLangNature() {
        IDLTKLanguageToolkit languageToolkit;
        if (this.sourceModule != null && (languageToolkit = DLTKLanguageManager.getLanguageToolkit(this.sourceModule)) != null) {
            return languageToolkit.getNatureId();
        }
        return null;
    }

    public String toString() {
        return "BasicContext, module " + this.sourceModule.getElementName();
    }
}

