/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.dltk.mod.compiler.env.ISourceField;
import org.eclipse.dltk.mod.compiler.env.ISourceMethod;
import org.eclipse.dltk.mod.compiler.env.ISourceType;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.MemberElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.SourceField;
import org.eclipse.dltk.mod.internal.core.SourceMethod;
import org.eclipse.dltk.mod.internal.core.SourceType;

public class SourceTypeElementInfo
extends MemberElementInfo
implements ISourceType {
    protected static final SourceField[] NO_FIELDS = new SourceField[0];
    protected static final SourceMethod[] NO_METHODS = new SourceMethod[0];
    protected static final SourceType[] NO_TYPES = new SourceType[0];
    protected String[] superclassNames;
    protected IType handle = null;

    protected void setHandle(IType handle) {
        this.handle = handle;
    }

    protected void setSuperclassNames(String[] superclassNames) {
        this.superclassNames = superclassNames;
    }

    public String[] getSuperclassNames() {
        return this.superclassNames;
    }

    @Override
    public ISourceType getEnclosingType() {
        IModelElement parent = this.handle.getParent();
        if (parent != null && parent.getElementType() == 7) {
            try {
                return (ISourceType)((ModelElement)parent).getElementInfo();
            }
            catch (ModelException modelException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public ISourceField[] getFields() {
        SourceField[] fieldHandles = this.getFieldHandles();
        int length = fieldHandles.length;
        ISourceField[] fields = new ISourceField[length];
        int i = 0;
        while (i < length) {
            try {
                ISourceField field;
                fields[i] = field = (ISourceField)fieldHandles[i].getElementInfo();
            }
            catch (ModelException modelException) {}
            ++i;
        }
        return fields;
    }

    @Override
    public ISourceType[] getMemberTypes() {
        return null;
    }

    @Override
    public ISourceMethod[] getMethods() {
        return null;
    }

    @Override
    public char[] getName() {
        return null;
    }

    @Override
    public char[] getSuperclassName() {
        return null;
    }

    @Override
    public char[][][] getTypeParameterBounds() {
        return null;
    }

    @Override
    public char[][] getTypeParameterNames() {
        return null;
    }

    @Override
    public boolean isBinaryType() {
        return false;
    }

    @Override
    public char[] getFileName() {
        return null;
    }

    public SourceField[] getFieldHandles() {
        int length = this.size();
        if (length == 0) {
            return NO_FIELDS;
        }
        SourceField[] fields = new SourceField[length];
        int fieldIndex = 0;
        int i = 0;
        while (i < length) {
            IModelElement child = this.get(i);
            if (child instanceof SourceField) {
                fields[fieldIndex++] = (SourceField)child;
            }
            ++i;
        }
        if (fieldIndex == 0) {
            return NO_FIELDS;
        }
        if (fieldIndex < length) {
            SourceField[] sourceFieldArray = fields;
            fields = new SourceField[fieldIndex];
            System.arraycopy(sourceFieldArray, 0, fields, 0, fieldIndex);
        }
        return fields;
    }

    public IType getHandle() {
        return this.handle;
    }
}

