/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.utils.Messages;
import org.eclipse.osgi.util.NLS;

public class NatureExtensionManager {
    private final String extensionPoint;
    protected final String classAttr = "class";
    private final String universalNatureId;
    private final Class elementType;
    private Map extensions;

    public NatureExtensionManager(String extensionPoint, Class elementType) {
        this(extensionPoint, elementType, null);
    }

    public NatureExtensionManager(String extensionPoint, Class elementType, String universalNatureId) {
        this.extensionPoint = extensionPoint;
        this.elementType = elementType;
        this.universalNatureId = universalNatureId;
    }

    private synchronized void initialize() {
        if (this.extensions != null) {
            return;
        }
        this.extensions = new HashMap(5);
        this.registerConfigurationElements();
        for (List descriptors : this.extensions.values()) {
            this.initializeDescriptors(descriptors);
        }
    }

    protected void registerConfigurationElements() {
        this.registerConfigurationElements(Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPoint), this.getCategoryAttributeName());
    }

    protected void registerConfigurationElements(IConfigurationElement[] confElements, String categoryAttr) {
        int i = 0;
        while (i < confElements.length) {
            IConfigurationElement confElement = confElements[i];
            String category = confElement.getAttribute(categoryAttr);
            if (category != null) {
                ArrayList<Object> elements = (ArrayList<Object>)this.extensions.get(category);
                if (elements == null) {
                    elements = new ArrayList<Object>();
                    this.extensions.put(category, elements);
                }
                elements.add(this.createDescriptor(confElement));
            } else {
                Object[] bindings = new String[]{categoryAttr, this.extensionPoint, confElement.getContributor().getName()};
                String msg = NLS.bind((String)Messages.NatureExtensionManager_missingCategoryAttribute, (Object[])bindings);
                DLTKCore.warn(msg);
            }
            ++i;
        }
    }

    protected String getCategoryAttributeName() {
        return "nature";
    }

    protected void initializeDescriptors(List descriptors) {
    }

    public Object[] getInstances(String natureId) {
        Object[] all;
        this.initialize();
        Object[] nature = this.getByNature(natureId);
        Object[] objectArray = all = this.universalNatureId != null ? this.getByNature(this.universalNatureId) : null;
        if (nature != null) {
            if (all != null) {
                Object[] result = this.createArray(all.length + nature.length);
                System.arraycopy(nature, 0, result, 0, nature.length);
                System.arraycopy(all, 0, result, nature.length, all.length);
                return result;
            }
            return nature;
        }
        if (all != null) {
            return all;
        }
        return this.createEmptyResult();
    }

    public Object[] getAllInstances() {
        this.initialize();
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator i = this.extensions.keySet().iterator();
        while (i.hasNext()) {
            Object[] natureInstances = this.getByNature((String)i.next());
            if (natureInstances == null) continue;
            int j = 0;
            while (j < natureInstances.length) {
                result.add(natureInstances[j]);
                ++j;
            }
        }
        Object[] resultArray = this.createArray(result.size());
        result.toArray(resultArray);
        return resultArray;
    }

    protected Object[] createEmptyResult() {
        return null;
    }

    private Object[] createArray(int length) {
        return (Object[])Array.newInstance(this.elementType, length);
    }

    protected boolean isInstance(Object e) {
        return this.elementType.isAssignableFrom(e.getClass());
    }

    protected boolean isValidInstance(Object e) {
        return this.isInstance(e);
    }

    private Object[] getByNature(String natureId) {
        Object ext = this.extensions.get(natureId);
        if (ext != null) {
            if (ext instanceof Object[]) {
                return (Object[])ext;
            }
            if (ext instanceof List) {
                List elements = (List)ext;
                ArrayList<Object> result = new ArrayList<Object>(elements.size());
                int i = 0;
                while (i < elements.size()) {
                    Object element = elements.get(i);
                    if (this.isInstance(element)) {
                        result.add(element);
                    } else {
                        try {
                            Object instance = this.createInstanceByDescriptor(element);
                            if (instance != null && this.isValidInstance(instance)) {
                                result.add(instance);
                            }
                        }
                        catch (Exception e) {
                            String msg = NLS.bind((String)Messages.NatureExtensionManager_instantiantionError, (Object)this.elementType.getName());
                            DLTKCore.error(msg, e);
                        }
                    }
                    ++i;
                }
                Object[] resultArray = this.createArray(result.size());
                result.toArray(resultArray);
                this.extensions.put(natureId, resultArray);
                return resultArray;
            }
        }
        return null;
    }

    protected Object createDescriptor(IConfigurationElement confElement) {
        return confElement;
    }

    protected Object createInstanceByDescriptor(Object descriptor) throws CoreException {
        IConfigurationElement cfg = (IConfigurationElement)descriptor;
        return cfg.createExecutableExtension("class");
    }
}

