/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.debug.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.dltk.mod.debug.core.model.IScriptMethodEntryBreakpoint;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptLineBreakpoint;

public class ScriptMethodEntryBreakpoint
extends ScriptLineBreakpoint
implements IScriptMethodEntryBreakpoint {
    private static final String METHOD_NAME = "org.eclipse.dltk.mod.debug.methodName";
    private static final String BREAK_ON_ENTRY = "org.eclipse.dltk.mod.debug.methodEntry";
    private static final String BREAK_ON_EXIT = "org.eclipse.dltk.mod.debug.methodExit";
    private static final String ENTRY_ID = "org.eclipse.dltk.mod.debug.entryBrId";
    private static final String EXIT_ID = "org.eclipse.dltk.mod.debug.exitBrId";
    private static final String[] UPDATABLE_ATTRS = new String[]{"org.eclipse.dltk.mod.debug.methodName", "org.eclipse.dltk.mod.debug.methodEntry", "org.eclipse.dltk.mod.debug.methodExit"};

    @Override
    protected String getMarkerId() {
        return "org.eclipse.dltk.mod.debug.scriptMethodEntryBreakpointMarker";
    }

    public ScriptMethodEntryBreakpoint() {
    }

    public ScriptMethodEntryBreakpoint(String debugModelId, IResource resource, IPath path, int lineNumber, int charStart, int charEnd, boolean register, String methodName) throws DebugException {
        super(debugModelId, resource, path, lineNumber, charStart, charEnd, register);
        try {
            this.ensureMarker().setAttribute(METHOD_NAME, (Object)methodName);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    @Override
    public String getMethodName() throws CoreException {
        return this.ensureMarker().getAttribute(METHOD_NAME, "");
    }

    @Override
    public boolean breakOnEntry() throws CoreException {
        return this.ensureMarker().getAttribute(BREAK_ON_ENTRY, false);
    }

    @Override
    public void setBreakOnEntry(boolean value) throws CoreException {
        this.ensureMarker().setAttribute(BREAK_ON_ENTRY, value);
    }

    @Override
    public boolean breakOnExit() throws CoreException {
        return this.ensureMarker().getAttribute(BREAK_ON_EXIT, false);
    }

    @Override
    public void setBreakOnExit(boolean value) throws CoreException {
        this.ensureMarker().setAttribute(BREAK_ON_EXIT, value);
    }

    @Override
    public String getEntryBreakpointId() throws CoreException {
        return this.ensureMarker().getAttribute(ENTRY_ID, null);
    }

    @Override
    public void setEntryBreakpointId(String id) throws CoreException {
        this.ensureMarker().setAttribute(ENTRY_ID, (Object)id);
    }

    @Override
    public String getExitBreakpointId() throws CoreException {
        return this.ensureMarker().getAttribute(EXIT_ID, null);
    }

    @Override
    public void setExitBreakpointId(String id) throws CoreException {
        this.ensureMarker().setAttribute(EXIT_ID, (Object)id);
    }

    @Override
    public String[] getUpdatableAttributes() {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(Arrays.asList(super.getUpdatableAttributes()));
        all.addAll(Arrays.asList(UPDATABLE_ATTRS));
        return all.toArray(new String[all.size()]);
    }
}

