/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.launching.execution;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.environment.IDeployment;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.core.internal.environment.EFSFileHandle;
import org.eclipse.dltk.mod.internal.launching.execution.DeploymentManager;
import org.eclipse.dltk.mod.internal.launching.execution.Messages;
import org.osgi.framework.Bundle;

public class EFSDeployment
implements IDeployment {
    private IFileStore root;
    private IEnvironment environment;

    public EFSDeployment(IEnvironment env, URI rootURI) throws CoreException {
        this.environment = env;
        this.root = EFS.getStore((URI)rootURI);
        this.root.mkdir(0, null);
        DeploymentManager.getInstance().addDeployment(this);
    }

    public IPath add(Bundle bundle, String bundlePath) throws IOException {
        try {
            IFileStore dest = this.root.getChild((IPath)new Path(bundlePath));
            Enumeration paths = bundle.getEntryPaths(bundlePath);
            if (paths != null) {
                dest.mkdir(0, null);
                while (paths.hasMoreElements()) {
                    String path = (String)paths.nextElement();
                    if (path.endsWith("/")) {
                        if (path.endsWith("/CVS/") || path.endsWith("/.svn/")) continue;
                        this.add(bundle, path);
                        continue;
                    }
                    EFSDeployment.copy(bundle.getEntry(path), this.root.getChild(path));
                }
            } else {
                URL url = bundle.getEntry(bundlePath);
                if (url == null) {
                    throw new IOException(MessageFormat.format(Messages.EFSDeployment_failedToLocateEntryForPath, bundlePath));
                }
                IFileStore parent = dest.getParent();
                if (parent != null) {
                    parent.mkdir(0, null);
                }
                EFSDeployment.copy(url, dest);
            }
        }
        catch (CoreException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        return new Path(bundlePath);
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        int ch = -1;
        while ((ch = input.read()) != -1) {
            output.write(ch);
        }
    }

    private static void copy(InputStream input, IFileStore file) throws IOException, CoreException {
        OutputStream output = null;
        try {
            output = new BufferedOutputStream(file.openOutputStream(0, null), 4096);
            EFSDeployment.copy(input, output);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    private static void copy(URL url, IFileStore file) throws IOException, CoreException {
        InputStream input = null;
        try {
            input = url.openStream();
            EFSDeployment.copy(input, file);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public void dispose() {
        block2: {
            try {
                this.root.delete(0, null);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        DeploymentManager.getInstance().removeDeployment(this);
    }

    public IPath getAbsolutePath() {
        return new Path(this.root.toURI().getPath());
    }

    public IFileHandle getFile(IPath deploymentPath) {
        return new EFSFileHandle(this.environment, this.root.getChild(deploymentPath));
    }

    public void mkdirs(IPath path) {
        block2: {
            try {
                this.root.getChild(path).mkdir(0, null);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public IPath add(InputStream input, String filename) throws IOException {
        IFileStore dest = this.root.getChild(filename);
        try {
            EFSDeployment.copy(input, dest);
        }
        catch (CoreException e) {
            throw new IOException(MessageFormat.format(Messages.EFSDeployment_failedToDeployStream, e.getMessage()));
        }
        return new Path(filename);
    }
}

