/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.mod.internal.launching.DebugRunnerDelegate;
import org.eclipse.dltk.mod.launching.EnvironmentVariable;
import org.eclipse.dltk.mod.launching.ExecutionArguments;
import org.eclipse.dltk.mod.launching.IInterpreterInstall;
import org.eclipse.dltk.mod.launching.IInterpreterInstallChangedListener;
import org.eclipse.dltk.mod.launching.IInterpreterInstallType;
import org.eclipse.dltk.mod.launching.IInterpreterRunner;
import org.eclipse.dltk.mod.launching.LibraryLocation;
import org.eclipse.dltk.mod.launching.PropertyChangeEvent;
import org.eclipse.dltk.mod.launching.ScriptRuntime;

public abstract class AbstractInterpreterInstall
implements IInterpreterInstall {
    private IInterpreterInstallType fType;
    private String fId;
    private String fName;
    private IFileHandle fInstallLocation;
    private LibraryLocation[] fSystemLibraryDescriptions;
    private String fInterpreterArgs;
    private EnvironmentVariable[] fEnvironmentVariables;
    private boolean fNotify = true;

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fNotify) {
            ScriptRuntime.fireInterpreterChanged(event);
        }
    }

    public AbstractInterpreterInstall(IInterpreterInstallType type, String id) {
        if (type == null || id == null) {
            throw new IllegalArgumentException();
        }
        this.fType = type;
        this.fId = id;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        if (!name.equals(this.fName)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_NAME, this.fName, name);
            this.fName = name;
            this.firePropertyChangeEvent(event);
        }
    }

    @Override
    public IFileHandle getInstallLocation() {
        return this.fInstallLocation;
    }

    @Override
    public IFileHandle getRawInstallLocation() {
        return this.fInstallLocation;
    }

    @Override
    public IEnvironment getEnvironment() {
        if (this.fInstallLocation != null) {
            return this.fInstallLocation.getEnvironment();
        }
        return null;
    }

    @Override
    public IExecutionEnvironment getExecEnvironment() {
        IEnvironment environment = this.getEnvironment();
        if (environment != null) {
            return (IExecutionEnvironment)environment.getAdapter(IExecutionEnvironment.class);
        }
        return null;
    }

    @Override
    public void setInstallLocation(IFileHandle installLocation) {
        if (!installLocation.equals(this.fInstallLocation)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_INSTALL_LOCATION, this.fInstallLocation, installLocation);
            this.fInstallLocation = installLocation;
            this.firePropertyChangeEvent(event);
        }
    }

    @Override
    public IInterpreterInstallType getInterpreterInstallType() {
        return this.fType;
    }

    @Override
    public LibraryLocation[] getLibraryLocations() {
        return this.fSystemLibraryDescriptions;
    }

    @Override
    public void setLibraryLocations(LibraryLocation[] locations) {
        LibraryLocation[] prevLocations;
        if (locations == this.fSystemLibraryDescriptions) {
            return;
        }
        LibraryLocation[] newLocations = locations;
        if (newLocations == null) {
            newLocations = this.getInterpreterInstallType().getDefaultLibraryLocations(this.getInstallLocation(), this.getEnvironmentVariables(), null);
        }
        if ((prevLocations = this.fSystemLibraryDescriptions) == null) {
            prevLocations = this.getInterpreterInstallType().getDefaultLibraryLocations(this.getInstallLocation(), this.getEnvironmentVariables(), null);
        }
        if (newLocations.length == prevLocations.length) {
            int i = 0;
            boolean equal = true;
            while (i < newLocations.length && equal) {
                equal = newLocations[i].equals(prevLocations[i]);
                ++i;
            }
            if (equal) {
                return;
            }
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_LIBRARY_LOCATIONS, prevLocations, newLocations);
        this.fSystemLibraryDescriptions = locations;
        this.firePropertyChangeEvent(event);
    }

    protected void setNotify(boolean notify) {
        this.fNotify = notify;
    }

    public boolean equals(Object object) {
        if (object instanceof IInterpreterInstall) {
            IInterpreterInstall Interpreter = (IInterpreterInstall)object;
            return this.getInterpreterInstallType().equals(Interpreter.getInterpreterInstallType()) && this.getId().equals(Interpreter.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getInterpreterInstallType().hashCode() + this.getId().hashCode();
    }

    @Override
    public String[] getInterpreterArguments() {
        String args = this.getInterpreterArgs();
        if (args == null) {
            return null;
        }
        ExecutionArguments ex = new ExecutionArguments(args, "");
        return ex.getInterpreterArgumentsArray();
    }

    @Override
    public void setInterpreterArguments(String[] args) {
        if (args == null) {
            this.setInterpreterArgs(null);
        } else {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < args.length) {
                String string = args[i];
                buf.append(string);
                buf.append(' ');
                ++i;
            }
            this.setInterpreterArgs(buf.toString().trim());
        }
    }

    @Override
    public String getInterpreterArgs() {
        return this.fInterpreterArgs;
    }

    @Override
    public void setInterpreterArgs(String args) {
        if (this.fInterpreterArgs == null ? args == null : this.fInterpreterArgs.equals(args)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_Interpreter_ARGUMENTS, this.fInterpreterArgs, args);
        this.fInterpreterArgs = args;
        this.firePropertyChangeEvent(event);
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public String[] getBuiltinModules() {
        return null;
    }

    public String getBuiltinModuleContent(String name) {
        return null;
    }

    public long lastModified() {
        return 0L;
    }

    protected IInterpreterRunner getDebugInterpreterRunner() {
        return new DebugRunnerDelegate(this);
    }

    @Override
    public IInterpreterRunner getInterpreterRunner(String mode) {
        if (mode.equals("debug")) {
            return this.getDebugInterpreterRunner();
        }
        return null;
    }

    @Override
    public EnvironmentVariable[] getEnvironmentVariables() {
        return this.fEnvironmentVariables;
    }

    @Override
    public void setEnvironmentVariables(EnvironmentVariable[] variables) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_ENVIRONMENT_VARIABLES, this.fEnvironmentVariables, variables);
        this.fEnvironmentVariables = variables;
        this.firePropertyChangeEvent(event);
    }
}

