/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.mod.core.PreferencesLookupDelegate;
import org.eclipse.dltk.mod.debug.core.IDbgpService;
import org.eclipse.dltk.mod.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.mod.internal.debug.core.model.RemoteScriptDebugTarget;
import org.eclipse.dltk.mod.launching.DebuggingEngineRunner;
import org.eclipse.dltk.mod.launching.IInterpreterInstall;
import org.eclipse.dltk.mod.launching.InterpreterConfig;

public abstract class RemoteDebuggingEngineRunner
extends DebuggingEngineRunner {
    public RemoteDebuggingEngineRunner(IInterpreterInstall install) {
        super(install);
    }

    @Override
    protected IScriptDebugTarget createDebugTarget(ILaunch launch, IDbgpService dbgpService) throws CoreException {
        return new RemoteScriptDebugTarget(this.getDebugModelId(), dbgpService, this.getSessionId(launch.getLaunchConfiguration()), launch, null);
    }

    @Override
    protected String getSessionId(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("dbgp_session_id", "");
    }

    protected InterpreterConfig addEngineConfig(InterpreterConfig config, PreferencesLookupDelegate delegate) {
        return this.addEngineConfig(config, delegate, null);
    }

    @Override
    protected InterpreterConfig addEngineConfig(InterpreterConfig config, PreferencesLookupDelegate delegate, ILaunch launch) {
        return config;
    }

    @Override
    public void run(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.initializeLaunch(launch, config, this.createPreferencesLookupDelegate(launch));
            this.waitDebuggerConnected(null, launch, monitor);
        }
        catch (CoreException e) {
            launch.terminate();
            throw e;
        }
    }

    @Override
    protected String getDebuggingEngineId() {
        return null;
    }

    @Override
    protected String getDebuggingEnginePreferenceQualifier() {
        return this.getDebugPreferenceQualifier();
    }

    protected String getLoggingEnabledPreferenceKey() {
        return null;
    }

    @Override
    protected String getLogFileNamePreferenceKey() {
        return null;
    }

    protected String getLogFilePathPreferenceKey() {
        return null;
    }
}

