/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.launching.sourcelookup;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelElementVisitor;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.mod.internal.launching.IPathEquality;
import org.eclipse.dltk.mod.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.mod.internal.launching.PathEqualityUtils;
import org.eclipse.dltk.mod.launching.sourcelookup.DBGPSourceModule;

public class ScriptSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    public String getSourceName(Object object) throws CoreException {
        ScriptStackFrame frame = (ScriptStackFrame)object;
        String path = frame.getFileName().getPath();
        if (path.length() == 0) {
            return null;
        }
        String root = this.getProjectRoot();
        if (path.indexOf(root) != -1) {
            return path.substring(root.length() + 1);
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(path));
        IProject project = LaunchConfigurationUtils.getProject(this.getDirector().getLaunchConfiguration());
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            if (file.exists() && file.getProject().equals((Object)project)) {
                return file.getProjectRelativePath().toString();
            }
            ++i;
        }
        return path;
    }

    private IEnvironment getEnvironment() {
        IProject project = LaunchConfigurationUtils.getProject(this.getDirector().getLaunchConfiguration());
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        return EnvironmentManager.getEnvironment((IModelElement)scriptProject);
    }

    protected String getProjectRoot() throws CoreException {
        IProject project = LaunchConfigurationUtils.getProject(this.getDirector().getLaunchConfiguration());
        return project.getLocationURI().getPath();
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        Object[] elements = super.findSourceElements(object);
        if (elements.length > 0) {
            return elements;
        }
        ILaunchConfiguration launchConfiguration = this.getDirector().getLaunchConfiguration();
        IProject project = LaunchConfigurationUtils.getProject(launchConfiguration);
        ScriptProject scriptProject = (ScriptProject)DLTKCore.create((IProject)project);
        ScriptStackFrame frame = (ScriptStackFrame)object;
        String path = frame.getFileName().getPath();
        final IFileHandle file = this.getEnvironment().getFile((IPath)new Path(path));
        Object[] result = new ISourceModule[1];
        if (file.exists()) {
            scriptProject.accept(new IModelElementVisitor((ISourceModule[])result){
                final IPathEquality pathEquality = PathEqualityUtils.getInstance();
                private final /* synthetic */ ISourceModule[] val$result;
                {
                    this.val$result = iSourceModuleArray;
                }

                public boolean visit(IModelElement element) {
                    IProjectFragment fragment;
                    if (element.getElementType() == 3 && !(fragment = (IProjectFragment)element).isExternal()) {
                        return false;
                    }
                    if (element.getElementType() == 5) {
                        ISourceModule module = (ISourceModule)element;
                        IPath modulePath = module.getPath();
                        if (this.pathEquality.equals(file.getFullPath(), modulePath)) {
                            this.val$result[0] = module;
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        if (result[0] != null) {
            return result;
        }
        return new Object[]{new DBGPSourceModule(scriptProject, frame.getFileName().getPath(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, frame)};
    }
}

